// <?import /JavaScript/Util/HTML.js?>
// <?import /JavaScript/DefaultTextField/DefaultTextField.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/Util/RegExp.js?>
// <?import /JavaScript/jQuery/jquery.js?>

// <?import /JavaScript/yui-import/YahooGlobalObject.js?>
// <?import /JavaScript/yui-import/Dom.js?>
// <?import /JavaScript/yui-import/Event.js?>
// <?import /JavaScript/yui-import/AutoComplete.js?>

WR.ComboBox = function( containerEl, dataSource, defaultText /* (optional) */, width /* (optional) */ ) {	
	var input = new WR.DOM.Element( "input" )
		.addClass( "yui-ac-input" )
		.addClass( "ComboBoxInput" )
		.setProperty( "type", "text" )
		.finish();
	var options = new WR.DOM.Element( "div" )
		.addClass( "yui-ac-container" )
		.addClass( "ComboBoxOptions" )
		.finish();
		
	new WR.DOM.Element( containerEl )
		.appendChild( input )
		.appendChild( options );
	
	WR.ComboBox.superclass.constructor.call( this, input, options, dataSource );
	
	this.forceSelection = false;
	this.typeAhead = false;
	this.resultTypeList = false;
	this.minQueryLength = 0;
	this.queryDelay = 0.1;
	this.animVert = false;
	
	this.width = width;
	
	YAHOO.util.Event.addListener( this.getInputEl(), "keypress", function( event, me ) {
		if ( event.keyCode == 40 /*down*/ && !me.isContainerOpen() )
			me.sendQuery( "" );
	}, this );
	
	this.containerCollapseEvent.subscribe( function( type, args, me ) {
		WR.DOM.el( me.getContainerEl() ).setStyle( "z-index", -1 );
	}, this );
	
	this.itemSelectEvent.subscribe( function( type, args, me ) {
		me._validSelection( args[2] );
	}, this );
	
	this.unmatchedItemSelectEvent.subscribe( function( type, args, me ) {
		if ( $( input ).val() == '' )
		{
			me._validSelection( {name: '', id: '', displayName: '' } );
		}
		else if ( $( input ).val() == me.defaultTextField.unselectedText )
		{
			this._currentData = { name: '', id: '', displayName: '' };
			$( this.getInputEl() ).removeClass( 'InvalidSelection' );
		}
		else
		{
			me._invalidSelection(
			{
				name : $( input ).val(),
				id : $( input ).val(),
				displayName: $( input ).val()
			} );
		}
	}, this );
	
	this.defaultTextField = new WR.DefaultTextField( input, defaultText );
	this._dataSource = dataSource;
};

WR.ComboBox.prototype = {
	
	getCurrentData : function() {
		return this._currentData;
	},
	
	doBeforeExpandContainer : function( elTextbox, elContainer, sQuery, aResults ) {
		WR.DOM.el( elContainer ).setStyle( "z-index", 100 );
		
		YAHOO.util.Dom.setX( elContainer, YAHOO.util.Dom.getX( elTextbox ) );
		
		if ( this.width != null )
			YAHOO.util.Dom.setStyle( elContainer, 'width', this.width + 'px' );
		
		if ( aResults.length > 0 )
				this._highlightFirstPrefixResult( sQuery, aResults );
		
		return true;
	},
	
	_validSelection : function( data )
	{
		this._currentData = data;
		this.defaultTextField.format();
		$( this.getInputEl() ).removeClass( 'InvalidSelection' );
	},
	
	_invalidSelection : function( data )
	{
		this._currentData = data;
		this.defaultTextField.format();
		$( this.getInputEl() ).addClass( 'InvalidSelection' );
	},
	
	_highlightFirstPrefixResult : function( sQuery, aResults )
	{
		var result = WR.Array.binarySearch( aResults, { displayName: sQuery }, function( a, b ) {
				return WR.Array.caseInsensitiveCompare( a.displayName, b.displayName );
		} );
		
		//If we found an exact match, or a prefix match, point to it.
		var indexToPointTo = 0;
		if ( result.found 
			|| ( result.index < aResults.length && WR.Array.caseInsensitiveCompare( aResults[ result.index ].displayName.substr( 0, sQuery.length ), sQuery ) == 0 ) )
		{
				indexToPointTo = result.index;
		}
		
		//We are using undocumented code from YUI's autocomplete.js here.  Be careful when upgrading YUI. This code is replicating what's done in lines 1916-1919 of
		//autocomplete.js, in YAHOO.widget.AutoComplete.prototype._populateList.
		var elToPointTo = this._elList.children[ indexToPointTo ];
		this._toggleHighlight(elToPointTo,"to");
		this.itemArrowToEvent.fire(this, elToPointTo);
		this._typeAhead(elToPointTo,sQuery);
		
		var indexAbove = indexToPointTo - 2;
		if( indexAbove < 0 )
			indexAbove = 0;
		
		var elToScrollTo = this._elList.children[ indexAbove ];
		$( this.getContainerEl() ).find( '.yui-ac-bd' ).scrollTop( elToScrollTo.offsetTop );
	},
	
	_getRegex : function( query ) {
		return new RegExp( WR.RegExp.escape( decodeURIComponent( query ) ), "i" );
	},
	
	formatResult : function( oResultData, sQuery, sResultMatch ) {
		var displayValue = this.getDisplayValue( oResultData );
		
		if ( sQuery.length == 0 )
			return WR.HTML.escape( displayValue );
		
		var pos = displayValue.search( this._getRegex( sQuery ) );
		
		var prefix = displayValue.substring( 0, pos );
		var match = displayValue.substring( pos, pos + sQuery.length );
		var suffix = displayValue.substring( pos + sQuery.length );
		
		return WR.HTML.escape( prefix ) + "<b>" + WR.HTML.escape( match ) + "</b>" + WR.HTML.escape( suffix );
	},
	
	filterResults : function( sQuery, oFullResponse, oParsedResponse, oCallback ) {
		var regex = oCallback.scope._getRegex( sQuery );
		
		var filteredResponse = { meta : oParsedResponse.meta, results : [] };
		
		for ( var i = 0; i < oParsedResponse.results.length; i++ ) {
			if ( oCallback.scope.getDisplayValue( oParsedResponse.results[i] ).search( regex ) != -1 )
				filteredResponse.results.push( oParsedResponse.results[i] );
		}
		
		return filteredResponse;
	},
	
	getDisplayValue : function( oResultData ) {
		return oResultData;
	}
	
};

YAHOO.lang.extend( WR.ComboBox, YAHOO.widget.AutoComplete, WR.ComboBox.prototype );
