// <?import /JavaScript/json2.js?>
// <?import /JavaScript/Util/URL.js?>
// <?import /JavaScript/yui-import/YahooGlobalObject.js?>
// <?import /JavaScript/DataTable/DataTable.js?>


WR.DynamicDataTable = function( opts )
{
    WR.DynamicDataTable.superclass.constructor.call( this, opts );
    
    this.columnOrder = null;
};

WR.DynamicDataTable.prototype = {
    
    loadInitialState : function( state, me )
    {
        WR.DynamicDataTable.superclass.loadInitialState.call( this, state, me );
        
        if ( state != null )
        {
            var params = WR.URL.ParseParams( state );
            if ( params.columnOrder != null )
            {
                me.columnOrder = JSON.parse( params.columnOrder[0] );
            }
        }
    },
    
    _onColumnReorder : function()
    {
        this.columnOrder = {};
        for ( var i in this.getColumnSet().keys )
        {
            this.columnOrder[ this.getColumnSet().keys[i].getKey() ] = i;
        }
        
        this.request = this.buildRequest( this.getState() );
        this.history.update();
    },
    
    doBeforeLoadData : function( oRequest, oResponse, oPayload )
    {
        if ( !WR.DynamicDataTable.superclass.doBeforeLoadData.call( this, oRequest, oResponse, oPayload ) )
            return false;
        
        var columns = oResponse.meta.columns;
        
        if ( columns != null && this.columnOrder != null )
        {
            var newColumns = [];
            var updatedColumns = [];
            
            //Rearrange existing columns
            for ( var i = 0; i < columns.length; i++ )
            {
                if ( this.columnOrder[ columns[i].key ] != null )
                    updatedColumns[ this.columnOrder[ columns[i].key] ] = columns[i];
                else
                    newColumns.push( columns[i] );
            }
            
            //If there are gaps, possibly from deleted columns, remove them
            var gaplessColumns = [];
            for ( var i = 0; i < updatedColumns.length; i++ )
            {
                if ( updatedColumns[i] != null )   
                    gaplessColumns.push( updatedColumns[i] );
            }
            
            //If columns have been added, insert them all starting in the second column
            if ( newColumns.length > 0 )
            {
                gaplessColumns = gaplessColumns.slice( 0, 1 ).concat( newColumns, gaplessColumns.slice( 1 ) );
            }
            
            //Update the column order with any changes
            this.columnOrder = {};
            for ( var i = 0; i < gaplessColumns.length; i++ )
            {
                this.columnOrder[ gaplessColumns[i].key ] = i;
            }
            
            oResponse.meta.columns = gaplessColumns;
        }
        
        return true;
    },
    
    buildRequest : function( oState, columns )
    {
        var request = WR.DataTable.prototype.buildRequest.call( this, oState );
            
        if ( columns == null )
        {
            columns = [];
            var columnSet = this.getColumnSet().keys;
            for ( var i in columnSet )
            {
                columns.push( { key: columnSet[i].getKey() } );
            }
        }
        var keys = [];
        for ( var i in columns )
        {
            keys.push( columns[i].key );
        }
        
        var params = { c : keys };
        if ( this.columnOrder != null )
            params.columnOrder = JSON.stringify( this.columnOrder );
        
        return request + '&' + WR.URL.paramsToString( params );
    }
    
};

YAHOO.lang.extend( WR.DynamicDataTable, WR.DataTable, WR.DynamicDataTable.prototype );
