// <?import /JavaScript/Util/HTML.js?>
// <?import /JavaScript/DataTable/DynamicDataTable.js?>
// <?import /JavaScript/Util/GetRequest.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/Util/Array.js?>
// <?import /JavaScript/Util/URL.js?>

// <?import /JavaScript/yui-import/Paginator.js?>
// <?import /JavaScript/yui-import/DataTable.js?>
// <?import /JavaScript/yui-import/YahooGlobalObject.js?>

WR.PropertiesDataTable = function( opts, columns )
{  
    var me = this;
    
    this.expandedProperties = opts.expandedProperties;
    this.expandColumnNames = opts.expandColumnNames;
    
    this.propertyFormatter = function( elCell, oRecord, oColumn ) {
        formatProperty( elCell, oRecord, oColumn, me );
    };
    
    this.customPropertyFormatters = opts.customPropertyFormatters;
    
    if ( !this.customPropertyFormatters )
        this.customPropertyFormatters = {};
    
    
    opts.columns = [];
	opts.sortDir = "asc";
    opts.defaultFormatter = this.propertyFormatter;
    opts.config = {
        initialRequest: this.generateInitialRequest( opts, columns ),
        dynamicData: true,
        draggableColumns: true,
        paginator: new YAHOO.widget.Paginator( {
            rowsPerPage        : opts.pagination.rowsPerPage,
            alwaysVisible      : true,
            containers         : opts.pagination.containers,
            template           : opts.pagination.template,
            pageReportTemplate : opts.pagination.pageReportTemplate
        })
    };
    opts.filter = {
        filterInputID : opts.filterID,
        filterContainerID : opts.filterContainerID,
        defaultText : opts.filterText,
        pageSize : opts.pagination.rowsPerPage
    };
    opts.statusContainer = opts.statusID;
    
    var me = this;
    var redirectToExport = function( exportURL ) {
        var fragment = WR.URL.getHash( window.location.href );
        
        var params = fragment
                        ? WR.URL.ParseParams( fragment ) // This is necessary to show charts on the printable page
                        : WR.URL.ParseParams( me.buildRequest( me.getState() ) );
        
        WR.buildGetParams( params, function( newParams ) {
            window.location = exportURL + '?' + newParams;
        });
    };
    
    WR.DOM.get( opts.csvID ).appendChild( WR.HTMLGenerator.createJavaScriptLink( '<?jformat Export to CSV?>', function() {
        redirectToExport( opts.csvURL );
    } ).finish() );
    
    WR.DOM.get( opts.printableID ).appendChild( WR.HTMLGenerator.createJavaScriptLink( '<?jformat Printable Version?>', function() {
        redirectToExport( opts.printableURL );
    } ).finish() );
    
    if ( opts.pdfID )
        WR.DOM.get( opts.pdfID ).appendChild( WR.HTMLGenerator.createJavaScriptLink( '<?jformat Export to PDF?>', function() {
            redirectToExport( opts.pdfURL );
        } ).finish() );
    
    WR.PropertiesDataTable.superclass.constructor.call( this, opts );
};

WR.PropertiesDataTable.prototype = {
    
    loadInitialState : function( state, me )
    {
        WR.PropertiesDataTable.superclass.loadInitialState.call( this, state, me );
        
        if ( state != null )
        {
            var params = WR.URL.ParseParams( state );
            me.expandedProperties = params.expandedProperties;
        }
    },
    
    _getSortableColumns : function()
    {
        var columns = [];
        var columnSet = this.getColumnSet().keys;
        for ( var i in columnSet )
        {
            if ( this.expandColumnNames == null || WR.Array.indexOf( this.expandColumnNames, columnSet[i].getKey() ) < 0 )
                columns.push( { key: columnSet[i].getKey() } );
        }
        
        return columns;
    },
	
	setSortIndicators : function( sortColumns, sortDirections )
	{
		var me = this;
		this.resetIndicators();
		this.removeSortHighlighting();

		var columnSet = this.getColumnSet().keys;

		for ( var i = 0; i < sortColumns.length; )
		{
			var validSortColumns = $.grep( columnSet, function( elem, index ) {
				return elem.getKey() === sortColumns[i];
			} );

			if ( validSortColumns.length > 0 )
			{
				var id = "#" + me.getId() + "-th-" + this.sanitize( sortColumns[i] ) + "-liner";
				var num = i < 10 ? ( i + 1 ) : 'n';
				$( id ).css( 'background', 'url( "/JavaScript/DataTable/images/' + sortDirections[i] + '-' + num + '.png" ) no-repeat scroll 99% 50% transparent' );
				++i;
			}
			else
			{
				sortColumns.splice( i, 1 );
			}
		}

		if ( sortColumns ) {
			this.sortColumns = sortColumns;
			this.sortDirections = sortDirections;
		}
	},
	
	removeSortHighlighting : function()
	{
		$( '#wr_datapage th.yui-dt-asc, #wr_datapage th.yui-dt-desc' ).css( 'background', 'url("/images/besreports/' + WR.language + '/headbut_bg_unselected.png") repeat-x scroll 0 0 transparent' );
		$( '.yui-skin-sam tr.yui-dt-even td.yui-dt-asc, .yui-skin-sam tr.yui-dt-even td.yui-dt-desc' ).css( 'background-color', $( '.yui-skin-sam tr.yui-dt-even' ).css( 'background-color' ) );
		$( '.yui-skin-sam tr.yui-dt-odd td.yui-dt-asc, .yui-skin-sam tr.yui-dt-odd td.yui-dt-desc'   ).css( 'background-color', $( '.yui-skin-sam tr.yui-dt-odd'  ).css( 'background-color' ) );
	},
    
    buildRequest : function( oState, columns )
    {
        var request = WR.PropertiesDataTable.superclass.buildRequest.call( this, oState, this._getSortableColumns() );
        
        if ( this.expandedProperties != null )
            request += '&' +  WR.URL.paramsToString( { expandedProperties : this.expandedProperties } );
        
        return request;
    },
    
    generateInitialRequest : function( opts, columns )
    {
        var propertyList = new Array();
        for ( var col in columns )
            propertyList[ col ] = columns[ col ].key;
            
        var params = {  c : propertyList,
						results : opts.pagination.rowsPerPage,
						startIndex : 0,
						sort : opts.sortKey,
						dir: opts.sortDir };
        
        if ( this.expandedProperties != null )
            params.expandedProperties = this.expandedProperties;
        
        return WR.URL.paramsToString( params );
    },
    
    doBeforeLoadData : function( oRequest, oResponse, oPayload )
    {
        if ( !WR.PropertiesDataTable.superclass.doBeforeLoadData.call( this, oRequest, oResponse, oPayload ) )
            return false;
        
        if ( oResponse.meta.columns != null )
        {
            var currentColumns = this.getColumnSet();
            var newColumns = oResponse.meta.columns;
            
			var deleted = false;
			var modified = false;
			var removedColumnArray = new Array();
			var rmColIdx = 0;			
			for( var j = 0; j < newColumns.length ; )
			{
				if( newColumns[j].deleted )
				{
					for( var k in currentColumns.keys )
					{
						if( currentColumns.keys[k].key == newColumns[j].key )
							this.removeColumn( currentColumns.keys[k].key );
					}

					if ( oPayload.sortedBy.key == newColumns[j].key )
						oPayload.sortedBy.key = null;

					if ( newColumns[j].label )
						modified = true;
					else
						deleted = true;
					removedColumnArray[ rmColIdx++ ] = newColumns[j].label;						
					newColumns.splice( j, 1 );
				}
				else
				{
					++j;
				}
			}

            if( newColumns.length == 0 )
                return false;
			
			currentColumns = this.getColumnSet();
			
			var i = 0;
            while ( i < Math.max( newColumns.length, currentColumns.keys.length ) )
            {
                if ( i < currentColumns.keys.length
                  && i < newColumns.length
                  && currentColumns.keys[i].key == newColumns[i].key 
                  && currentColumns.keys[i].label == this.getLabel( newColumns[i].label, newColumns[i] ) )
                {
                    i++;
                    continue;
                }
                
                if ( i < currentColumns.keys.length )
                    this.removeColumn( currentColumns.keys[i].key );
                else if ( i < newColumns.length )
                {
                    var draggable = this.expandColumnNames == null || WR.Array.indexOf( this.expandColumnNames, newColumns[i].key ) < 0;
                    var sortable = draggable;
                    this.insertColumn(
                        {
                            key : newColumns[i].key,
                            label : newColumns[i].label,
                            formatter : this.opts.defaultFormatter,
                            sortable : sortable,
                            resizeable : true,
                            dataSource : true,
                            draggable: draggable
                        },
                        i );
                }
                currentColumns = this.getColumnSet();
            }
			
			if( deleted || modified )
			{
				WR.reportChanged();
				if ( null != oPayload.sortedBy.key )
					this.setSortIndicators( oResponse.meta.sort, oResponse.meta.dir );
				else
					this.setSortIndicators( [], [] );
				this.request = this.buildRequest( this.getState() );
				this.history.update();
				if ( modified )
					WR.Notify.warning( WR.format( '<?jformat The following columns have been removed from the current report because their corresponding properties have been modified : {columns}?>', removedColumnArray ) );
				else if ( deleted )
					WR.Notify.warning( '<?jformat Columns have been removed from the current report because their corresponding properties have been deleted.?>' );
			}
        }
        
        return true;
    }
    
};

YAHOO.lang.extend( WR.PropertiesDataTable, WR.DynamicDataTable, WR.PropertiesDataTable.prototype );

function notReportedString()
{
    return WR.HTML.escape( '<?jformat <not reported>?>' );
};

function noResultString()
{
    return WR.HTML.escape( '<?jformat <none>?>' );
};

function errorString()
{
    return WR.HTML.escape( '<?jformat <error>?>' );
};

function firstPropertyResult( el, results )
{
    el.innerHTML = '[+] ' + WR.HTML.escape( results[ 0 ] );
    el.title = '<?jformat Multiple results: click to expand?>';
    
    return el;
};

function allPropertyResults( el, results )
{
    var allResults = '';
    for ( var i in results )
        allResults += WR.HTML.escape( results[ i ] ) + '<br />';
    
    el.innerHTML = allResults;
    el.title = '<?jformat click to minimize?>';
    
    return el;
};

function setSpanText( span, text, css )
{
    if ( css )
        span.addClass( css );
        
    span
        .innerHTML( text )
        .setProperty( "title", WR.HTML.unescape( text ) );
};

function formatProperty( elCell, oRecord, oColumn, datatable )
{
    var property = oRecord.getData( "properties" )[ oColumn.key ];
    
    var span = new WR.DOM.Element( 'span' );
    elCell.appendChild( span.finish() );
    
    
    if ( property.result == null && property.error == null )
        setSpanText( span, notReportedString(), 'not_reported_result' );
    else if ( property.error != null )
        setSpanText( span, WR.HTML.escape( property.error ), 'error_result' );
    else 
    {
        if ( datatable.customPropertyFormatters[ oColumn.key ] != null )
        {
            var formatComplete = datatable.customPropertyFormatters[ oColumn.key ]( elCell, oRecord, oColumn, datatable, span, property );
            if ( formatComplete )
                return;
        }
        
        if ( !property.plural )
            setSpanText( span, WR.HTML.escape( property.result ) );
        else if ( property.result.length == 0 )
            setSpanText( span, noResultString(), 'empty_result' );
        else if ( property.result.length == 1 )
            setSpanText( span, WR.HTML.escape( property.result[ 0 ] ) );
        else if ( property.result.length > 1 )
        {
            var fullResult = false;
            WR.DOM.el( elCell )
                .setStyle( 'cursor', 'pointer' )
                .addListener( "click", function() {
                    fullResult = !fullResult;
                    
                    fullResult
                        ? allPropertyResults( span.finish(), property.result )
                        : firstPropertyResult( span.finish(), property.result );                
                } )
                .addListener( "mouseover", function() {
                    new WR.DOM.Element( this ).setStyle( "background-color", "#C0C0C0" );
                } )
                .addListener( "mouseout", function() {
                    new WR.DOM.Element( this ).setStyle( "background-color", "" );
                } );
            firstPropertyResult( span.finish(), property.result ) 
        }
    }
    
};
