// SortMenuDropDown

// <?import /JavaScript/WR.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/Util/HTML.js?>
// <?import /JavaScript/Util/Array.js?>
// <?import /JavaScript/Util/RegExp.js?>

// <?import /JavaScript/yui-import/Container.js?>
// <?import /JavaScript/yui-import/Button.js?>
// <?import /JavaScript/yui-import/Dom.js?>
// <?import /JavaScript/yui-import/Event.js?>

// <?import /JavaScript/DataTable/DragAndDrop.js?>

// <?import /JavaScript/DataTable/SortMenuDropDown.css?>

WR.SortMenuDropDown = function( opts ) {
    this.id = opts.id;
    this.sortedColumnsText = opts.sortedColumnsText;
	this.unsortedColumnsText = opts.unsortedColumnsText;
	this.sortAscendingText = opts.sortAscendingText;
	this.sortDescendingText = opts.sortDescendingText;
    this.getActiveLabels = opts.getActiveLabels;
	this.dataTable = opts.dataTable;
    
    if ( opts.getLabelHTML )
        this.getLabelHTML = opts.getLabelHTML;
    
    if ( opts.entryMatches )
        this.entryMatches = opts.entryMatches;
    
    this.overlay = new YAHOO.widget.Overlay( "sortmenuoverlay", { visible : false } );
    
    this.menuButton = new YAHOO.widget.Button( {
        type : 'menu',
        label : opts.buttonText,
        menu : this.overlay,
        container : opts.id
    } );
    
    this.overlay.showEvent.subscribe( function( type, args, labelPicker ) {
        labelPicker.init();
		labelPicker.updateOptions();
    }, this );
};

WR.SortMenuDropDown.prototype = {

	sortedListId : function() {
		return this.id + '_sortedItems';
	},
	
	unsortedListId : function() {
		return this.id + '_unsortedItems'
	},

    init : function() {
        if ( this.initialized )
            return;
        
        YAHOO.util.Dom.setStyle( "sortmenuoverlay", "z-index", 1 );
        
        WR.DOM.el( YAHOO.util.Dom.get( 'sortmenuoverlay' ) )
            .appendChild(
                WR.DOM.el( 'div' )
                    .addClass( 'sortedColumnsContainer' )
					.appendChild(
                        WR.DOM.el( 'h3' )
                            .innerHTML( this.sortedColumnsText )
                            .finish()
                    )
                    .appendChild(
                        WR.DOM.el( 'span' )
                            .setProperty( 'id', this.id + '_ac_container' )
                            .finish()
                    )
                    .appendChild(
                        WR.DOM.el( 'ul' )
                            .setProperty( 'id', this.sortedListId() )
                            .finish()
                    )
                    .finish()
            )
            .appendChild(
                WR.DOM.el( 'div' )
                    .addClass( 'unsortedColumnsContainer' )
					.appendChild(
                        WR.DOM.el( 'h3' )
                            .innerHTML( this.unsortedColumnsText )
                            .finish()
                    )
                    .appendChild(
                        WR.DOM.el( 'ul' )
                            .setProperty( 'id', this.unsortedListId() )
                            .finish()
                    )
                    .finish()
            );
        
        this.sortedList = YAHOO.util.Dom.get( this.id + '_sortedItems' );
        this.unsortedList = YAHOO.util.Dom.get( this.id + '_unsortedItems' );
		
		this.dragAndDropInit();
		
        this.initialized = true;
    },
    
    setLabels : function( labels ) {
        this.labels = labels;
    },
	
	setLabelsFromColumns : function( columns ){
		this.labels = [];
		for( var i in columns )
		{
			this.labels[i] = columns[i].id;
		}
	},
    
    getLabelHTML : function( key ) {
        return WR.HTML.escape( key );
    },
    
    getIsEnabled : function( key ) {
    	return true;
    },
    
    entryMatches : function( key, regex ) {
        return key.search( regex ) != -1;
    },
    
    setInputWidth : function( width ) {
        WR.DOM.el( YAHOO.util.Dom.get( this.id + '_ac' ) )
            .setStyle( 'width', width + 'px' )
            .setStyle( 'border', '1px' );
    },
    
    reset : function() {
		this.resetting = true;
        this.sortedList.innerHTML = '';
        this.unsortedList.innerHTML = '';
		this.resetting = false;
    },
    
    appendLabelToList : function( label, index, isActive, sortIndex ) {
        
        var labelItem = function( me, isSorted, isEven ) {
            var textbox = WR.DOM.el( 'input' )
				.addClass( 'sortOrderInput' )
                .setProperty( 'id', me.id + '_options_' + ( isSorted ? 'sorted' : 'unsorted' ) + '_' + index )
                .setProperty( 'type', 'text' )
				.setProperty( 'size', '1' )
				.setProperty( 'maxlength ', '1' )
				.setProperty( 'value', sortIndex == -1 ? '' : sortIndex + 1 )
                .addListener( 'change', function( e, o ) {
					if( o.picker.resetting )
						return;
					var target = e.target ? e.target : e.srcElement;
					var newPos = parseInt( target.value );
					if( sortIndex == -1 ) {
						if ( isNaN( newPos ) || newPos < 1 )
							target.value = '';
						else {
							o.picker.dataTable.addSortColumn( o.label, 'asc', newPos-1 );
							o.picker.updateOptions();
						}	
					}else{
						if( target.value == '' ){
							o.picker.dataTable.removeSortColumn( sortIndex );
							o.picker.updateOptions();
							return;
						}
						
						if( isNaN( newPos ) || newPos < 1 )
							target.value = sortIndex + 1;
						else
							o.picker.changeSortOrder( o.label, newPos-1 );
					}
                }, { picker : me, label : label } )
				.addListener( 'click', function( e, o ) {
					var target = e.target ? e.target : e.srcElement;
					target.focus();
					target.select();
				 }, { picker : me, label : label } )
               .finish();
			
			var labelContainer = WR.DOM.el( 'span' )
                .addClass( 'labelContainer' );
			
			if ( sortIndex != -1 ) {
				var sortDir = me.dataTable.sortDirections[ sortIndex ];
			
				labelContainer.appendChild( WR.DOM.el( 'img' )
					.addClass( 'sortDirectionArrow' )
					.setProperty( 'src', "/JavaScript/DataTable/images/" + sortDir + ".png" )
					.setProperty( 'title', sortDir == 'asc' ? me.sortDescendingText : me.sortAscendingText )
					.addListener( 'click', function( e, o ) {
						if( sortDir == 'asc' )
							o.picker.dataTable.setSortDirection( sortIndex, 'desc' );
						else
							o.picker.dataTable.setSortDirection( sortIndex, 'asc' );
						
						o.picker.updateOptions();
					}, { picker : me, label : label } )
				.finish() );
			}
			
			labelContainer.appendChild( textbox )
				.appendChild( WR.DOM.el( 'span' )
					.addClass( 'sortLabelPickerText' )
					.innerHTML( '<label for="' + textbox.id + '" title="' + me.getLabelHTML( label ) + '">' + me.getLabelHTML( label ) + '</label>' )
					.finish() );	
			
            return WR.DOM.el( 'li' )
				.addClass( 'sortListElement' + ( isEven ? 'Even' : 'Odd' ) )
				.setProperty( 'id', 'li_' + index + '_' + ( sortIndex == -1 ? 'unsorted' : sortIndex ) )
                .appendChild( labelContainer.finish() )
                .finish()
        };
        
        if ( sortIndex != -1 )
            this.sortedLabels.push( { index : sortIndex, value : labelItem( this, true, sortIndex%2 == 1 ) } );
        else if ( isActive ){
			var labelItem = labelItem( this, false, this.unsortedIndexIsEven )
			new YAHOO.example.DDList( labelItem, this, false );
            WR.DOM.el( this.unsortedList ).appendChild( labelItem ).finish();
			this.unsortedIndexIsEven = !this.unsortedIndexIsEven;
		}
    },
	
	changeSortOrder : function( label, newPos )
	{
		this.dataTable.changeSortOrder( label, newPos );
		this.updateOptions();
	},
    
    updateOptions : function() {
        this.reset();

        var activeLabelSet = this.getActiveLabels();
		this.sortedLabels = [];
		
		this.unsortedIndexIsEven = false;
		
        for ( var i in this.labels )       
            this.appendLabelToList( this.labels[ i ], i, activeLabelSet.contains( this.labels[ i ] ), WR.Array.indexOf( this.dataTable.sortColumns, this.labels[ i ] ) );
		
		this.sortedLabels.sort( function( a, b ){ return a.index - b.index; } );
		
		for ( var i in  this.sortedLabels ) {
			new YAHOO.example.DDList( this.sortedLabels[i].value, this, true );
			WR.DOM.el( this.sortedList ).appendChild( this.sortedLabels[i].value ).finish();
		}
    },
	
	dragAndDropInit : function() {
		this.sortedTarget = new YAHOO.util.DDTarget( this.id + '_sortedItems' );
		this.unsortedTarget = new YAHOO.util.DDTarget( this.id + '_unsortedItems' );
		this.validTargetIds = [ this.id + '_sortedItems', this.id + '_unsortedItems' ];
	}, 
	
	removeSortColumnById : function( id ) {
		var sortIndex = parseInt( id.split( '_' )[2] );
		this.dataTable.removeSortColumn( sortIndex );
		this.updateOptions();
	},
	
	addSortColumnById : function( srcId, above, destId ) {
		var index = parseInt( srcId.split( '_' )[1] );
		var label = this.labels[ index ];
		var sortIndex = destId ? parseInt( destId.split( '_' )[2] ) + ( above ? 0 : 1 ) 
							   : -1;
		this.dataTable.addSortColumn( label, 'asc', sortIndex );
		this.updateOptions();
	},
	
	changeSortOrderById : function( srcId, above, destId ) {
		var index = parseInt( srcId.split( '_' )[1] );
		var label = this.labels[ index ];
		var sortIndex = parseInt( destId.split( '_' )[2] ) + ( above ? 0 : 1 );
		this.dataTable.changeSortOrder( label, sortIndex );
		this.updateOptions();
	},
	
	enable : function() {
		this.menuButton.set( "disabled", false );
	},
	
	disable : function() {
		this.menuButton.set( "disabled", true );
	}

};


