// ComputerContentType.js

// <?import /JavaScript/FilterCreation/FilterCreation.js?>
// <?import /JavaScript/FilterCreation/Selectors/StringSelector.js?>
// <?import /JavaScript/FilterCreation/ContentTypes/ContentType.js?>
// <?import /JavaScript/FilterCreation/Selectors/RelativeDateSelector.js?>
// <?import /JavaScript/yui-import/YahooGlobalObject.js?>
// <?import /JavaScript/FilterCreation/Selectors/SelectorList.js?>
// <?import /JavaScript/FilterCreation/PropertyPickers/ComputerPropertyPicker.js?>
// <?import /JavaScript/FilterCreation/Selectors/IsOrIsNotSelector.js?>

WR.Filters.ComputerContentType = function()
{
    WR.Filters.ComputerContentType.superclass.constructor.call( this, 'Computer', '<?jformat Computer?>', false );
};

WR.Filters.ComputerContentType.prototype = {
    
    generatePropertyPicker : function( div )
    {
        return new WR.Filters.ComputerPropertyPicker( div );
    },
    
    generateSelectorList : function( div, propertyData )
    {
        if ( propertyData.id == 'R-Last Report Time' )
            return new WR.Filters.SelectorList( div, WR.Filters.RelativeDateSelector );
        else if ( propertyData.id == '***Computer ID***' )
            return new WR.Filters.SelectorList( div, WR.Filters.IsOrIsNotSelector );
        else if ( propertyData.id == '***Computer Group***' )
            return new WR.Filters.SelectorList( div, WR.Filters.IsOrIsNotFromListSelector, WR.Filters.ComputerGroups );
        else
            return new WR.Filters.SelectorList( div, WR.Filters.StringSelector );
    }
    
};

YAHOO.lang.extend( WR.Filters.ComputerContentType, WR.Filters.ContentType, WR.Filters.ComputerContentType.prototype );