// ContentTypeGroup.js

// <?import /JavaScript/FilterCreation/FilterCreation.js?>
// <?import /JavaScript/Util/HTMLGenerator.js?>
// <?import /JavaScript/jQuery/jquery.js?>

WR.Filters.ContentTypeGroup = function( contentTypes )
{
    this.contentTypes = contentTypes;
};

WR.Filters.ContentTypeGroup.prototype = {
    
    generateSelect : function( defaultString, selectedCallback )
    {
        var me = this;
        
        var contentNames = [];
        var contentIDs = [];
        jQuery.each( this._visibleContentTypes(), function() {
            contentNames.push( this.name );
            contentIDs.push( this.id );
        } );
        
        var selectEl = WR.HTMLGenerator.createSelectFromEscapedEntries( defaultString, contentNames, defaultString, contentIDs );
        
        selectEl.addListener( 'change', function( e ) {
                var selectedValue = jQuery( selectEl.finish() ).val();
                selectedCallback( me.findContentTypeByName( selectedValue ) );
            } );
        
        return selectEl;
    },
    
    findContentTypeByName : function( id )
    {
        var filteredArray = jQuery.grep( this.contentTypes, function( val, index ) {
            return val.id == id;
        } );
        return filteredArray[0];
    },
    
    get : function ( index )
    {
        return this.contentTypes[ index ];
    },
    
    hide : function( contentType )
    {
        contentType.hide();
    },
    
    show : function( contentType )
    {
        contentType.show();
    },
    
    getOnlyAllowOneContentTypes : function()
    {
        var onlyOneTypes = [];
        
        for ( i in this.contentTypes )
        {
            if ( this.contentTypes[i].onlyAllowOne )
                onlyOneTypes.push( this.contentTypes[i] );
        }
        
        return onlyOneTypes;
    },
    
    _visibleContentTypes : function(){
        var visible = [];
        
        for ( i in this.contentTypes )
        {
            if ( this.contentTypes[i].isVisible )
                visible.push( this.contentTypes[i] );
        }
        
        return visible;
    }
    
    
};