// SelectFromListOperator.js

// <?import /JavaScript/FilterCreation/FilterCreationManager.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/Util/HTMLGenerator.js?>
// <?import /JavaScript/FilterCreation/Operators/Operator.js?>
// <?import /JavaScript/FilterCreation/Operators/SelectFromListOperator.js?>
// <?import /JavaScript/yui-import/YahooGlobalObject.js?>
// <?import /JavaScript/FilterCreation/FilterCreation.js?>
// <?import /JavaScript/jQuery/jquery.js?>
// <?import /JavaScript/FilterCreation/FilterCreation.css?>

WR.Filters.SavedFilterSelectFromListOperator = function( visibleFilters, hiddenFilters )
{
    WR.Filters.SavedFilterSelectFromListOperator.superclass.constructor.call( this, 'saved filter', '<?jformat saved filter?>', visibleFilters );
    
    this.hiddenList = hiddenFilters;
};

WR.Filters.SavedFilterSelectFromListOperator.prototype = {
    
	_trySetToHiddenValue : function( objectValue )
	{
		for ( var i in this.hiddenList )
		{
			var objectEntry = JSON.parse( this.hiddenList[i].id );
			if ( WR.Object.equal( objectValue, objectEntry ) )
			{
				this.valueField.appendChild( new WR.DOM.Element( 'option' )
							.setProperty( 'value', this.hiddenList[i].id )
							.innerText( this.hiddenList[i].name )
							.finish() );
				
				$( this.valueField.finish() ).val( this.hiddenList[i].id );
				return true;
			}
		}
		return false;
	},
	
    setValue : function( value )
    {
        try
        {
			var objectValue = JSON.parse( value );
            if( this._trySetValue( objectValue ) || this._trySetToHiddenValue( objectValue ) )
				return;
			
			this._addInvalidSelection( value, '<?jformat Filter Not Found?>' );
        }
        catch( e )
        {
           this._fallbackSetValue( value );
        }
    }
    
};

YAHOO.lang.extend( WR.Filters.SavedFilterSelectFromListOperator, WR.Filters.SelectFromListOperator, WR.Filters.SavedFilterSelectFromListOperator.prototype );