// SelectFromListOperator.js

// <?import /JavaScript/FilterCreation/FilterCreationManager.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/Util/HTMLGenerator.js?>
// <?import /JavaScript/FilterCreation/Operators/Operator.js?>
// <?import /JavaScript/yui-import/YahooGlobalObject.js?>
// <?import /JavaScript/FilterCreation/FilterCreation.js?>
// <?import /JavaScript/jQuery/jquery.js?>
// <?import /JavaScript/FilterCreation/FilterCreation.css?>

WR.Filters.SelectFromListOperator = function( id, name, list )
{
    WR.Filters.SelectFromListOperator.superclass.constructor.call( this, id, name );
    
    this.list = list;
};

WR.Filters.SelectFromListOperator.prototype = {
    
    generateValuePicker : function( div )
    {
        if ( $( div.finish() ).children().length == 0 )
        {
            var names = [];
            var values = [];
            
            jQuery.each( this.list, function() {
                names.push( this.name );
                values.push( this.id );
            } );
            
            this.valueField = WR.HTMLGenerator.createSelectFromEscapedEntries( '', names, null, values )
                .addListener( 'change', function( e ) { WR.Filters.update(); } )
                .addClass( 'SelectFromListSelect' )
                .addClass( 'ValuePickerField' );
            
            div.appendChild( this.valueField.finish() );
        }
        else
        {
            this.valueField = WR.DOM.el( $( div.finish() ).children().get( 0 ) );
        }
    },
    
    _addInvalidSelection: function( value, str )
    {
        this.valueField.appendChild( new WR.DOM.Element( 'option' )
                                .setProperty( 'value', value )
                                .innerText( str ? str : value )
                                .finish() );
        this.valueField.finish().selectedIndex = this.list.length;
        this.valueField.addClass( 'InvalidSelection' )
                        .setProperty( 'disabled', 'disabled' );
        
        $( this.valueField.finish() ).parent().siblings( '.Selector-OperatorDiv' ).find( 'select' ).prop( 'disabled', true );
    },
    
	_trySetValue : function( objectValue )
	{
		for ( var i in this.list )
		{
			var objectEntry = JSON.parse( this.list[i].id );
			if ( WR.Object.equal( objectValue, objectEntry ) )
			{
				this.valueField.finish().selectedIndex = i;
				return true;
			}
		}
		return false;
	},
	
	_fallbackSetValue : function( value )
	{
		if ( $( this.valueField.finish() ).children().filter( 'option[value="' + value + '"]' ).length > 0 )
			$( this.valueField.finish() ).val( value );
		else
		{
			this._addInvalidSelection( value );
		}
	},
	
    setValue : function( value )
    {
        try
        {
			var objectValue = JSON.parse( value );
            if( this._trySetValue( objectValue ) )
				return;
			
			this._addInvalidSelection( value );
        }
        catch( e )
        {
            this._fallbackSetValue( value );
        }
    }
    
};

YAHOO.lang.extend( WR.Filters.SelectFromListOperator, WR.Filters.Operator, WR.Filters.SelectFromListOperator.prototype );