// GroupableTreeView.js

// <?import /JavaScript/GroupableTreeView/GroupableTreeView.css?>
// <?import /JavaScript/Util/DOM.js?>

// <?import /JavaScript/yui-import/Event.js?>
// <?import /JavaScript/yui-import/DragDrop.js?>
// <?import /JavaScript/yui-import/Dom.js?>
// <?import /JavaScript/yui-import/TreeView.js?>
// <?import /JavaScript/yui-import/YahooGlobalObject.js?>
// <?import /JavaScript/jQuery/jquery.js?>

/**
 * Must specify createGroup, removeGroup, removeFromGroup, addToGroup event listeners that update the data source being used for the tree.
 * Must specify refreshData that generates new data and calls updateData
 */

WR.GroupableTreeView = function( id, oConfig ) {	
    this._initDOM( id );
    
    WR.GroupableTreeView.superclass.constructor.call( this, id + '_tree', oConfig );
    
    this.divId = id;
    this.data = oConfig;
    
    this._editorHasBeenOpened = false;
    
    this._subscribeToEvents();
    this._setupCustomEvents();
    this._setupDragAndDrop();
    
    this.render();
};


WR.GroupableTreeView.prototype = {
    
    updateData : function( oConfig )
    {
        this.data = oConfig;
        WR.GroupableTreeView.superclass.constructor.call( this, this.divId + '_tree', this.data );
        this._redraw();
    },
    
    loadDataAsync : function( dataLoader, scope, callbacks )
    {
        
        this.spinnerEl.setStyle( 'display', 'block' ); 
        this.treeEl.setStyle ('display', 'none' );
        
        var me = this;
        var newCallbacks = {
            success: function( response ) {
                me.canDragLabel.setStyle( 'display', 'block' );
                me._dataLoaded();
                if ( callbacks.success != null )
                    callbacks.success( response, scope );
            },
            failure: function( response, scope, message ) {
                me._dataLoaded();
                if ( callbacks.failure != null )    
                    callbacks.failure( response, scope, message );
            },
            failureTooLong: function( response, scope )
            {
                me._dataLoaded();
                if ( callbacks.failureTooLong != null )
                    callbacks.failureTooLong( response, scope );
            }
        }
        
        dataLoader( newCallbacks, scope );
    },
    
    /* We are overriding an undocmunted function here.  Be careful on upgrade. */
    _nodeEditing : function( node )
    {
        WR.GroupableTreeView.superclass._nodeEditing.call( this, node );
        
        if ( !this._editorHasBeenOpened )
        {
            var me = this;
            $( '.ygtv-input input' ).bind( 'blur', function() {
                // Using undocumented code from YUI treeview.js
                me._closeEditor( true );
            } );
            this._editorHasBeenOpened = true;
        }
    },
    
    _redraw : function()
    {
        this.render();
        this._setupDragAndDrop();
        $( '#' + this.divId + ' .ygtvlabel' ).attr( 'title', function() { return this.innerHTML; } );
    },
    
    _dataLoaded : function()
    {
        this.spinnerEl.setStyle( 'display', 'none' ); 
        this.treeEl.setStyle ('display', 'block' );
    },
    
    _initDOM : function( id )
    {
        var me = this;
        
        this.spinnerEl = new WR.DOM.Element( 'img' )
            .setProperty( 'src', '/JavaScript/yui/build/assets/skins/sam/ajax-loader.gif' )
            .addClass( 'GroupableTreeView-Spinner');
            
        this.treeEl = new WR.DOM.Element( 'div' )
            .setProperty( 'id', id + '_tree' )
            .addClass( 'GroupableTreeView-Tree');
            
        this.canDragLabel = new WR.DOM.Element( 'label' )
                .addClass( 'GroupableTreeView-CanDragLabel' )
                .innerHTML( '<?jformat Drag entries onto one another to form groups.?>' );
            
        WR.DOM.el( YAHOO.util.Dom.get( id ) )
            .appendChild( new WR.DOM.Element( 'label' )
                .addClass( 'GroupableTreeView-ResultsLabel' )
                .innerHTML( '<?jformat Results?>' )
                .finish() )
            .appendChild( this.spinnerEl.finish() )
            .appendChild( this.treeEl.finish() )
            .appendChild( new WR.DOM.Element( 'br' ).finish() )
            .appendChild( this.canDragLabel.finish() ); 
    },
    
    _subscribeToEvents : function()
    {
        var me = this;
        
        this.subscribe( 'expandComplete', function( node ) {
            me._setupDragAndDrop();
        });
    },
    
    _setupCustomEvents : function()
    {
        this.createGroup = new YAHOO.util.CustomEvent( 'createGroup', this );
        this.removeFromGroup = new YAHOO.util.CustomEvent( 'removeFromGroup', this );
        this.addToGroup = new YAHOO.util.CustomEvent( 'addToGroup', this );
        this.removeGroup = new YAHOO.util.CustomEvent( 'removeGroup', this );
        this.refreshData = new YAHOO.util.CustomEvent( 'refreshdata', this );
    },
    
    _createNewGroup : function( name, children, doEditName )
    {
        if ( name == null )
            name = 'New Group';
            
        this.createGroup.fire( name, children, doEditName || doEditName == null );
        
    },
    
     _setupDragAndDrop : function()
    {
        var me = this;
        
        var nodes = this._getVisibleNodes();
        
        for ( nodeIndex in nodes )
        {
            var node = nodes[nodeIndex];
            
            var dd = new YAHOO.util.DDProxy( node.getContentEl().id, 'treeElementGroup' );
            dd.onDragDrop = function( e, id )
            {
                if ( YAHOO.widget.TreeView.editorData.active )
                    return;
                
                var draggedNode = me.getNodeByElement( YAHOO.util.Dom.get( this.getEl().id ) );
                var targetNode = me.getNodeByElement( YAHOO.util.Dom.get( id ) );
                me._mergeNodes( draggedNode, targetNode );
            }
            
            dd.onInvalidDrop = function( e )
            {
                me._redraw();
            }
        }
    },
    
    _getVisibleNodes : function()
    {
        var nodes = [];
        var topNodes = this.getRoot().children;
        
        for ( nodeIndex in topNodes )
        {
            var node = topNodes[nodeIndex];
            if ( node.getContentEl() == null )
                continue;
            
            nodes.push( node );
            if ( node.children.length > 0 )
            {
                var children = node.children;
                for ( childIndex in children )
                {
                    var child = children[childIndex];
                    if ( child.getContentEl() == null )
                        continue;
                    
                    nodes.push( child );
                }
            }
        }
        
        return nodes;
    },
    
    _mergeChildNode : function( draggedNode, targetNode )
    {
        if ( targetNode.data.isGroup )
        {
            if ( draggedNode.parent.data.groupId == targetNode.data.groupId )
                return;
            
            this.removeFromGroup.fire( draggedNode.parent.data.groupId, draggedNode.data.resultId );
            this.addToGroup.fire( targetNode.data.groupId, draggedNode.data.resultId );
        }
        else if ( targetNode.parent.data.isGroup )
        {
            if ( draggedNode.parent.data.groupId == targetNode.parent.data.groupId )
                return;
            
            this.removeFromGroup.fire( draggedNode.parent.data.groupId, draggedNode.data.resultId );
            this.addToGroup.fire( targetNode.parent.data.groupId, draggedNode.data.resultId );
        }
        else
        {
            this.removeFromGroup.fire( draggedNode.parent.data.groupId, draggedNode.data.resultId );
        }
    },
    
    _mergeNodes : function( draggedNode, targetNode )
    {
        if ( targetNode == null || draggedNode == null )
            return;
        
        if ( !draggedNode.data.isGroup && draggedNode.parent.data.isGroup )
        {
            this._mergeChildNode( draggedNode, targetNode );
            this.refreshData.fire();
        }
        else if ( !targetNode.data.isGroup && targetNode.parent.data.isGroup )
        {
			if ( draggedNode != targetNode.parent )
				this._mergeNodes( draggedNode, targetNode.parent );
        }
        else if ( !draggedNode.data.isGroup && targetNode.data.isGroup )
        {
            this.addToGroup.fire( targetNode.data.groupId, draggedNode.data.resultId );
            this.refreshData.fire();
        }
        else
        {
            var children = [];
            if ( !draggedNode.data.isGroup )
            {
                children.push( draggedNode );
            }
            else
            {
                children = children.concat( draggedNode.children );
                this.removeGroup.fire( draggedNode.data.groupId ); 
            }
          
            if ( !targetNode.data.isGroup )
            {
                children.push( targetNode );
            }
            else
            {
                children = children.concat( targetNode.children );
                this.removeGroup.fire( targetNode.data.groupId ); //series 0
            }
            
            var newNode = this._createNewGroup( draggedNode.data.name + ' & ' + targetNode.data.name, children, true );
        }
        
        
    }
    
};

YAHOO.lang.extend( WR.GroupableTreeView, YAHOO.widget.TreeView, WR.GroupableTreeView.prototype );
