// <?import /JavaScript/Properties/PropertiesComboBox.css?>
// <?import /JavaScript/WR.js?>
// <?import /JavaScript/ComboBox/ComboBox.js?>
// <?import /JavaScript/Util/DOM.js?>

// <?import /JavaScript/yui-import/YahooGlobalObject.js?>
// <?import /JavaScript/yui-import/Event.js?>


WR.PropertiesComboBox = function( containerEl, dataSource, width /* (optional) */ ) {
	WR.PropertiesComboBox.superclass.constructor.call( this, containerEl, dataSource, "<?jformat Search Properties?>", width );
	
	this.maxResultsDisplayed = Math.min( dataSource.liveData.length, 1000 );

	WR.DOM.el( this.getInputEl()     ).addClass( "propertiesComboBoxInput" );
	WR.DOM.el( this.getContainerEl() ).addClass( "propertiesComboBoxContainer" );
	
	YAHOO.util.Event.addListener( this.getInputEl(), "focus", function( event, me ) {
		if ( !me.isContainerOpen() )
			me.sendQuery( me.getCurrentData()? me.getDisplayValue( me.getCurrentData() ) : '' );
	}, this );
	
	this.containerExpandEvent.subscribe( function()
		{
			$( containerEl ).addClass( 'PropertiesComboBoxOuterContainerCover' );
		} );

	this.containerCollapseEvent.subscribe( function()
		{
			$( containerEl ).removeClass( 'PropertiesComboBoxOuterContainerCover' );
		} );	
	
};

WR.PropertiesComboBox.prototype = {
	
	forceSetCurrentData : function( data ) {
		if ( data.displayName == null )
			data.displayName = WR.PropertiesDataSource.computeDisplayName( data );
		
		this._currentData = data;
		$( this.getInputEl() ).val( this.getDisplayValue( data ) );
		this.defaultTextField.format();
		
		if ( WR.Array.binarySearchForExisting( this.dataSource.liveData, data, function( a, b )
				{
					return WR.Array.caseInsensitiveCompare( a.displayName, b.displayName );
				} ) >= 0 )
		{
			this._validSelection( data );
		}
		else
		{
			this._invalidSelection( data );
		}
	},
	
	getDisplayValue : function( oResultData )
	{
		return oResultData.displayName;
	}
	
};

YAHOO.lang.extend( WR.PropertiesComboBox, WR.ComboBox, WR.PropertiesComboBox.prototype );
