// <?import /JavaScript/Notification/Notification.js?>
// <?import /JavaScript/Util/URL.js?>
// <?import /JavaScript/Util/Set.js?>
// <?import /JavaScript/Roles/RolePicker.js?>
// <?import /JavaScript/Util/HTML.js?>
// <?import /JavaScript/DropDownPicker/DropDownPicker.js?>
// <?import /JavaScript/Util/PostRequest.js?>
// <?import /JavaScript/Util/Array.js?>

/*
   opts.id
   opts.buttonText
   opts.availableItemsText
   opts.activeItemsText
   opts.dataTable
   opts.roleNames
   opts.submitFormBtnText
   opts.cancelFormBtnText
   opts.ldap
*/

function insertRolesToRoleData(data, newRolesToAddList) {
    if (!data.params.role)
        data.params.role = [];
    for (var i = 0; i < newRolesToAddList.length; i++) {
        var newRole = '' + newRolesToAddList[i];
        if (data.params.role.indexOf(newRole) == -1) {
            data.add('role', newRole);
        }
    }
}

function removeRolesToRoleData(data, rolesToRemoveList) {
    for (var i = 0; i < rolesToRemoveList.length; i++) {
        var roleToRemove = rolesToRemoveList[i];
        if (!data.params.role) {
            data.params.role = [];
        } else {
            var roleIndex = data.params.role.indexOf(roleToRemove)
            if (roleIndex != -1) {
                data.params.role.splice(roleIndex, 1);
            }
        }
    }
}

function cleanUserRoleParams(params) {
    params.remove("user");
    params.remove("role");
    params.remove("ldapId");
    params.remove("datasource");
    params.remove("groupDN");
    params.remove("name");
    params.remove("login");
}

WR.RolePicker = function( opts ) {
    var roleData = new WR.URL.ParamMap();

    this.labelPicker = new WR.DropDownPicker( {
        id : opts.id,
        buttonText : opts.buttonText,
        availableItemsText : opts.availableItemsText,
        activeItemsText : opts.activeItemsText,
        submitFormBtnText : opts.submitFormBtnText,
        cancelFormBtnText : opts.cancelFormBtnText,
        ldap: opts.ldap,
        formBehavior: opts.formBehavior || false,
        onSubmitForm : function(event) {
            YAHOO.util.Event.preventDefault(event);
            var postActionUrl = opts.ldap ? '/post/reassign-roles-to-ldapgroup' : '/post/reassign-roles';
            WR.postRequest( WR.URL( postActionUrl ), {
                success : function( o ) {
                    var params = [ { name: "page", value: "Authentication" }, { name: "user", value: WR.currentUserID } ];
                    WR.DOM.PostParameters( '/webreports', params );
                },
                failure : function( o ) {
                    WR.Notify.error( o.responseText );
                    cleanUserRoleParams(roleData);
                    event.data.picker.overlayForceClosing = true;
                    event.data.picker.overlay.hide();
                }
            },
            roleData );
            cleanUserRoleParams(roleData);
            event.data.picker.overlayForceClosing = true;
            event.data.picker.overlay.hide();
        },
        onCancelForm : function(event) {
            YAHOO.util.Event.preventDefault(event);
            cleanUserRoleParams(roleData);
            event.data.picker.overlayForceClosing = true;
            event.data.picker.overlay.hide();
        },
        initData : function() {
            roleData.params.role = [];
            for (i in opts.dataTable.checkedRows) {
                var row = opts.dataTable.checkedRows[i];
                if (opts.ldap) {
                    roleData.add( 'ldapId', row.getData( 'ldapId' ) );
                    roleData.add( 'datasource', row.getData( 'datasource' ) );
                    if ( row.getData( 'type' ) == 1 ) {
                        roleData.add( 'groupDN', row.getData( 'distinguishedName' ) );
                    } else if ( row.getData( 'type' ) == 2 ) {
                        roleData.add( 'name', row.getData( 'name' ) );
                        roleData.add( 'login', row.getData( 'login' ) );
                    }
                } else {
                    if ( row.getData( 'type' ) == 0 )
                        roleData.add('user', row.getData('guid'));
                    else if ( row.getData( 'type' ) == 1 )
                        roleData.add('group', row.getData('sid'));
                }
                insertRolesToRoleData(roleData, row.getData('assigned'));
            }
        },
        addLabel : function( role ) {
            var containerSelected = false;
            
            for ( i in opts.dataTable.checkedRows ) {
                var row = opts.dataTable.checkedRows[i];
                if (this.ldap) {
                    if ([1,2].indexOf(row.getData( 'type' )) < 0)
                        containerSelected = true;
                } else {
                    if ([0,1].indexOf(row.getData( 'type' )) < 0)
                        containerSelected = true;
                }
            }
            
            if ( roleData.empty() && containerSelected ) {
                WR.Notify.error( '<?jformat Roles can only be assigned to users and security groups.?>' );
                return;
            }

            insertRolesToRoleData(roleData, [role]);
        },
        removeLabel : function( role ) {
            var containerSelected = false;
            
            for ( i in opts.dataTable.checkedRows ) {
                var row = opts.dataTable.checkedRows[i];
                if (this.ldap) {
                    if ([1,2].indexOf(row.getData( 'type' )) < 0)
                        containerSelected = true;
                } else {
                    if ([0,1].indexOf(row.getData( 'type' )) < 0)
                        containerSelected = true;
                }
            }
            
            if ( roleData.empty() && containerSelected ) {
                WR.Notify.error( '<?jformat Roles can only be assigned to users and security groups.?>' );
                return;
            }

            removeRolesToRoleData(roleData, [role]);
        },
        getActiveLabels : function() {
            var labelSet = new WR.Set();
            
            for ( i in opts.dataTable.checkedRows )
            {
                var labels = opts.dataTable.checkedRows[i].getData( 'assigned' );
                
                if ( labels.roles ) {
                    for ( var j = 0; j < labels.roles.length; ++j )
                        labelSet.insert( labels.roles[j] );
                }
                else {
                    for ( var j = 0; j < labels.length; ++j )
                        labelSet.insert( labels[j] );
                }
            }
            
            return labelSet;
        },
        getLabelHTML : function ( role ) {
            return WR.HTML.escape( opts.roleNames[role] );
        },
        entryMatches : function ( role, regex ) {
            return opts.roleNames[role].search( regex ) != -1;
        }
    } );
    
    var roleIDs = new Array();
    for ( var id in opts.roleNames )
        roleIDs.push( id );
    
    roleIDs.sort( function( a, b ) {
        return WR.Array.caseInsensitiveCompare( opts.roleNames[a], opts.roleNames[b] );
    });
    
    this.labelPicker.setLabels( roleIDs );
};

WR.RolePicker.prototype = {
    set: function( name, value ) {
        if ( name == 'disabled' ) {
            if ( value )
                this.labelPicker.disable();
            else
                this.labelPicker.enable();
        }
    }
};