// <?import /JavaScript/Util/URL.js?>

WR.Form = {
    _textInputToParams : function( input, params ) {
        params.add( input.name, input.value );
    },
    
    _checkboxInputToParams : function( input, params ) {
        if ( input.checked )
            params.add( input.name, input.value );
    },
    
    _selectInputToParams : function( input, params ) {
        for ( var i = 0; input.childNodes[i]; i++ ) {
            var option = input.childNodes[i];
            if ( option.tagName == 'OPTION' && option.selected )
                params.add( input.name, option.value );
        }
    },
    
    formToParamMap : function( form ) {
        var params = new WR.URL.ParamMap();
        
        for ( var i = 0; i < form.length; ++i ) {
            var input = form[i];
            
            if ( !input.disabled ) {
                switch ( input.type ) {
                case 'text':            WR.Form._textInputToParams    ( input, params ); break;
                case 'password':        WR.Form._textInputToParams    ( input, params ); break;
                case 'textarea':        WR.Form._textInputToParams    ( input, params ); break;
                case 'hidden':          WR.Form._textInputToParams    ( input, params ); break;
                case 'checkbox':        WR.Form._checkboxInputToParams( input, params ); break;
                case 'radio':           WR.Form._checkboxInputToParams( input, params ); break;
                case 'select-one':      WR.Form._selectInputToParams  ( input, params ); break;
                case 'select-multiple': WR.Form._selectInputToParams  ( input, params ); break;
                }
            }
        }
        
        return params;
    }
};
