// GetRequest.js

// <?import /JavaScript/Notification/Notification.js?>
// <?import /JavaScript/Util/Format.js?>
// <?import /JavaScript/Util/URL.js?>
// <?import /JavaScript/FilterCreation/GenerateFilterParameters.js?>
// <?import /JavaScript/yui-import/ConnectionManager.js?>
// <?import /JavaScript/Connection/ConnectionObject.js?>
// <?import /JavaScript/Util/TextShortener.js?>

WR.getRequest = function ( url, callback, params /* optional */, scope /* optional */ ) {
    var success = function( o ) {
        callback.success( o, scope );
    };

    var failure = function( o ) {
        if ( callback.failure != null )
        {
            callback.failure( o, scope );
        }
        else
        {
            var errorMessage = o.responseText != null ? o.responseText : '<?jformat Unknown Error?>';
            WR.Notify.error( WR.format( '<?jformat HTTP Request failed: {error}?>', errorMessage )  );
        }
    };
    
    var newCallback = function( newParams ) {
        var newURL = WR.URL.setQuery( url, newParams );
        var yuiConnectionObject = YAHOO.util.Connect.asyncRequest( 'GET', newURL, {
            success: success,
            failure: failure
        });
        
        if ( callback.start != null )
            callback.start( new WR.ConnectionObject( yuiConnectionObject ), scope );
    }

    WR.buildGetParams( params, newCallback );
};

WR.buildGetParams = function( params, callback ) {
    var paramsWithFilter = WR.URL.paramsToString( WR.generateFilterParameters( params ) );
    
    if ( paramsWithFilter.length < 1900 )
    {
        callback( paramsWithFilter );
        return;
    }
    
    WR.TextShortener.ShortenText( paramsWithFilter, {
        success : function( shortText ) {
            callback( WR.URL.paramsToString( { ShortenedParams: shortText } ) );
        },
        failure : function ( errorMsg ) {
            throw "Failed text shortening request with " + paramsWithFilter + ": " + errorMsg;
        }
    });
}
