// <?import /JavaScript/WR.js?>

WR.Set = function( array ) {
    this.erase();
    if( array )
        for( var i in array )
            this.insert( array[i] );
};

WR.Set.prototype = {
    insert : function( el ) {
        if( !this.map[ el ] )
        {
            this.map[ el ] = true;
            this.length++;
        }
    },
    
    remove : function( el ) {
        if( this.map[ el ] )
        {
            delete this.map[ el ];
            this.length--;
        }
    },
    
    erase : function() {
        this.map = {};
        this.length = 0;
    },
    
    contains : function( el ) {
        return this.map[ el ] ? true : false;
    },
    
    forEach : function( callback, param ) {
        for( var i in this.map )
            callback( i, param );
    },
    
    getArray : function() {
        var a = new Array();
        this.forEach( function( el ) {
            a.push( el );
        } );
        
        return a;
    },
    
    getSortedArray : function( compareFunction ) {
        var a = this.getArray();
        
        compareFunction
            ? a.sort( compareFunction )
            : a.sort();
        
        return a;
    }
};
