$( document ).ready(function() {

    var callRelevance = function(analysisId, besSitesId) {
        var relevanceCmd = 'exists fixlets whose ';
        relevanceCmd += '(id of it = '+ analysisId +' and exists best activation of it and active flag of best activation of it) '
        relevanceCmd += 'of bes sites whose (id of it = '+ besSitesId +')';
        Relevance(relevanceCmd, {
            success: manageTrueRelevance,
            failure: showWarningMessage
        });
    };

    var manageTrueRelevance = function(relevanceResponse) {
        if (!relevanceResponse)
            showWarningMessage();
    };

    var showWarningMessage = function() {
        var warningId = 'bes-component-analysis-warning';
        var mainContentEl = document.getElementById('wr_notifications');
        var warningMessageEl = document.createElement('div');
        warningMessageEl.setAttribute('id', warningId);
        warningMessageEl.className = 'wr_warningbox';
        warningMessageEl.innerHTML =  '<?jformat Please activate the BES Component Version Analysis in the BES Console?>';
        if (!document.getElementById(warningId))
            mainContentEl.appendChild(warningMessageEl);
        removeCharts();
    };

    var removeCharts = function() {
        try {
            $('#chartSection').hide();
        } catch(err) {}
    };

    var getQueryStringValue = function(key) {  
        return decodeURIComponent(window.location.search.replace(new RegExp('^(?:.*[&\\?]' + encodeURIComponent(key).replace(/[\.\+\*]/g, '\\$&') + '(?:\\=([^&]*))?)?.*$', 'i'), '$1'));  
    };

    var manageIemComponentVersionAnalysis = function(intervalId) {
        try {
            var filterData = JSON.parse(WR.Filters.filterDescription);
            var analysisData = filterData.conditionList[0].selectedProperty.analysis;
            filterDescriptionReady = true;
            clearInterval(intervalId);
            var analysisId = analysisData.id;
            var besSiteid = analysisData.siteid;
            var pathname = window.location.pathname;
            var page = getQueryStringValue('page');
            var correctPage = (pathname === '/webreports') && (page === 'ExploreComputers') && (analysisId == 204);
            if (correctPage) {
                callRelevance(analysisId, besSiteid);
            }
        } catch(error) {
            executing = false;
        }
    };

    var filterDescriptionReady = false;
    var timeout = 2000;
    var intervalTime = 50;
    var executing = false;

    WR.run(function() {
        var intervalId = setInterval(function() {
            if (!filterDescriptionReady && !executing) {
                executing = true;
                manageIemComponentVersionAnalysis(intervalId);
            }
        }, intervalTime);
        setTimeout(function() {
            if (intervalId)
                clearInterval(intervalId);
        }, timeout);
    });

});