function IsDisplayed( element )
{
	if ( element )
	{
		if ( element.style.display == 'block' || element.style.display == '' )
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}
	return 1;
};

function GetScrollY()
{
    // this function modified from http://www.howtocreate.co.uk/tutorials/javascript/browserwindow
    var ret = 0;
    if( typeof( window.pageYOffset ) == 'number' )
    {
        //Netscape compliant
        ret = window.pageYOffset;
    }
    else if ( document.body && ( document.body.scrollLeft || document.body.scrollTop ) ) 
    {
        //DOM compliant
        ret = document.body.scrollTop;
    }
    else if ( document.documentElement && ( document.documentElement.scrollLeft || document.documentElement.scrollTop ) )
    {
        //IE6 standards compliant mode
        ret = document.documentElement.scrollTop;
    }
    return ret;
};

function WriteStyleCookie()
{
	bar = document.getElementById( 'wr_leftbar' );
	actionsbox = document.getElementById( 'wr_reportactions' );
	favbox = document.getElementById( 'wr_reportfavorites' );
	historybox = document.getElementById( 'wr_reporthistory' );
	
	tbar = document.getElementById( 'wr_togglebar' );
	divPage = document.getElementById( 'wr_datapage' );
	
	cookieValue = IsDisplayed( bar ) + ',' + 
				  IsDisplayed( actionsbox ) + ',' + 
				  IsDisplayed( favbox ) + ',' + 
				  IsDisplayed( historybox ) + ',' +
				  divPage.style.height + ',' +
				  tbar.style.height;
	
	document.cookie= 'wruistyle=' + cookieValue;
};

function GetStyleCookie()
{
	lookFor = 'wruistyle=';
	findIndex = document.cookie.indexOf( lookFor );
	if ( findIndex == -1 )
	{
		return '1,1,1,1,1';
	}
	else
	{
		endIndex = document.cookie.indexOf( ';', findIndex );
		if ( endIndex == -1 )
		{
			endIndex = document.cookie.length;
		}
		
		return document.cookie.substring( findIndex + lookFor.length );
	}
};

function LeftToggleBarOn()
{
	toggle = document.getElementById( 'wr_togglebar' );
	if ( QuickButtonOn( toggle ) )
	{
		toggle.className = 'wr_companycoloron';
	}
};
function LeftToggleBarOff()
{
	toggle = document.getElementById( 'wr_togglebar' );
	if ( QuickButtonOff( toggle ) )
	{
		toggle.className = 'wr_companycoloroff';
	}
};

function ToggleLeftBar()
{
	bar = document.getElementById( 'wr_leftbar' );
	main = document.getElementById( 'wr_content' );
	titleDiv = document.getElementById( 'wr_titlediv' );
	toggle = document.getElementById( 'wr_togglebar' );
	
	if ( bar.style.display == 'block' || bar.style.display == '' )
	{
    	bar.style.display = 'none';
    	main.style.marginLeft = 5;
    	toggle.style.left = 5;
    	toggle.style.backgroundImage = 'url(/images/besreports/' + WR.language + '/openbutton1.gif)';
    	titleDiv.style.left = 23;
    	titleDiv.style.marginRight = 35;
    }
    else
    {
    	bar.style.display = 'block';
    	main.style.marginLeft = 195;
    	toggle.style.left = 195;
    	toggle.style.backgroundImage = 'url(/images/besreports/' + WR.language + '/closebutton1.gif)';
    	titleDiv.style.left = 214;
    	titleDiv.style.marginRight = 225;
    }
    ResizeLeftToggleBar();
};

function QuickButtonOn( divElement )
{
	url = divElement.style.backgroundImage;
	dotIndex = url.lastIndexOf( "." );
	if ( dotIndex > -1 )
	{
		lastImageChars = url.substr( dotIndex - 1 );
		if ( lastImageChars != '1.gif)' )
		{
			sourceString = url.substr( 0, dotIndex );
			sourceString += '1.gif)';
			divElement.style.backgroundImage = sourceString;
			return true;
		}
	}
	
	return false;
};

function QuickButtonOff( divElement )
{
	url = divElement.style.backgroundImage;
	dotIndex = url.lastIndexOf( "." );
	if ( dotIndex > -1 )
	{
		lastImageChars = url.substr( dotIndex - 1 );
		if ( lastImageChars == '1.gif)' )
		{
			sourceString = url.substr( 0, dotIndex - 1 );
			sourceString += '.gif)';
			divElement.style.backgroundImage = sourceString;
			return true;
		}
	}
	return false;
};
    
function InitLeftBox( titleDivID, boxDivID, openUp )
{
	divElement = document.getElementById( boxDivID );
	titleElement = document.getElementById( titleDivID );
	if ( divElement && titleElement )
	{
		if ( openUp == '1' )
		{
			divElement.style.display = 'block';
			titleElement.style.backgroundImage = 'url(/images/besreports/' + WR.language + '/minimizebutton.gif)';
		}
		else
		{
			divElement.style.display = 'none';
			titleElement.style.backgroundImage = 'url(/images/besreports/' + WR.language + '/maximizebutton.gif)';
		}
	}
};

function ToggleMenuBox( titleElement, boxDiv )
{
	divElement = document.getElementById( boxDiv );
	if ( divElement.style.display == 'none' )
	{
		divElement.style.display = 'block';
		titleElement.style.backgroundImage = 'url(/images/besreports/' + WR.language + '/minimizebutton.gif)';
	}
	else if ( divElement.style.display == 'block' || divElement.style.display == '' )
	{
		divElement.style.display = 'none';
		titleElement.style.backgroundImage = 'url(/images/besreports/' + WR.language + '/maximizebutton.gif)';
	}
	WriteStyleCookie();
};

function InitLeftToggleBar( openUp )
{
	tbar = document.getElementById( 'wr_togglebar' );
	main = document.getElementById( 'wr_content' );
	bar = document.getElementById( 'wr_leftbar' );
	titleDiv = document.getElementById( 'wr_titlediv' );
	tbar.className = 'wr_companycoloroff';
	if ( tbar && bar && main && titleDiv )
	{
		if ( openUp == '1' )
		{
			bar.style.display = 'block';
			main.style.marginLeft = 195;
    		tbar.style.left = 195;
			tbar.style.backgroundImage = 'url(/images/besreports/' + WR.language + '/closebutton.gif)';
			titleDiv.style.left = 214;
			titleDiv.style.marginRight = 225;
		}
		else
		{
			bar.style.display = 'none';
			main.style.marginLeft = 5;
    		tbar.style.left = 5;
			tbar.style.backgroundImage = 'url(/images/besreports/' + WR.language + '/openbutton.gif)';
			titleDiv.style.left = 23;
			titleDiv.style.marginRight = 35;
		}
	}
};
    
function ResizeLeftToggleBar()
{
	tbar = document.getElementById( 'wr_togglebar' );
	divPage = document.getElementById( 'wr_datapage' );
	lbar = document.getElementById( 'wr_leftbar' );
	headerDiv = document.getElementById( 'wr_header' );

	if ( divPage && document.body )
	{
		pageHeight = document.body.clientHeight - ( divPage.offsetTop + 200 );
		if ( pageHeight > 0 )
		{
			divPage.style.height = pageHeight;
		
			newHeight = pageHeight + 130;
			tbar.style.height = newHeight;
			
			lbar.style.height = newHeight;	
			WriteStyleCookie();
		}
		
		pageWidth = document.body.clientWidth;
		if ( pageWidth < 700 )
		{
			headerDiv.style.width = 700;
		}
		else
		{
			headerDiv.style.width = pageWidth;
		}
	}
};

function OnBodyLoad()
{
	divBody = document.getElementById( 'wr_bodyDiv' );
	if ( !divBody )
		return;
		
	styleString = GetStyleCookie();
	styleArray = styleString.split( ',' );
	
	InitLeftToggleBar( styleArray[0] );
	InitLeftBox( 'wr_reportactionstitle', 'wr_reportactions', styleArray[1] );
	InitLeftBox( 'wr_reportfavoritestitle', 'wr_reportfavorites', styleArray[2] );
	InitLeftBox( 'wr_reporthistorytitle', 'wr_reporthistory', styleArray[3] );
	
	ResizeLeftToggleBar();
	ResizeLeftToggleBar();
};

function OnBodyResize()
{
	ResizeLeftToggleBar();
};

function SubmitFilterForm( filterForm, createFilterForm, manageFilterForm )
{
	filterSelect = document.getElementById( 'FilterNameID' );
	for ( i = 0; i < filterSelect.length; ++i )
	{
		if ( filterSelect.options[i].selected )
		{
			if ( filterSelect.options[i].value == '' )
			{
				if ( i == filterSelect.options.length - 1 )
				{
					manageFilterForm.submit();
				}
				else if ( i == filterSelect.options.length - 2 )
				{
					createFilterForm.submit();
				}
				else if ( i == 0 )
				{
				    filterForm.submit();
				}
				else
				{
					filterSelect.options[i].selected = false;
					filterSelect.options[0].selected = true;
				}
			}
			else
			{
				if ( filterForm.hasChildNodes() )
				{
					var nodeList = filterForm.childNodes;
					for ( var j = 0; j < nodeList.length; j++ )
					{
						if ( nodeList[j].attributes && nodeList[j].getAttribute( 'name' ) == 'FilterName' )
						{
							filterForm.removeChild( nodeList[j] );
						}
					}
				}
				var nameInput = document.createElement( 'input' );
				nameInput.setAttribute( 'type', 'hidden' );
				nameInput.setAttribute( 'name', 'FilterName' );
				nameInput.setAttribute( 'value', filterSelect.options[i].value );
				filterForm.appendChild( nameInput );
				filterForm.submit();
			}
		}
	}
};
