// ChartConfiguration.js
// Abstract superclass of configuration UI's

// <?import /JavaScript/Charts/Charts.js?>
// <?import /JavaScript/Charts/Charts.css?>
// <?import /JavaScript/Util/DOM.js?>

// <?import /JavaScript/yui-import/Dom.js?>

WR.Charts.Configuration = function( chartBox )
{
    this.chartBox = chartBox;
    this.isLoadingResults = false;
};

WR.Charts.Configuration.prototype = {
    
    generateConfigurationUI : function( div )
    {
        var divEl = div.finish();
        
        div.appendChild( new WR.DOM.Element( 'div' )
				.addClass( 'configure-chart-title' )
				.innerHTML( '<?jformat Configure Chart ?>' )
				.finish() )
			.appendChild( new WR.DOM.Element( 'label' )
                .innerHTML( '<?jformat Title: ?>' )
                .finish() )
            .appendChild( new WR.DOM.Element( 'input' )
                .setProperty( 'type', 'text' )
                .setProperty( 'id', this.chartBox.id + '_titleInput' )
                .finish() )
            .appendChild( new WR.DOM.Element( 'br' ).finish() )
            .appendChild( new WR.DOM.Element( 'br' ).finish() );
        
        return div;
    },
    
    addApplyConfirmDiv : function( div )
    {
        var me = this;
        //Append apply/confirm stuff
        div.appendChild( new WR.DOM.Element( 'div' )
            .setProperty( 'id', this.chartBox.id + '_configurationConfirm' )
            .setProperty( 'className', 'chartboxconfigurationconfirm' )
            .appendChild( new WR.DOM.Element( 'a' )
                .setProperty( 'href', 'javascript:void(0)' )
                .setProperty( 'id', this.chartBox.id + '_cancelLink' )
                .setProperty( 'className', 'chartboxconfigurationconfirmcancel' )
                .addListener( 'click', function( e ) {
                    if ( me.chartBox.graphHasBeenCreated )
                    {
                        me.chartBox.chartHoverBox.enableHoverBox = true;
                        me.chartBox.switchToPresentationView();
                    }
                    else
                        me.chartBox.chartManager.removeChart( me.chartBox );
                    } )
                .innerHTML( '<?jformat Cancel?>' )
                .finish() )
            .appendChild( new WR.DOM.Element( 'a' )
                .setProperty( 'href', 'javascript:void(0)' )
                .setProperty( 'id', this.chartBox.id + '_applyLink' )
                .addClass( 'chartboxconfigurationconfirmapply' )
                .addClass( 'wr_disabled' )
                .innerHTML( '<?jformat Create Chart?>' )
                .finish() )
            .finish() );
    },
    
    serializeForHistory : function()
    {
        return {
            title: this.title ? this.title : '',
            chartType: this.chartType,
            dataType: this.dataType,
            showGraph: this.showGraph,
            showTable: this.showTable
        };
    },
    
    applyState : function( state, rawData, onCompletion )
    {
        this.title = state.title ? WR.HTML.unescape( state.title ) : '';
        this.chartType = state.chartType;
        this.dataType = state.dataType;
        this.showGraph = state.showGraph;
        this.showTable = state.showTable;
    },
    
    refresh : function()
    {
        
    },
    
    domReady : function()
    {
        
    },
    
    writeConfigurationToUI : function()
    {
        YAHOO.util.Dom.get( this.chartBox.id + '_titleInput' ).setAttribute( 'value', this.title );
    },
    
    readConfigurationFromUI : function()
    {
        this.title = YAHOO.util.Dom.get( this.chartBox.id + '_titleInput' ).value;
    },
    
    filterChanged : function( xml, callback )
    {
        throw "abstract method";
    }
};
