// ChartSummary.js

// <?import /JavaScript/Charts/Charts.css?>
// <?import /JavaScript/DataTable/DataTable.css?>
// <?import /css/besreports/WebReports;Language/datatable.css?>
// <?import /JavaScript/Charts/Charts.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/Charts/ChartBox.js?>

// <?import /JavaScript/yui-import/DataSource.js?>
// <?import /JavaScript/yui-import/DataTable.js?>
// <?import /JavaScript/yui-import/Resize.js?>
// <?import /JavaScript/yui-import/Dom.js?>

// <?import /JavaScript/yui-import/Tooltip.js?>

WR.Charts.SummaryTable = function( chartBox )
{
    this.chartBox = chartBox;
    this.id = 'WR_ChartSummary' + WR.Charts.SummaryTable.nextIdNo++;
    this.summaryData = [];
    
    this._init();
};

WR.Charts.SummaryTable.nextIdNo = 0;

WR.Charts.SummaryTable.COLOR_COLUMN_WIDTH = 15;
WR.Charts.SummaryTable.VALUE_COLUMN_WIDTH = 168;
WR.Charts.SummaryTable.COUNT_COLUMN_WIDTH = 47;
WR.Charts.SummaryTable.PERCENT_COLUMN_WIDTH = 59;

WR.Charts.SummaryTable.prototype = {
    
    _init : function()
    {
        this.div = new WR.DOM.Element( 'div' )
            .setProperty( 'id', this.id )
            .setProperty( 'className', 'chartsummary' );
        
        this.dataTableDiv = new WR.DOM.Element( 'div' )
            .setProperty( 'id', this.id + '_table' );
        
        this.div.appendChild( this.dataTableDiv.finish() );

    },
    
    //TODO: support multiple properties
    draw : function()
    {
        this.summaryData = this.chartBox.generateSummaryData();
        
        var columnDefs = [];
        
        if ( this.chartBox.configuration.chartType == WR.Charts.ChartBox.CHARTTYPE_PIE )
        {
            columnDefs.push( { key: 'entryNumber', label: '', sortable: false, width: WR.Charts.SummaryTable.COLOR_COLUMN_WIDTH,
                formatter: function( elCell, oRecord, oColumn, oData ) {
                    var color = WR.Charts.ChartBox.COLORS[ oData % WR.Charts.ChartBox.COLORS.length];
                    elCell.innerHTML = '<img class="chartboxlegendcolorbox" src="/JavaScript/Charts/images/' + color.substring( 1 ) + '.png" />';
                }});
        }
        columnDefs.push( { key: this.chartBox.configuration.properties[0].id, label: this.chartBox.configuration.properties[0].name, sortable: true,
                        width: WR.Charts.SummaryTable.VALUE_COLUMN_WIDTH } );
        columnDefs.push( { key: 'count', label: '<?jformat Count?>', sortable: true, width: WR.Charts.SummaryTable.COUNT_COLUMN_WIDTH } );
        columnDefs.push( { key: 'percent', label: '<?jformat Percent?>', sortable: true, width: WR.Charts.SummaryTable.PERCENT_COLUMN_WIDTH,
                        formatter: function( elCell, oRecord, oColumn, oData )
                        {
                            elCell.innerHTML = oData.toFixed(1) + "%";    
                        } } );
        
        this.dataSource = new YAHOO.util.FunctionDataSource( this.chartBox.data.generateSummaryData );
        this.dataSource.scope = this.chartBox.data;
        
        this.dataSource.responseType = YAHOO.util.XHRDataSource.TYPE_JSARRAY;
        
        if ( this.chartBox.configuration.chartType == WR.Charts.ChartBox.CHARTTYPE_PIE )
            this.dataSource.responseSchema = { fields: [ 'entryNumber', this.chartBox.configuration.properties[0].id, 'count', 'percent' ] };
        else
            this.dataSource.responseSchema = { fields: [ this.chartBox.configuration.properties[0].id, 'count', 'percent' ] };

        
        
        this.dataTable = new YAHOO.widget.DataTable( this.id + '_table', columnDefs, this.dataSource );

        this.dataTable.set( "MSG_SORTDESC", '' );
        this.dataTable.set( "MSG_SORTASC", '' );

        var args = { toolTip: new YAHOO.widget.Tooltip( "myToolTip" ), showTimer: null, hideTimer: null };

        this.dataTable.on( 'theadLabelMouseoverEvent', this._mouseOverEventHandler, args );
        this.dataTable.on( 'theadLabelMouseoutEvent', this._mouseOutEventHandler, args );

        this.dataTable.on( 'cellMouseoverEvent', this._mouseOverEventHandler, args );
        this.dataTable.on( 'cellMouseoutEvent', this._mouseOutEventHandler, args );

        this._setupResizing();
    },
    
    _mouseOverEventHandler : function( oArgs, obj )
    {
        if ( obj.showTimer ) {
            window.clearTimeout( obj.showTimer );
            obj.showTimer = 0;
        }
        if ( obj.hideTimer ) {
            window.clearTimeout( obj.hideTimer );
            obj.hideTimer = 0;
        }
        
        var xy = YAHOO.util.Dom.getXY( oArgs.target );
        xy = [ xy[0] + 20, xy[1] + 20 ];
        
        var txt = WR.HTML.escape( oArgs.target.textContent );
        obj.showTimer = window.setTimeout( function() {
            obj.toolTip.cfg.setProperty( 'xy', xy );
            obj.toolTip.cfg.setProperty( 'text', txt );
            obj.toolTip.show();
            }, 500 );
    },
    
    _mouseOutEventHandler : function( oArgs, obj )
    {
        obj.hideTimer = window.setTimeout( function() {
            obj.toolTip.hide();
        }, 2000 );
    },
    
    _setupResizing : function()
    {
        var table = this.dataTable.getTableEl();
        var tableRegion = YAHOO.util.Dom.getRegion( table );
       
        var head = this.dataTable.getTheadEl();
        var headRegion = YAHOO.util.Dom.getRegion( head );
        
        var firstRow = this.dataTable.getFirstTrEl();
        var rowRegion = YAHOO.util.Dom.getRegion( firstRow );
        
        var minHeight = headRegion.height + rowRegion.height + 7;
        var rowHeight = rowRegion.height - 1;
        var extraHeight = headRegion.height + 8;
        var maxHeight = ( rowHeight * ( this.chartBox.data.getNumGroupedResults() ) ) + extraHeight; //series 0
        
        var resize = new YAHOO.util.Resize( this.id + '_table', { handles: ['b'], maxHeight: maxHeight, minHeight: minHeight } );
        
        var me = this;
        resize.addListener( 'resize', function() {
            var region = YAHOO.util.Dom.getRegion( me.div.finish() );
            var numToShow = Math.floor( ( region.height - extraHeight ) / rowHeight );
            if ( numToShow != me.chartBox.data.numToShow )
            {
                me.chartBox.data.restrictVisibleTo( numToShow );
                
                var oCallback = {
                    success : me.dataTable.onDataReturnInitializeTable,
                    failure : me.dataTable.onDataReturnInitializeTable,
                    scope : me.dataTable
                };
                
                me.dataSource.sendRequest( '', oCallback );
                
				if( me.chartBox.configuration.showGraph )
					me.chartBox.chartGraph.draw();
                
                me.chartBox.chartManager.resize();
                
            }
        });
        
        resize.addListener( 'endResize', function() {
            var region = YAHOO.util.Dom.getRegion( me.div.finish() );
            var numToShow = Math.floor( ( region.height - extraHeight ) / rowHeight );
            var height = rowHeight * numToShow + extraHeight;
            YAHOO.util.Dom.setStyle( resize.getWrapEl(), 'height', height + 'px' );
            me.chartBox.chartManager.updateHistory();
        });
        
        $( '#' + this.id + '_table' ).css( 'height', '' );
    },
    
    addTo : function( div )
    {
        div.appendChild( this.div.finish() )
    }
    
};
