// CollapsibleSection.js

// <?import /JavaScript/CollapsibleSection/CollapsibleSection.css?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/Util/History.js?>
// <?import /JavaScript/jQuery/jquery.js?>

WR.MakeSectionCollapsible = function( div, name, id )
{
    return new WR.CollapsibleSection( div, name, id )
};

WR.CollapsibleSection = function( div, name, id )
{
    this.id = id;
    this.headerName = name;
    this._isVisible = true;
    
    var me = this;
    
    this.contentDiv = WR.DOM.el( 'div' );
    this.headerLabel = this._generateHeaderLabel( name );
    this.sectionMinimizer = WR.DOM.el( 'div' )
                                .addClass( 'SectionMinimizer' )
                                .addClass( 'Clickable' )
                                .addListener( 'click', function ( e ) { me.toggleContent(); } );
    this.minimizerImage = WR.DOM.el( 'img' )
                                .addClass( 'MinimizerImage' );
    this.sectionMinimizer.appendChild( this.minimizerImage.finish() );
    this.headerDiv = WR.DOM.el( 'div' )
            .addClass( 'CollapsibleHeader' );
    this.setHeaderContent( WR.DOM.el( 'div' )
                            .appendChild( this.sectionMinimizer.finish() )
                            .appendChild( this.headerLabel.finish() )
                            .finish() );
        
    this.overallDiv = WR.DOM.el( 'div' )
                        .addClass( 'CollapsibleSection' )
                        .appendChild( this.headerDiv.finish() )
                        .appendChild( this.contentDiv.finish() );
    
    
    $( div ).after( this.overallDiv.finish() );
    
    this.contentDiv.appendChild( div );
    
    WR.CollapsibleSection.History.runWhileIgnoringUpdates( function() { me.forceVisibility( false ); } );
    
    WR.CollapsibleSection.allSections.push( this );
};

WR.CollapsibleSection.allSections = [];

WR.CollapsibleSection.History = new WR.History( 'collapseState', this, {
    
        generateState: function( me )
        {
            var state = {};
            for ( var i in WR.CollapsibleSection.allSections )
            {
                var section = WR.CollapsibleSection.allSections[i];
                state[ section.id ] = section.isVisible();
            }
            return state;
        },
        
        loadInitialState: function( state, me )
        {
            if ( state == null )
                state = {};
            
            if ( state.Charts == undefined )
                state.Charts = false;
            
            for ( var i in WR.CollapsibleSection.allSections )
            {
                var section = WR.CollapsibleSection.allSections[i];
                if ( state[ section.id ] != null )
                    WR.CollapsibleSection.History.runWhileIgnoringUpdates( function() { section.forceVisibility( state[ section.id ] ); } );
                else
                    WR.CollapsibleSection.History.runWhileIgnoringUpdates( function() { section.forceVisibility( true ) } );                
            }
        }
    } );

WR.CollapsibleSection.prototype = {
    
    toggleContent : function()
    {
        this._setVisibility( !this.isVisible() );
        $( this.contentDiv.finish() ).slideToggle( "slow" );
    },
    
    _setVisibility: function( show )
    {
        this._isVisible = show;
        $( this.overallDiv.finish() ).toggleClass( 'SectionExpanded', show );
        $( this.overallDiv.finish() ).toggleClass( 'SectionCollapsed', !show );
        
        this._updateExpansionImage( show );
        
        WR.CollapsibleSection.History.update();
    },
    
    _updateExpansionImage : function( show )
    {
        if ( show == true )
            this.minimizerImage.setProperty( 'src', '/images/besreports/' + WR.language + '/minus.bmp' );
        else
            this.minimizerImage.setProperty( 'src', '/images/besreports/' + WR.language + '/plus.bmp' );
    },
    
    forceVisibility: function( show )
    {
        this._setVisibility( show );
        $( this.contentDiv.finish() ).toggle( show );
    },
    
    isVisible : function()
    {
        return this._isVisible;
    },
    
    setHeaderContent : function( elOrHTML )
    {
        $( this.headerDiv.finish() ).children().remove();
        if ( elOrHTML instanceof String )
        {
            WR.DOM.get( this.headerDiv.finish() )
                .innerHTML( elOrHTML );
        }
        else
        {
            WR.DOM.get( this.headerDiv.finish() )
                .appendChild( elOrHTML );
        }
    },
    
    _generateHeaderLabel : function( name )
    {
        return WR.DOM.el( 'label' )
                            .innerText( name )
                            .addClass( 'CollapsibleHeaderLabel' );
    }
    
};
