// <?import /JavaScript/WR.js?>
// <?import /JavaScript/DataTable/PropertiesDataTable.js?>
// <?import /JavaScript/Util/URL.js?>
// <?import /JavaScript/Util/HTML.js?>
// <?import /JavaScript/Util/Array.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/DataSource/DataSource.js?>

// <?import /JavaScript/yui-import/YahooGlobalObject.js?>

/*
 * opts.id
 * opts.pagination.template
 * opts.pagination.pageReportTemplate
 * opts.pagination.rowsPerPage
 * opts.pagination.containers
 * opts.filterID
 * opts.filterText
 * opts.filterContainerID
 * opts.statusID
 */

WR.ComputerPropertiesDataTable = function( opts, columns )
{  
    var me = this;
    
    this.collapseComputers =  false;
    
    opts.dataSource = new WR.DataSource( WR.URL( '/json/computers?' ), [ "properties", "computerHref", "fixletHref" ] );
    opts.sortKey = columns[0].key;
    
    opts.customPropertyFormatters =
    {
        'R-Computer Name' : function( elCell, oRecord, oColumn, datatable, span, property )
        {
            if ( !oRecord.getData( 'computerHref' ) )
            {
                setSpanText( span, property.result );
                return true;
            }
            
            var s = WR.HTML.escape( property.plural ? property.result[0] : property.result );
            span
                .setProperty( "title", s )
                .appendChild(
                    new WR.DOM.Element( 'a' )
                        .setProperty( 'href', oRecord.getData( 'computerHref' ) )
                        .innerHTML( s )
                        .finish()
                );
            return true;
        },
        
        'Fixlet' : function( elCell, oRecord, oColumn, datatable, span, property )
        {
            var s = WR.HTML.escape( property.plural ? property.result[0] : property.result );
            span
                .setProperty( "title", s )
                .appendChild(
                    new WR.DOM.Element( 'a' )
                        .setProperty( 'href', oRecord.getData( 'fixletHref' ) )
                        .innerHTML( s )
                        .finish()
                );
            return true;
        },
        
        'R-Last Report Time' : function( elCell, oRecord, oColumn, datatable, span, property )
        {
            setSpanText( span, new Date( property.result ).toLocaleString() );
            return true;
        },
        
        'Relevance' : function( elCell, oRecord, oColumn, datatable, span, property )
        {
            if ( property.plural && property.result.length == 0 )
            {
                setSpanText( span, '<?jformat <not applicable>?>', 'empty_result' );
                return true;
            }
            else
                return false;
        }
    };
    
    opts.expandColumnNames = [ 'Fixlet', 'Relevance' ];
    opts.csvURL = '/csv/ExploreComputers.csv';
    opts.pdfURL = '/pdf/ExploreComputers.pdf';    
    opts.printableURL = '/printable/ExploreComputers';
    
    this.onComputersCollapsed = new YAHOO.util.CustomEvent( 'onComputersCollapsed', this );
    this.onComputersExpanded = new YAHOO.util.CustomEvent( 'onComputersCollapsed', this );
	
    WR.ComputerPropertiesDataTable.superclass.constructor.call( this, opts, columns );
};

WR.ComputerPropertiesDataTable.prototype = {
    
    loadInitialState : function( state, me )
    {
        WR.ComputerPropertiesDataTable.superclass.loadInitialState.call( this, state, me );
        
        if ( state != null )
        {
            var params = WR.URL.ParseParams( state );
            me.setCollapseComputers( params.collapsedColumn != null );
            if ( null != params.expandColumn )
                me.expandedColumns = params.expandColumn;
        }
    },
    
    buildRequest : function( oState, columns )
    {
        var request = WR.ComputerPropertiesDataTable.superclass.buildRequest.call( this, oState, columns );
        
        var computerIndex = this._getComputerColumnIndex();
        if ( this.collapseComputers && computerIndex >= 0 )
            request += '&' +  WR.URL.paramsToString( { collapsedColumn : computerIndex } );
        
        return  request;
    },
    
    generateInitialRequest : function( opts, columns )
    {
        var request = WR.ComputerPropertiesDataTable.superclass.generateInitialRequest.call( this, opts, columns );
        
        var computerIndex = this._getComputerColumnIndex( columns );
        if ( this.collapseComputers && computerIndex >= 0 )
            request += '&' +  WR.URL.paramsToString( { collapsedColumn : computerIndex } );
        
        return  request;
    },
    
    _getComputerColumnIndex : function( keys )
    {
        if ( keys == null )
        {
            var columns = this._getSortableColumns();
            keys = [];
            for ( var i = 0; i < columns.length; ++i )
            {
                keys.push( columns[i].key );
            }
        }
        
        return WR.Array.indexOf( keys, 'R-Computer Name' );
    },
    
    setCollapseComputers : function( isCollapsed )
    {
        this.collapseComputers = isCollapsed;
        if ( isCollapsed )
            this.onComputersCollapsed.fire();
        else
            this.onComputersExpanded.fire();
    }
    
};

YAHOO.lang.extend( WR.ComputerPropertiesDataTable, WR.PropertiesDataTable, WR.ComputerPropertiesDataTable.prototype );

