// <?import /JavaScript/Util/URL.js?>
// <?import /JavaScript/Filter/AutoCompleteFilter.js?>
// <?import /JavaScript/yui-import/Dom.js?>
// <?import /JavaScript/yui-import/DataTable.js?>
// <?import /JavaScript/Notification/Notification.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/yui-import/Event.js?>
// <?import /JavaScript/Util/Format.js?>
// <?import /JavaScript/Util/History.js?>
// <?import /JavaScript/Util/HTML.js?>
// <?import /JavaScript/yui-import/YahooGlobalObject.js?>
// <?import /JavaScript/jQuery/jquery.js?>
// <?import /JavaScript/yui-import/Paginator.js?>
// <?import /JavaScript/DataTable/DataTableStrings.js?>

// <?import /JavaScript/DataTable/DataTable.css?>
// <?import /css/besreports/WebReports;Language/datatable.css?>


/*
 Parameters:
    opts.id
    opts.dataSource
    opts.config
    opts.columns
    opts.defaultFormatter
    opts.filter (optional)
    opts.statusContainer (optional)
*/
WR.DataTable = function( opts )
{
    opts.config.initialLoad = false;
    opts.config.MSG_EMPTY =    WR.DataTableStrings.MSG_EMPTY;
    opts.config.MSG_ERROR =    WR.DataTableStrings.MSG_ERROR;
    opts.config.MSG_LOADING =  WR.DataTableStrings.MSG_LOADING;
    opts.config.MSG_SORTASC =  WR.DataTableStrings.MSG_SORTASC;
    opts.config.MSG_SORTDESC = WR.DataTableStrings.MSG_SORTDESC;
    
    this.opts = opts;
    this.addDefaultColumnFormatters();
    
    WR.DataTable.superclass.constructor.call( this, opts.id, opts.columns, opts.dataSource, opts.config );
    
    this.requestNeeded = true;
    this.hasLoadedADataTable = false;
    this.isDuringPaginationRequest = false;
    this.filterQuery = {};
    
    this.initializeFilter();
    
    this.request = opts.config.initialRequest;
    
    this.get( "paginator" ).unsubscribe( "changeRequest", this.onPaginatorChangeRequest );
    this.get( "paginator" ).subscribe( "changeRequest", this.handlePagination, this, true );
    
    this.get( 'paginator' ).set( 'firstPageLinkLabel',    WR.DataTableStrings.firstPageLinkLabel );
    this.get( 'paginator' ).set( 'lastPageLinkLabel',     WR.DataTableStrings.lastPageLinkLabel );
    this.get( 'paginator' ).set( 'nextPageLinkLabel',     WR.DataTableStrings.nextPageLinkLabel );
    this.get( 'paginator' ).set( 'previousPageLinkLabel', WR.DataTableStrings.previousPageLinkLabel );
    
    var me = this;
    me.handleHistoryNavigation = function( forceRequest ) {
        var request = this.request;
        var params = WR.URL.ParseParams( request );
        me.filterQuery.q = params.q;
        me.lastRequest = request;
        if ( params.q != "" && me.filter )
            me.filter.setValue( params.q );
        
        if ( forceRequest || !me.hasLoadedADataTable || ( me.requestNeeded && me._getSortableColumns().length > 0 ) )
            me._sendRequest( request );
        
        me.requestNeeded = true;
    };
    
    this.navigateEvent = new YAHOO.util.CustomEvent( "navigate", this );
    
    this.history = new WR.History( this.opts.id, this, {
        generateState : function( me ) {
            return me.request;
        },
        loadInitialState : me.loadInitialState,
        onStateChanged: function( newState, oldState, me ) {
            me.handleHistoryNavigation();
        } } );
    
    
    this.subscribe( "columnReorderEvent", function() {
        me._onColumnReorder();
    }, this, true );
    
    
    if ( WR.Filters != null ) // If we're using filters on this page, we should update this data table whenever the filter changes
    {
        WR.Filters.filterChanged.subscribe( function( type, args, me ) {
            if ( WR.History.isLoadComplete )
                me.setToFirstPageUpdate();
        }, this );
    }
    
    WR.History.onLoadComplete.subscribe( function() {
        me.handleHistoryNavigation( true );
        me.navigateEvent.fire();
    } );
    
    this.noColumnsLabel = this._setupNoColumnsLabel();
	
	this.columnPicker = null;
	
	this.expandedColumns = [];
	this.sortColumns = [];
	this.sortDirections = [];
	
	if( opts.sortKey )
		this.sortColumns.push( opts.sortKey );
	if( opts.sortDir )
		this.sortDirections.push( opts.sortDir );
};

WR.DataTable.prototype = {
    
    loadInitialState : function( state, me )
    {
        me.request = me.mergeNewState( state );
    },
    
    _onColumnReorder : function()
    {
        this.requestNeeded = false;
        this.request = this.buildRequest( this.getState() );
        this.history.update();
    },
    
    _setupNoColumnsLabel : function()
    {
        var noColumnsLabel = WR.DOM.el( 'label' )
            .addClass( 'NoColumnsLabel' )
            .innerText( '<?jformat No columns selected.?>' );
        
        $( '#' + this.opts.id ).after( noColumnsLabel.finish() );
        
        return noColumnsLabel;
    },
    
    removeColumnFromTable : function( column )
    {
        var index = this.getColumnSet().keys[0] == column? 1 : 0;
        var state = this.getState();
        if ( state.sortedBy != null && state.sortedBy.key == column.key )
            this.set( 'sortedBy', null );
        
        WR.DataTable.superclass.removeColumn.call( this, column );
        
        if ( this._getSortableColumns().length == 0 )
        {
            this.set( 'sortedBy', null );
            WR.DOM.get( this.opts.id ).setStyle( 'display', 'none' );
            this.noColumnsLabel.setStyle( 'display', 'inline' );
        }
		
		var sortIndex = WR.Array.indexOf( this.sortColumns, column.key );
		if( sortIndex != -1 ){
			this.sortColumns.splice( sortIndex, 1 );
			this.sortDirections.splice( sortIndex, 1 );
		}
		
		var expandIndex = WR.Array.indexOf( this.expandedColumns, column.key );
		if( expandIndex != -1 )
			this.expandedColumns.splice( expandIndex, 1 );
    },
	
	getLabel : function( label, column )
	{
		return WR.HTML.escape( label );
	},
    
    insertColumn : function( opts, column )
    {
        WR.DOM.get( this.opts.id ).setStyle( 'display', 'block' );
        this.noColumnsLabel.setStyle( 'display', 'none' );
		opts.rawLabel = opts.label;
        opts.label = this.getLabel( opts.label, column );
        WR.DataTable.superclass.insertColumn.call( this, opts, column );
    },
    
    removeAllColumns : function()
    {
        while ( this.getColumnSet().keys.length > 0 )
            this.removeColumn( this.getColumnSet().keys[0] );
    },
    
    doBeforeLoadData : function( oRequest, oResponse, oPayload )
    {   
        if ( oResponse.meta.totalRecordsUnknown )
            oPayload.totalRecords = YAHOO.widget.Paginator.VALUE_UNLIMITED;
        else
            oPayload.totalRecords = oResponse.meta.totalRecords;
        
        oPayload.pagination = {
            rowsPerPage  : oResponse.meta.pageSize,
            recordOffset : oResponse.meta.startIndex
        };
        var paginator = this.get( 'paginator' );
        if ( oResponse.meta.totalRecordsUnknown )
            paginator.set( 'pageReportTemplate', WR.format( '<?jformat Showing items {_obrace}startRecord{_cbrace} - {_obrace}endRecord{_cbrace}?>' ) );
        else
            paginator.set( 'pageReportTemplate', WR.format( '<?jformat Showing items {_obrace}startRecord{_cbrace} - {_obrace}endRecord{_cbrace} of {_obrace}totalRecords{_cbrace}?>' ) );
        
		
        var sortKey = oResponse.meta.sort;
		var sortDir = oResponse.meta.dir ? "yui-dt-" + oResponse.meta.dir : "yui-dt-asc";
		
		if( oResponse.meta.sort != null && oResponse.meta.sort.constructor == Array ) {
			sortKey = oResponse.meta.sort[0];
			if( oResponse.meta.dir )
				sortDir = "yui-dt-" + oResponse.meta.dir[0];
		}
		
        oPayload.sortedBy = {
            key : sortKey,
            dir : sortDir
        };
        
        return true;
    },
    
    _buildSortParameters : function( oState )
    {
        var sortParams = {};
        
        if ( this.sortColumns.length > 0 || this.sortDirections.length > 0 )
        {
            if ( this.sortColumns.length > 0 )
                sortParams.sort = this.sortColumns;
            
            if ( this.sortDirections.length > 0 )
                sortParams.dir = this.sortDirections;
        }
        else
        {
            var columns = this._getSortableColumns();
            if ( columns.length > 0 )
                sortParams.sort = oState.sortedBy ? oState.sortedBy.key : columns[0].key;

            sortParams.dir = (oState.sortedBy && oState.sortedBy.dir === YAHOO.widget.DataTable.CLASS_DESC) ? "desc" : "asc";
        }
        
        return sortParams;
    },
    
    buildRequest : function( oState )
    {
        // Set defaults
        oState = oState || {pagination:null, sortedBy:null};
        
        var startIndex = (oState.pagination) ? oState.pagination.recordOffset : 0;
        var results = (oState.pagination) ? oState.pagination.rowsPerPage : null;
        
        var filterQuery = WR.URL.paramsToString( this.filterQuery );
		
        return  ( WR.URL.paramsToString( this._buildSortParameters( oState ) ) ) +
                "&startIndex=" + startIndex +
				( this.expandedColumns.length > 0 ? "&" + WR.URL.paramsToString( { expandColumn : this.expandedColumns } ) : "" ) +
                ( results != null ? "&results=" + results : "" ) +
                ( filterQuery == '' ? '' : ( '&' + filterQuery ) );
    },
	
	changeSortOrder : function( key, newPosition )
	{
		var index = WR.Array.indexOf( this.sortColumns, key );
		if( index == -1 || newPosition == index )
			return;
			
		this.sortColumns.splice( index, 1 );
		var dir = this.sortDirections.splice( index, 1 );
		
		if( newPosition > this.sortColumns.length ){
			this.sortColumns.push( key );
			this.sortDirections.push( dir );
		}else{
			this.sortColumns.splice( newPosition, 0, key );
			this.sortDirections.splice( newPosition, 0, dir );
		}
		
		this.update();
	},
	
	addSortColumn : function( key, direction, index )
	{
		if ( index >= 0 && index < this.sortColumns.length ) {
			this.sortColumns.splice( index, 0, key );
			this.sortDirections.splice( index, 0, direction );
		} else {
			this.sortColumns.push( key );
			this.sortDirections.push( direction );
		}
		
		this.update();
	},
	
	removeSortColumn : function( index )
	{
		this.sortColumns.splice( index, 1 );
		this.sortDirections.splice( index, 1 );
		
		this.update();
	},
	
	setSortDirection : function( index, dir )
	{
		this.sortDirections[ index ] = dir;
		
		this.update();
	},
	
	resetIndicators : function()
	{
		var columns = this.getColumnSet();
		for( var i in columns.keys ){
			columns.keys[i]._elThLiner.style.background = 'none';
		}
	},
	
	sanitize : function( key )
	{
		return key.replace(/[^\w\-]/g,"");
	},
	
	setSortIndicators : function( sortColumns, sortDirections )
	{
	},
    
    _getSortableColumns : function()
    {
        var columns = [];
        var columnSet = this.getColumnSet().keys;
        for ( var i in columnSet )
        {
            columns.push( { key: columnSet[i].getKey() } );
        }
        return columns;
    },
    
    _sendRequest : function( request ) {
        var me = this;
        this._showStatusContainer( true );
        this.getDataSource().sendRequest( request, {
            success : function( oRequest, oResponse, oPayload ) {
                me._showStatusContainer( false );
                me.onDataReturnSetRows( oRequest, oResponse, oPayload );
				me.hasLoadedADataTable = true;
				me.isDuringPaginationRequest = false;
				me.enableColumnPicker();
				me.enableSortMenu();
				me.setSortIndicators( oResponse.meta.sort, oResponse.meta.dir );
            },
            failure : function( sRequest, oResponse, oPayload ) {
                me._showStatusContainer( false );
                me.isDuringPaginationRequest = false;
                WR.Notify.error( WR.format( '<?jformat Unable to update data table: {error}?>',
                                            oResponse.responseText != null
                                               ? oResponse.responseText
                                               : '<?jformat server aborted or there was an error processing your request.?>' ) );
                },
            scope : me,
            argument : {}
        });
    },
    
    _showStatusContainer : function( show ) {
        if ( this.opts.statusContainer )
            YAHOO.util.Dom.setStyle( this.opts.statusContainer, 'display', show ? 'inline' : 'none' );
    },
    
    sortColumn : function( oColumn, sDir )
    {
        var oState = this.getState();
        var sSortDir = sDir || this.getColumnSortDir( oColumn )
        
        if ( oState.pagination )
            oState.pagination.recordOffset = 0;
        
        oState.sortedBy = {
            key : oColumn.key,
            dir : sSortDir
        };
		
		this.sortColumns = [ oColumn.key ];
		this.sortDirections = [ sSortDir.split( '-' )[2] ];
        
        this.request = this.buildRequest( oState );

        this.unselectAllRows();
        this.unselectAllCells();
        
        this.history.update();
    },
    
    handlePagination : function( state )
    {
        if ( this.isDuringPaginationRequest )
                return;
        this.isDuringPaginationRequest = true;

        state.sortedBy = this.get( "sortedBy" );
        
        state.pagination = {
            recordOffset : state.recordOffset,
            rowsPerPage  : state.rowsPerPage
        };
        
        this.request = this.buildRequest( state );
        this.handleHistoryNavigation();
        
        this.get( 'paginator' ).setState( state );
    },

    addDefaultColumnFormatters : function()
    {
        var htmlFormatter = function( elCell, oRecord, oColumn, oData ) {
            elCell.innerHTML = WR.HTML.escape( oData );
        };
        for ( i in this.opts.columns )
        {
            if( typeof this.opts.columns[i].formatter == 'undefined' )
                this.opts.columns[i].formatter = htmlFormatter;
        }
    },
    
    update : function()
    {
        var request = this.buildRequest( this.getState() );
        
        var oldParams = new WR.URL.ParamMap( WR.URL.ParseParams( this.request ) )
        var newParams = new WR.URL.ParamMap( WR.URL.ParseParams( request ) );
        if ( !oldParams.equals( newParams ) )
        {
            this.request = request;
            this.history.update();
        }
        else
            this.handleHistoryNavigation();
    },
	
	updateFilterQuery : function( value )
	{
		this.filterQuery.q = value;
	},
    
    initializeFilter : function( initial )
    {
        if( !this.opts.filter )
            return;
        
        this.filter = new WR.AutoCompleteFilter( this.opts.filter );
        this.filter.subscribeToQueryChange( function( e, el, table ) {
            table.updateFilterQuery( this.value() );
            table.setToFirstPageUpdate();
            table.history.update();
        }, this );
        
        if ( initial )
            this.filter.setValue( initial );
        
        this.filterQuery.q = this.filter.value();
        
        var me = this;
    },
    
    setToFirstPageUpdate : function()
    {
        if( this.get( 'paginator' ).getCurrentPage() > 1 )
            this.get( 'paginator' ).setPage( 1 );
        else
            this.update();
    },
    
    forEachRow : function( fn, obj )
    {
        for( var row = this.getFirstTrEl(); row != null; row = this.getNextTrEl( row ) )
            fn( row, obj );
    },
    
    addOnResizeListener : function( fn, arg )
    {
        var table = this.getTableEl();
        var events = [ "columnSetWidthEvent", "postRenderEvent" ];
        
        for( var i in events )
        {
            this.subscribe( events[ i ], function() {
                fn( YAHOO.util.Dom.getRegion( table ), arg );
            });
        }
        
        YAHOO.util.Event.addListener( window, "resize", function() {
            fn( YAHOO.util.Dom.getRegion( table ), arg );
        });
    },
    
    getColumnByName : function( key )
    {
        var columns = this.getColumnSet().flat;
        for ( var i in columns )
        {
            if( columns[ i ].key == key )
                return columns[ i ];
        }
        
        return null;
    },
    
    getHistoryParameter : function( paramName )
    {
        var sParam = this.request;
        if ( !sParam )
            return [];
        
        return WR.URL.ParseParams( sParam )[ paramName ];
    },
    
    subscribeToInitialNavigate : function( fn, obj, overrideContext )
    {
        this.navigateEvent.subscribe( fn, obj, overrideContext );
    },
    
    mergeNewState : function( state )
    {
        var defaultState = this.opts.config.initialRequest;
        
        if ( !state )
            return defaultState;
        
        var bookmarkParams = new WR.URL.ParamMap( WR.URL.ParseParams( state ) );
        
        //We want bookmarks/reports to always go back to the first page.  We really shouldn't have these as part of the data table state in the first place. See bug #32979.
        bookmarkParams.remove( 'results' );
        bookmarkParams.remove( 'startIndex' );
        var defaultParams = new WR.URL.ParamMap( WR.URL.ParseParams( defaultState ) );
        
        for ( var key in bookmarkParams.params )
            defaultParams.set( key, bookmarkParams.params[key] );
        
        return defaultParams.finish();
    },
    
	setColumnPicker : function( columnPicker )
	{
		this.columnPicker = columnPicker;
	},
	
	setSortMenu : function( sortMenu )
	{
		this.sortMenu = sortMenu;
	},
	
	enableColumnPicker : function()
	{
		if( this.columnPicker ) 
			this.columnPicker.enable();
	},
	
	enableSortMenu : function()
	{
		if( this.sortMenu )
			this.sortMenu.enable();
	}
	
};

YAHOO.lang.extend( WR.DataTable, YAHOO.widget.DataTable, WR.DataTable.prototype );
