let openDialog = false;
let projectGreaseEntrypoint = "";

function onProjectGreaseClick(mustOpenModal, modal, projectGreaseUrl, btnId) {
    if (mustOpenModal) {
        if (!projectGreaseUrl)
            disableModalConfirmBtn(btnId);
        modal.showModal();
    } else {
        openProjectGrease(projectGreaseUrl);
    }
}

function showProjectGreaseModal(modalId) {
    var modal = document.getElementById(modalId);
    modal.style.display = "block";
}

function onModalWindowsCancel(modal) {
    modal.close();
}

function openProjectGrease(externalUrl) {
    window.open(externalUrl, '_blank');
}

function onModalWindowConfirm(externalUrl, modal) {
    if (externalUrl) {
        window.open(externalUrl, '_blank');
        onModalWindowsCancel(modal);
    }
}

function disableModalConfirmBtn(btnId) {
    const btnEl = document.getElementById(btnId);
    btnEl.setAttribute("disabled", true);
    btnEl.classList.add("modal-btn-disabled");
}

function docReady(fn) {
    if (document.readyState === "complete" || document.readyState === "interactive") {
        setTimeout(fn, 1);
    } else {
        document.addEventListener("DOMContentLoaded", fn);
    }
}

function isSafeUrl(url) {
    if (!url)
        return false;
    if (url.startsWith("http")) {
        const winLoc = window.location.host;
        if (!(url.includes(`${winLoc.protocol}//${winLoc.host}/SiteData/`)))
            return false;
    }
    return true;
}

function storeGreaseData(showDialog, projectGreaseUrl) {
    if (showDialog && /^true$/.test(showDialog))
        openDialog = true;
    if (projectGreaseUrl) {
        if (isSafeUrl(projectGreaseUrl))
            projectGreaseEntrypoint = projectGreaseUrl;
    }
}

docReady(function () {
    if (openDialog) {
        const modalWindowId = "project-grease-modal";
        const modalConfirmBtnId = "modal-confirm-btn";
        const modalCancelBtnId = "modal-cancel-btn";
        const greasePanelId = "grease-panel";
        const dialog = document.getElementById(modalWindowId);
        document.getElementById(modalConfirmBtnId)
            .addEventListener("click",
                onModalWindowConfirm.bind(null, projectGreaseEntrypoint, dialog));

        document.getElementById(modalCancelBtnId)
            .addEventListener("click", onModalWindowsCancel.bind(null, dialog));

        document.getElementById(greasePanelId)
            .addEventListener("click",
                onProjectGreaseClick.bind(null, openDialog, dialog, projectGreaseEntrypoint, modalConfirmBtnId));
    }
});