
// <?import /JavaScript/Notification/Notification.js?>
// <?import /JavaScript/json2.js?>
// <?import /JavaScript/Util/URL.js?>
// <?import /JavaScript/FilterCreation/GenerateFilterParameters.js?>
// <?import /JavaScript/DashboardAPI/RelevanceResult.js?>
// WARNING: This file depends on HTML/ReportCustom/reportcustom.body.html
// <?import /JavaScript/yui-import/ConnectionManager.js?>
// <?import /JavaScript/CreateRequest.js?>

function GetFilterParam()
{
	return '&' + WR.URL.paramsToString( WR.generateFilterParameters() );
};

function AsyncEvaluateString( questionString, answerObjectID )
{
	var http_request = CreateRequest();
	if ( http_request )
	{
		http_request.onreadystatechange = Function( "ReplaceString( '" + answerObjectID + "', http_request ); " );
		http_request.open( 'POST', '/webreports', true );
		http_request.setRequestHeader( "Content-type", "application/x-www-form-urlencoded" );
		http_request.send( 'page=EvaluateRelevanceOnly&expr=' + encodeURIComponent(questionString) + GetFilterParam()  );
	}
	else
	{
		ReplaceString( answerObjectID, http_request );
	}
};

function ThrowError( message )
{
    var e = new Error();
    e.message = message;
    throw e;
};

function GetQueryBody( query, coerce )
{
	var parameters = new WR.URL.ParamMap();
	if ( coerce )
		parameters.add( "coerce", "string" );
	if ( WR.currentSiteID )
		parameters.add( "currentSiteID", WR.currentSiteID );
	parameters.add( "expr", query );
	return parameters.finish() + GetFilterParam();
};

function ParseResult( resultText )
{
	return JSON.parse( resultText, function (key, value) {
        if (typeof value === 'string') {
            var a =
/^(Mon|Tue|Wed|Thu|Fri|Sat|Sun), \d\d (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) \d\d\d\d \d\d:\d\d:\d\d (\+|-)\d\d\d\d$/.exec(value);
            if (a) {
                var d = new Date();
                d.setTime( Date.parse( value ) );
                return d;
            }
        }
        return value;
    } );
};

function JSONRelevanceQuery( query, parser, coerce )
{
    var http_request = CreateRequest();
    if( !http_request )
        ThrowError( 'Error creating http request object. Try updating your browser.' ); 
        
    http_request.open( 'POST', '/json/relevance', false );
    http_request.setRequestHeader( "Content-type", "application/x-www-form-urlencoded" );
    http_request.send( GetQueryBody( query, coerce ) );
    
    if( http_request.readyState != 4 || http_request.status != 200 )
        ThrowError( 'Error contacting server. Status code: ' + http_request.status + ' Message: ' + http_request.responseText );
    
    var result = parser( http_request.responseText );
    if( result.error )
        ThrowError( result.error );
    
    return result.plural
        ? result.result
        : result.result[0];
};

function GetNodeValue( node )
{
	var s = "";
	for ( var i = 0; i < node.childNodes.length; i++ )
		s += node.childNodes[i].nodeValue;
		
	return s;
}

function EvaluateRelevance( query )
{
	var http_request = CreateRequest();
	if ( !http_request )
		ThrowError( 'Error creating http request object.  Try updating your browser.' );
	
	http_request.open( 'POST', '/webreports', false );
	http_request.setRequestHeader( "Content-type", "application/x-www-form-urlencoded" );
	http_request.send( 'page=EvaluateRelevanceOnly&' + GetQueryBody( query ) );
	
	if ( http_request.readyState != 4 || http_request.status != 200 )
		ThrowError( 'Error contacting server.  Status code: ' + http_request.status );
		
	var xmlDoc = http_request.responseXML;
	var errorTag = xmlDoc.getElementsByTagName( 'error' );
	
	if ( errorTag.length > 0 )
		ThrowError( errorTag[0].firstChild.nodeValue );
	
	var answerArray = new Array();
	var answerlist = xmlDoc.getElementsByTagName( 'answerlist' );
	
	if ( answerlist.length > 0 )
	{
		var answers = xmlDoc.getElementsByTagName( 'answer' );
		var plurality = xmlDoc.getElementsByTagName( 'plurality' );
		
		if ( plurality[0].firstChild.nodeValue == '0' )
			return GetNodeValue( answers[0] );
	
		for ( i = 0; i < answers.length; i++ )
			answerArray[i] = GetNodeValue( answers[i] );
	}
	
	return answerArray;
};

function Relevance( query, callback )
{
	if ( !callback )
		return WR.makeRelevanceArray( JSONRelevanceQuery( query, ParseResult ) );
	
	YAHOO.util.Connect.asyncRequest( "POST", "/json/relevance", {
		success : function( o ) {
			var result = ParseResult( o.responseText );
			
			if ( result.error )
				callback.failure( result.error );
			else
				callback.success( result.plural ? WR.makeRelevanceArray( result.result ) : result.result[0] );
		},
		failure : function( o ) {
			callback.failure( o.statusText ? o.statusText + ": " : "" + o.responseText ? o.responseText : "" );
		}
	}, GetQueryBody( query ) );
	
	return null;
};

function ReplaceString( replace_object_id, request )
{
	if ( replace_object_id != '' )
	{
		replaceObject = document.getElementById( replace_object_id );
		if ( !replaceObject )
		{
			WR.Notify.error( 'The object to contain the evaluation is not valid.' );
		}
		else if ( !request )
		{
			replaceObject.innerHTML = 'Error creating http request object.  Try updating your browser.';
		}
		else if ( request.readyState == 1 )
		{
			replaceObject.innerHTML = 'loading...';
		}
		else if ( request.readyState == 2 )
		{
			replaceObject.innerHTML = 'loaded.';
		}
		else if ( request.readyState == 4 )
		{
			if ( http_request.status == 200 )
			{
				var xmlDoc = request.responseXML;
				replaceObject.innerHTML = xmlDoc;
			}
			else
			{
				replaceObject.innerHTML = 'Error contacting server.  Status code: ' + http_request.status;
			}
		}
	}
};

// just a stub
function RegisterRefreshHandler( elementID, signalName )
{
};

function GetInputNode( name, value )
{
    var input = document.createElement( 'input' );
    input.name = name;
    input.value = value;
    input.type = 'hidden';
    return input;
};

function Join( array, start, end, separator )
{
	return array.slice( start, end ).join( separator );
};

function OpenComputerGroup( compIds, title )
{   
    var postForm = document.createElement( 'form' );
    postForm.action = '/webreports';
    postForm.method = 'POST';
    postForm.id = 'AdhocComputerGroupForm';
    postForm.style.display = 'none';
    document.body.appendChild( postForm );
    postForm = document.getElementById( 'AdhocComputerGroupForm' );
   
    if( typeof compIds == 'object' )
    {
		var size = 20000;
		for ( var i=0; i<compIds.length; i+=size )
			postForm.appendChild( GetInputNode( 'CommaSeparatedComputerID', Join( compIds, i, i + size - 1, ',' ) ) );
    }
    else
    {
        postForm.appendChild( GetInputNode( 'ComputerID', compIds ) );
    }

    postForm.appendChild( GetInputNode( 'page', 'AdhocComputerGroupReport' ) );
    if( title )
        postForm.appendChild( GetInputNode( 'Title', title ) );
    
    postForm.submit();
};
