// AutoCompleteFilter.js

// <?import /JavaScript/WR.js?>
// <?import /JavaScript/DefaultTextField/DefaultTextField.js?>

// <?import /JavaScript/yui-import/Event.js?>
// <?import /JavaScript/yui-import/DataSource.js?>
// <?import /JavaScript/yui-import/AutoComplete.js?>
// <?import /JavaScript/yui-import/Dom.js?>

/*
 Parameters:
    filterInputID
    filterContainerID
    defaultText (optional)
    pageSize (optional)
*/
WR.AutoCompleteFilter = function( opts )
{
    this.opts = opts;
    
    this.defaultTextField = new WR.DefaultTextField( opts.filterInputID, opts.defaultText );
    
    this.queryChange = new YAHOO.util.CustomEvent( "queryChange", this );
    
    var oFilter = new YAHOO.util.FunctionDataSource( function( query ) {
        this.queryChange.fire();
    });
    oFilter.scope = this;
    oFilter.applyLocalFilter = false;
    var oAutoComplete = new YAHOO.widget.AutoComplete( opts.filterInputID, opts.filterContainerID, oFilter );
    oAutoComplete.minQueryLength = 0;

    YAHOO.util.Event.addListener( opts.filterInputID, "paste", function( e, me ) {
        var clipboardData;

        // Stop data actually being pasted into div
        e.stopPropagation();
        e.preventDefault();

        // Get pasted data via clipboard API
        clipboardData = e.clipboardData || window.clipboardData;
        this.setValue( clipboardData.getData('Text') );
        this.queryChange.fire();
    }, this, true );
};

WR.AutoCompleteFilter.prototype = {
    
    clear : function() {
        this.defaultTextField.clear();
        this.queryChange.fire();
    },
    
    value : function() {
        return this.defaultTextField.value();
    },
    
    setValue : function( value ) {
        this.defaultTextField.setValue( value );
    },
    
    focus : function() {
        this.defaultTextField.focus();
    },
    
    subscribeToQueryChange : function( fn, obj, overrideContext ) {
        this.queryChange.subscribe( fn, obj, overrideContext );
    },
    
    getInputEl : function() {
        return YAHOO.util.Dom.get( this.opts.filterInputID );
    }
};
