// ConditionList.js

// <?import /JavaScript/FilterCreation/FilterCreation.js?>
// <?import /JavaScript/FilterCreation/FilterCreationManager.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/FilterCreation/Condition.js?>
// <?import /JavaScript/FilterCreation/FilterCreation.css?>
// <?import /JavaScript/jQuery/jquery.js?>


WR.Filters.ConditionList = function( parent, contentTypes )
{
    this.id = parent.finish().id + '_conditionList';
    this.el = WR.DOM.el( 'div' )
                .setProperty( 'id', this.id )
                .addClass( 'ConditionList-Div' );
    WR.DOM.el( parent ).appendChild( this.el.finish() );
    
    this.onConditionRemoved = new YAHOO.util.CustomEvent( 'onConditionRemoved', this );
    this.onConditionAdded = new YAHOO.util.CustomEvent( 'onConditionAdded', this );
    
    this.contentTypes = contentTypes;
    
    WR.Filters.Condition.nextIdNo = 0;
    
    this.conditions = [];
    
    this.addNewCondition();
    
    this.el.appendChild( WR.DOM.el( 'div' ).addClass( 'wr_dummy' ).finish() );
};

WR.Filters.ConditionList.prototype = {
    
    generateState : function()
    {
        var me = this;
        
        var state = [];
        
        $( '#' + me.id + ' .Condition-Div' ).map(
            function( index, el )
            {
                for ( var i in me.conditions )
                {
                    if ( me.conditions[i].id == el.id )
                    {
                        state.push( me.conditions[i].generateState() );
                        break;
                    }
                }
            }
        );
        
        return state;
    },
    
    applyState : function( state )
    {
        while ( state != null && state.length > this.conditions.length )
        {
            this.addNewCondition();
        }
        
        for ( i in state )
        {
            this.conditions[i].applyState( state[i] );
        }
    },
    
    addNewCondition : function()
    {
        return this.addNewConditionAfter( this.conditions.length - 1 );
    },
    
    addNewConditionAfter : function( index )
    {
        var newCondition = new WR.Filters.Condition( this.el, this.contentTypes,  {
            remove: this.removeCondition,
            add: this.addConditionAfter,
            updateContentVisibility: this._updateContentVisibility,
            scope: this } );
        
        this.conditions.push( newCondition );
            
        if ( index != -1 )
        {
            jQuery ( this.conditions[index].el.finish() ).after( newCondition.el.finish() );
            
            //Workaround to bug 37476.
            if ( YAHOO.env.ua.ie >= 8 )
                $( '#filterSection' ).hide().show();
        }
        else
        {
            jQuery ( this.el.finish() ).children().filter( '.wr_dummy' ).before( newCondition.el.finish() );
        }
        
        this.onConditionAdded.fire();
        
        return newCondition;
    },
    
    removeCondition : function( condition, me )
    {
        $( condition.el.finish() ).remove();
        var newConditions = [];
        for ( var i in me.conditions )
        {
            if ( me.conditions[i].id != condition.id )
                newConditions.push( me.conditions[i] ); 
        }
        me.conditions = newConditions;
        WR.Filters.update();
        me.onConditionRemoved.fire();
    },
    
    addConditionAfter : function( condition, me )
    {
        var newCondition = me.addNewConditionAfter( jQuery.inArray( condition, me.conditions ) );
        return newCondition;
    },
    
    size : function()
    {
        return this.conditions.length;
    },
    
    _updateIndividualContentVisibility : function( contentType )
    {
        var found = false;
        for ( i in this.conditions )
        {
            if ( this.conditions[i].selectedContentType.getName() == contentType.getName() )
            {
                found = true;
                break;
            }
        }
        
        if ( found )
        {
            this.contentTypes.hide( contentType );
            for ( i in this.conditions )
            {
                if ( this.conditions[i].selectedContentType.getName() != contentType.getName() )
                {
                    $( '#' + this.conditions[i].id + ' .Condition-ContentTypePicker option[value="' + contentType.getName() + '"]' ).remove();
                }
                else if ( $( '#' + this.conditions[i].id + ' .Condition-ContentTypePicker option[value="' + contentType.getName() + '"]' ).length == 0 )
                {
                    $( '#' + this.conditions[i].id + ' .Condition-ContentTypePicker' ).append( WR.DOM.el( 'option' )
                                                                                                                     .setProperty( 'value', contentType.getName() )
                                                                                                                    .innerText( contentType.getName() )
                                                                                                                    .finish() );
                }
            }
        }
        else
        {
            this.contentTypes.show( contentType );
            for ( i in this.conditions )
            {
                if ( $( '#' + this.conditions[i].id + ' .Condition-ContentTypePicker option[value="' + contentType.getName() + '"]' ).length == 0 )
                {
                    $( '#' + this.conditions[i].id + ' .Condition-ContentTypePicker' ).append( WR.DOM.el( 'option' )
                                                                                                                     .setProperty( 'value', contentType.getName() )
                                                                                                                    .innerText(contentType.getName())
                                                                                                                    .finish() );
                }
            }
        }
    },
    
    _updateContentVisibility : function( me )
    {
        var onlyOneTypes = me.contentTypes.getOnlyAllowOneContentTypes();
        for ( i in onlyOneTypes )
        {
            me._updateIndividualContentVisibility( onlyOneTypes[i] );
        }
        
        
    }
    
    
};