// ActionContentType.js

// <?import /JavaScript/FilterCreation/PropertyPickers/ActionPropertyPicker.js?>
// <?import /JavaScript/FilterCreation/Operators/Operator.js?>
// <?import /JavaScript/FilterCreation/Selectors/AbsoluteDateSelector.js?>
// <?import /JavaScript/FilterCreation/Selectors/SelectorList.js?>
// <?import /JavaScript/FilterCreation/Operators/SelectFromListOperator.js?>
// <?import /JavaScript/FilterCreation/FilterCreation.js?>
// <?import /JavaScript/FilterCreation/Selectors/StringSelector.js?>
// <?import /JavaScript/FilterCreation/Selectors/IsOrIsNotMultipleOpsSelector.js?>
// <?import /JavaScript/FilterCreation/Selectors/NumberMultipleOpsSelector.js?>
// <?import /JavaScript/FilterCreation/ContentTypes/ContentType.js?>
// <?import /JavaScript/FilterCreation/Selectors/IsOrIsNotFromListSelector.js?>
// <?import /JavaScript/yui-import/YahooGlobalObject.js?>
// <?import /JavaScript/FilterCreation/Selectors/NumberSelector.js?>

WR.Filters.ActionContentType = function()
{
    WR.Filters.ActionContentType.superclass.constructor.call( this, 'Action', '<?jformat Action?>', false );
};

WR.Filters.ActionContentType.prototype = {
    
    generatePropertyPicker : function( div )
    {
        return new WR.Filters.ActionPropertyPicker( div );
    },
    
    generateSelectorList : function( div, propertyData )
    {
        if ( propertyData.id == 'ID' )
            return new WR.Filters.SelectorList( div, WR.Filters.IsOrIsNotSelector );
        else if ( propertyData.id == 'Status' )
            return new WR.Filters.SelectorList( div, WR.Filters.IsOrIsNotFromListSelector, [
                                                                    { id: 'Open', name: '<?jformat Open?>' },
                                                                    { id: 'Stopped', name: '<?jformat Stopped?>' },
                                                                    { id: 'Expired', name: '<?jformat Expired?>' }]
                                                                    );
        else if ( propertyData.id == 'Source Type' )
            return new WR.Filters.SelectorList( div, WR.Filters.IsOrIsNotFromListSelector, [
                                                                    { id: 'Fixlet', name: '<?jformat Fixlet?>' },
                                                                    { id: 'Task', name: '<?jformat Task?>' },
                                                                    { id: 'Baseline', name: '<?jformat Baseline?>' },
                                                                    { id: 'Custom', name: '<?jformat Custom?>' }]
                                                                    );
        else if ( propertyData.id == 'Source Fixlet\'s Site' || propertyData.id == 'Site' )
            return new WR.Filters.SelectorList( div, WR.Filters.IsOrIsNotFromListSelector, WR.Filters.SiteNames );
        else if ( propertyData.id == 'Result Count' )
            return new WR.Filters.SelectorList( div, WR.Filters.NumberMultipleOpsSelector,
            [
                { key: 'Count', operatorClass: WR.Filters.IsOperator, operatorArgs: [] },
                { key: 'Status', label: '<?jformat with status?>', operatorClass: WR.Filters.SelectFromListOperator, operatorArgs: [ 'is', '<?jformat is?>', WR.Filters.ActionResultStatuses ] }
            ] );
        else if ( propertyData.id == 'Reported Count' )
            return new WR.Filters.SelectorList( div, WR.Filters.NumberSelector );
        else if ( propertyData.id == 'Time Issued' )
            return new WR.Filters.SelectorList( div, WR.Filters.AbsoluteDateSelector );
        else
            return new WR.Filters.SelectorList( div, WR.Filters.StringSelector );
    }
    
};

YAHOO.lang.extend( WR.Filters.ActionContentType, WR.Filters.ContentType, WR.Filters.ActionContentType.prototype );