// FixletContentType.js

// <?import /JavaScript/FilterCreation/PropertyPickers/FixletPropertyPicker.js?>
// <?import /JavaScript/FilterCreation/Operators/Operator.js?>
// <?import /JavaScript/FilterCreation/Selectors/AbsoluteDateSelector.js?>
// <?import /JavaScript/FilterCreation/Selectors/SelectorList.js?>
// <?import /JavaScript/FilterCreation/Operators/SelectFromListOperator.js?>
// <?import /JavaScript/FilterCreation/FilterCreation.js?>
// <?import /JavaScript/FilterCreation/Selectors/StringSelector.js?>
// <?import /JavaScript/FilterCreation/Selectors/IsOrIsNotMultipleOpsSelector.js?>
// <?import /JavaScript/FilterCreation/ContentTypes/ContentType.js?>
// <?import /JavaScript/FilterCreation/Selectors/IsOrIsNotFromListSelector.js?>
// <?import /JavaScript/yui-import/YahooGlobalObject.js?>
// <?import /JavaScript/FilterCreation/Selectors/NumberSelector.js?>

WR.Filters.FixletContentType = function()
{
    WR.Filters.FixletContentType.superclass.constructor.call( this, 'Fixlet', '<?jformat Content?>', false );
};

WR.Filters.FixletContentType.prototype = {
    
    generatePropertyPicker : function( div )
    {
        return new WR.Filters.FixletPropertyPicker( div );
    },
    
    generateSelectorList : function( div, propertyData )
    {
        if ( propertyData.id == 'Source Release Date' )
            return new WR.Filters.SelectorList( div, WR.Filters.AbsoluteDateSelector );
        else if ( propertyData.id == 'Site' )
            return new WR.Filters.SelectorList( div, WR.Filters.IsOrIsNotFromListSelector, WR.Filters.SiteNames );
        else if ( propertyData.id == 'Type' )
            return new WR.Filters.SelectorList( div, WR.Filters.IsOrIsNotFromListSelector, [
                                                                    { id: 'Fixlet', name: '<?jformat Fixlet?>' },
                                                                    { id: 'Task', name: '<?jformat Task?>' },
                                                                    { id: 'Analysis', name: '<?jformat Analysis?>' },
                                                                    { id: 'Baseline', name: '<?jformat Baseline?>' } ]
                                                                    );
        else if ( propertyData.id == 'Visibility' )
            return new WR.Filters.SelectorList( div, WR.Filters.IsOrIsNotFromListSelector, [ { id: 'Visible', name: '<?jformat Visible?>' },
                                                                                             { id: 'Hidden', name: '<?jformat Hidden?>' } ] );
        else if ( propertyData.id == 'Applicable Computer Count'
                 || propertyData.id == 'Deployed Action Count'
                 || propertyData.id == 'Open Action Count'
                 || propertyData.id == 'Progress'
                 || propertyData.id == 'Remediated Computer Count'
                 || propertyData.id == 'Unlocked Computer Count' )
            return new WR.Filters.SelectorList( div, WR.Filters.NumberSelector );
        else if ( propertyData.id == 'ID' )
            return new WR.Filters.SelectorList( div, WR.Filters.IsOrIsNotMultipleOpsSelector,
            [
                { key: 'ID', operatorClass: WR.Filters.IsOperator, operatorArgs: [] },
                { key: 'SiteID', label: '<?jformat in site?>', operatorClass: WR.Filters.SelectFromListOperator, operatorArgs: [ 'is', '<?jformat is?>', WR.Filters.SiteNames ] }
            ] );
        else if ( propertyData.id == 'Applicable Computer IDs'
                  || propertyData.id == 'Remediated Computer IDs' )
            return new WR.Filters.SelectorList( div, WR.Filters.IsOrIsNotSelector );
        else
            return new WR.Filters.SelectorList( div, WR.Filters.StringSelector );
    }
    
};

YAHOO.lang.extend( WR.Filters.FixletContentType, WR.Filters.ContentType, WR.Filters.FixletContentType.prototype );