// Operator.js

// <?import /JavaScript/FilterCreation/FilterCreationManager.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/yui-import/Event.js?>
// <?import /JavaScript/FilterCreation/FilterCreation.js?>
// <?import /JavaScript/FilterCreation/FilterCreation.css?>
// <?import /JavaScript/jQuery/jquery.js?>

WR.Filters.Operator = function( id, name )
{
    this.name = name;
    this.id = id;
    this.valueField = null;
};

WR.Filters.Operator.prototype = {
    
    generateValuePicker : function( div )
    {
        if ( $( div.finish() ).children().length == 0 )
        {
            this.valueField = WR.DOM.el( 'input' )
                .addClass( 'ValuePickerField' )
                .addListener( 'blur', function( e ) { WR.Filters.update(); } )
                .addListener( 'keypress', function( e ) { WR.Filters.update(); } );
            
            var keyListener = new YAHOO.util.KeyListener( this.valueField.finish(),
                                                            { keys: 13 },
                                                            { fn: function( type, args, obj ) { $( obj.valueField.finish() ).blur();  },
                                                              scope: this,
                                                              correctScope: true } );
            keyListener.enable();
            
            div.appendChild( this.valueField.finish() );
        }
        else
        {
            this.valueField = WR.DOM.el( $( div.finish() ).children().get( 0 ) );
        }
    },
    
    getValue : function()
    {
        if ( this.valueField ) 
            return $( this.valueField.finish() ).val();
        else
            return null;
    },
    
    setValue : function( value )
    {
        $( this.valueField.finish() ).val( value );
    }
    
};