// Selector.js

// <?import /JavaScript/FilterCreation/FilterCreation.js?>
// <?import /JavaScript/FilterCreation/FilterCreationManager.js?>
// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/FilterCreation/FilterCreation.css?>
// <?import /JavaScript/jQuery/jquery.js?>

WR.Filters.Selector = function( parent )
{
    this.id = parent.finish().id + '_selector' + WR.Filters.Selector.nextIdNo++;
    this.el = WR.DOM.el( 'div' )
                .setProperty( 'id', this.id )
                .addClass( 'Selector-Div' );
    
    this.operatorDiv = WR.DOM.el( 'div' )
                    .addClass( 'Selector-OperatorDiv' );
    
    this.valuePickerDiv = WR.DOM.el( 'div' )
                    .addClass( 'Selector-ValuePickerDiv' );
    
    this.el.appendChild( this.operatorDiv.finish() )
                .appendChild( this.valuePickerDiv.finish() );
                
    WR.DOM.el( parent ).appendChild( this.el.finish() );
    
    this.selectedOperator = null; // Must be set in constructor of subclass
    this.latestState = null;
};

WR.Filters.Selector.nextIdNo = 0;

WR.Filters.Selector.prototype = {
    
    generateState : function()
    {
        return {
            selectedOperatorName : this.selectedOperator.id,
            selectedOperatorValue : this.selectedOperator.getValue()
        };
    },
    
    hasValidState : function()
    {
        return this.selectedOperator.getValue() != null;
    },
    
    applyState : function( state )
    {
        this.latestState = state;
        $( this.valuePickerDiv.finish() ).children().remove();
        this.selectedOperator.generateValuePicker( this.valuePickerDiv );
        this.selectedOperator.setValue( state.selectedOperatorValue );
    },
    
    reapplyLatestState : function()
    {
        if ( this.latestState )
            this.applyState( this.latestState );
    },
    
    addBooleanLabel : function( text )
    {
        $( this.el.finish() ).prepend( WR.DOM.el( 'label' )
                                .addClass( 'BooleanLabel' )
                                .innerHTML( text )
                                .finish() );
                
    },
    
    addRemoveButton : function( list )
    {
        var me = this;
        this.el.appendChild(  WR.DOM.el( 'input' )
                    .setProperty( 'type', 'image' )
                    .setProperty( 'src', '/images/besreports/' + WR.language + '/x.bmp' )
                    .addClass( 'RemoveSelectorButton' )
                    .addListener( 'click', function(e) { list.removeSelector( me ); } )
                    .finish() );
    },
    
    operatorSelected : function()
    {
        var selectedValue = jQuery( this.operatorSelector.finish() ).val();
        this.selectedOperator = this.operatorList.findOperatorByID( selectedValue );
        this.selectedOperator.generateValuePicker( this.valuePickerDiv );
        WR.Filters.update();
    }

};
