/* 
 * More info at: http://phpjs.org
 * 
 * This is version: 2.91
 * php.js is copyright 2009 Kevin van Zonneveld.
 * 
 * Portions copyright Brett Zamir (http://brett-zamir.me), Kevin van Zonneveld
 * (http://kevin.vanzonneveld.net), Onno Marsman, Michael White
 * (http://getsprink.com), Waldo Malqui Silva, Paulo Ricardo F. Santos, Jack,
 * Philip Peterson, Jonas Raoni Soares Silva (http://www.jsfromhell.com), Ates
 * Goral (http://magnetiq.com), Legaev Andrey, Ratheous, Martijn Wieringa,
 * Nate, Philippe Baumann, lmeyrick
 * (https://sourceforge.net/projects/bcmath-js/), Enrique Gonzalez, Theriault,
 * Webtoolkit.info (http://www.webtoolkit.info/), Jani Hartikainen, Ash Searle
 * (http://hexmen.com/blog/), travc, Ole Vrijenhoek, Carlos R. L. Rodrigues
 * (http://www.jsfromhell.com), Alex,
 * http://stackoverflow.com/questions/57803/how-to-convert-decimal-to-hex-in-javascript,
 * pilus, Erkekjetter, T.Wild, GeekFG (http://geekfg.blogspot.com), Andrea
 * Giammarchi (http://webreflection.blogspot.com), Johnny Mast
 * (http://www.phpvrouwen.nl), d3x, marrtins, stag019, Michael Grier, mdsjack
 * (http://www.mdsjack.bo.it), gettimeofday, Oleg Eremeev, Mirek Slugen,
 * David, Arpad Ray (mailto:arpad@php.net), Breaking Par Consulting Inc
 * (http://www.breakingpar.com/bkp/home.nsf/0/87256B280015193F87256CFB006C45F7),
 * Steve Hilder, Marc Palau, KELAN, Steven Levithan
 * (http://blog.stevenlevithan.com), Josh Fraser
 * (http://onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/),
 * Public Domain (http://www.json.org/json2.js), T.J. Leahy, majak, Lars
 * Fischer, Alfonso Jimenez (http://www.alfonsojimenez.com), Pellentesque
 * Malesuada, Tyler Akins (http://rumkin.com), Felix Geisendoerfer
 * (http://www.debuggable.com/felix), Kankrelune
 * (http://www.webfaktory.info/), gorthaur, Sakimori, Caio Ariede
 * (http://caioariede.com), Aman Gupta, Karol Kowalski, Thunder.m, AJ, Steve
 * Clay, noname, Gilbert, duncan, class_exists, Marco, madipta, David James,
 * Frank Forte, Subhasis Deb, nobbler, Denny Wardhana, Nathan, Mateusz
 * "loonquawl" Zalega, Arno, marc andreu, ger, Sanjoy Roy, 0m3r, sankai,
 * Douglas Crockford (http://javascript.crockford.com), john
 * (http://www.jd-tech.net), mktime, Ole Vrijenhoek (http://www.nervous.nl/),
 * T. Wild, Jon Hohle, ReverseSyntax, Thiago Mata
 * (http://thiagomata.blog.com), Linuxworld, nord_ua, lmeyrick
 * (https://sourceforge.net/projects/bcmath-js/this.), David Randall, Bryan
 * Elliott, Pyerre, Soren Hansen, T0bsn, Peter-Paul Koch
 * (http://www.quirksmode.org/js/beat.html), Tim Wiel, Brad Touesnard, MeEtc
 * (http://yass.meetcweb.com), Ozh, XoraX (http://www.xorax.info), J A R, Marc
 * Jansen, Paul, Hyam Singer (http://www.impact-computing.com/), Raphael (Ao
 * RUDLER), kenneth, Francesco, LH, echo is bad, djmix, Lincoln Ramsay, Der
 * Simon (http://innerdom.sourceforge.net/), Bayron Guevara, JB, Eugene Bulkin
 * (http://doubleaw.com/), Victor, Slawomir Kaniecki, Pierre-Luc Paour, Martin
 * Pool, Kirk Strobeck, Rick Waldron, Kristof Coomans (SCK-CEN Belgian
 * Nucleair Research Centre), Saulo Vallory, Valentina De Rosa, Jason Wong
 * (http://carrot.org/), Daniel Esteban, Christoph, Mick@el, rezna, Simon
 * Willison (http://simonwillison.net), Gabriel Paderni, Marco van Oort,
 * penutbutterjelly, Anton Ongson, Blues (http://tech.bluesmoon.info/), Tomasz
 * Wesolowski, Eric Nagel, Bobby Drake, Luke Godfrey, Pul, Wagner B. Soares,
 * Artur Tchernychev, Yves Sucaet, sowberry, hitwork, Norman "zEh" Fuchs,
 * Ulrich, johnrembo, Nick Callen, ejsanders, Aidan Lister
 * (http://aidanlister.com/), Brian Tafoya (http://www.premasolutions.com/),
 * Philippe Jausions (http://pear.php.net/user/jausions), Orlando, dptr1988,
 * strcasecmp, strcmp, Taras Bogach, Alan C, uestla, metjay, ChaosNo1, James,
 * Chris, Pedro Tainha (http://www.pedrotainha.com), Alexander Ermolaev
 * (http://snippets.dzone.com/user/AlexanderErmolaev), DxGx, Christian
 * Doebler, setcookie, Greg Frazier, Tod Gentille, Alexander M Beedie,
 * FremyCompany, baris ozdil, FGFEmperor, 3D-GRAF, jakes, Yannoo, gabriel
 * paderni, Luis Salazar (http://www.freaky-media.com/), Tim de Koning, Jalal
 * Berrami, date, Francois, Scott Cariss, vlado houba, stensi, taith, Robin,
 * Matt Bradley, Cord, Manish, Atli Þór, davook, Andrej Pavlovic, Dino,
 * Greenseed, mk.keck, Garagoth, Russell Walker (http://www.nbill.co.uk/), YUI
 * Library: http://developer.yahoo.com/yui/docs/YAHOO.util.DateLocale.html,
 * Blues at http://hacks.bluesmoon.info/strftime/strftime.js, Andreas, Jamie
 * Beck (http://www.terabit.ca/), DtTvB
 * (http://dt.in.th/2008-09-16.string-length-in-bytes.html), Leslie Hoare, Ben
 * Bryan, Diogo Resende, Howard Yeend, Allan Jensen (http://www.winternet.no),
 * Benjamin Lupton, Rival, Luke Smith (http://lucassmith.name), booeyOH, Cagri
 * Ekin, Amir Habibi (http://www.residence-mixte.com/), Kheang Hok Chin
 * (http://www.distantia.ca/), Jay Klehr
 * 
 * Dual licensed under the MIT (MIT-LICENSE.txt)
 * and GPL (GPL-LICENSE.txt) licenses.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL KEVIN VAN ZONNEVELD BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */ 


function sha1 (str) {
    // Calculate the sha1 hash of a string  
    // 
    // version: 909.322
    // discuss at: http://phpjs.org/functions/sha1
    // +   original by: Webtoolkit.info (http://www.webtoolkit.info/)
    // + namespaced by: Michael White (http://getsprink.com)
    // +      input by: Brett Zamir (http://brett-zamir.me)
    // +   improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
    // -    depends on: utf8_encode
    // *     example 1: sha1('Kevin van Zonneveld');
    // *     returns 1: '54916d2e62f65b3afa6e192e6a601cdbe5cb5897'
    var rotate_left = function (n,s) {
        var t4 = ( n<<s ) | (n>>>(32-s));
        return t4;
    };

    /*var lsb_hex = function (val) { // Not in use; needed?
        var str="";
        var i;
        var vh;
        var vl;

        for ( i=0; i<=6; i+=2 ) {
            vh = (val>>>(i*4+4))&0x0f;
            vl = (val>>>(i*4))&0x0f;
            str += vh.toString(16) + vl.toString(16);
        }
        return str;
    };*/

    var cvt_hex = function (val) {
        var str="";
        var i;
        var v;

        for (i=7; i>=0; i--) {
            v = (val>>>(i*4))&0x0f;
            str += v.toString(16);
        }
        return str;
    };

    var blockstart;
    var i, j;
    var W = new Array(80);
    var H0 = 0x67452301;
    var H1 = 0xEFCDAB89;
    var H2 = 0x98BADCFE;
    var H3 = 0x10325476;
    var H4 = 0xC3D2E1F0;
    var A, B, C, D, E;
    var temp;

    str = this.utf8_encode(str);
    var str_len = str.length;

    var word_array = [];
    for (i=0; i<str_len-3; i+=4) {
        j = str.charCodeAt(i)<<24 | str.charCodeAt(i+1)<<16 |
        str.charCodeAt(i+2)<<8 | str.charCodeAt(i+3);
        word_array.push( j );
    }

    switch (str_len % 4) {
        case 0:
            i = 0x080000000;
        break;
        case 1:
            i = str.charCodeAt(str_len-1)<<24 | 0x0800000;
        break;
        case 2:
            i = str.charCodeAt(str_len-2)<<24 | str.charCodeAt(str_len-1)<<16 | 0x08000;
        break;
        case 3:
            i = str.charCodeAt(str_len-3)<<24 | str.charCodeAt(str_len-2)<<16 | str.charCodeAt(str_len-1)<<8    | 0x80;
        break;
    }

    word_array.push( i );

    while ((word_array.length % 16) != 14 ) {word_array.push( 0 );}

    word_array.push( str_len>>>29 );
    word_array.push( (str_len<<3)&0x0ffffffff );

    for ( blockstart=0; blockstart<word_array.length; blockstart+=16 ) {
        for (i=0; i<16; i++) {W[i] = word_array[blockstart+i];}
        for (i=16; i<=79; i++) {W[i] = rotate_left(W[i-3] ^ W[i-8] ^ W[i-14] ^ W[i-16], 1);}


        A = H0;
        B = H1;
        C = H2;
        D = H3;
        E = H4;

        for (i= 0; i<=19; i++) {
            temp = (rotate_left(A,5) + ((B&C) | (~B&D)) + E + W[i] + 0x5A827999) & 0x0ffffffff;
            E = D;
            D = C;
            C = rotate_left(B,30);
            B = A;
            A = temp;
        }

        for (i=20; i<=39; i++) {
            temp = (rotate_left(A,5) + (B ^ C ^ D) + E + W[i] + 0x6ED9EBA1) & 0x0ffffffff;
            E = D;
            D = C;
            C = rotate_left(B,30);
            B = A;
            A = temp;
        }

        for (i=40; i<=59; i++) {
            temp = (rotate_left(A,5) + ((B&C) | (B&D) | (C&D)) + E + W[i] + 0x8F1BBCDC) & 0x0ffffffff;
            E = D;
            D = C;
            C = rotate_left(B,30);
            B = A;
            A = temp;
        }

        for (i=60; i<=79; i++) {
            temp = (rotate_left(A,5) + (B ^ C ^ D) + E + W[i] + 0xCA62C1D6) & 0x0ffffffff;
            E = D;
            D = C;
            C = rotate_left(B,30);
            B = A;
            A = temp;
        }

        H0 = (H0 + A) & 0x0ffffffff;
        H1 = (H1 + B) & 0x0ffffffff;
        H2 = (H2 + C) & 0x0ffffffff;
        H3 = (H3 + D) & 0x0ffffffff;
        H4 = (H4 + E) & 0x0ffffffff;
    }

    temp = cvt_hex(H0) + cvt_hex(H1) + cvt_hex(H2) + cvt_hex(H3) + cvt_hex(H4);
    return temp.toLowerCase();
}

function utf8_encode ( argString ) {
    // Encodes an ISO-8859-1 string to UTF-8  
    // 
    // version: 909.322
    // discuss at: http://phpjs.org/functions/utf8_encode
    // +   original by: Webtoolkit.info (http://www.webtoolkit.info/)
    // +   improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
    // +   improved by: sowberry
    // +    tweaked by: Jack
    // +   bugfixed by: Onno Marsman
    // +   improved by: Yves Sucaet
    // +   bugfixed by: Onno Marsman
    // +   bugfixed by: Ulrich
    // *     example 1: utf8_encode('Kevin van Zonneveld');
    // *     returns 1: 'Kevin van Zonneveld'
    var string = (argString+''); // .replace(/\r\n/g, "\n").replace(/\r/g, "\n");

    var utftext = "";
    var start, end;
    var stringl = 0;

    start = end = 0;
    stringl = string.length;
    for (var n = 0; n < stringl; n++) {
        var c1 = string.charCodeAt(n);
        var enc = null;

        if (c1 < 128) {
            end++;
        } else if (c1 > 127 && c1 < 2048) {
            enc = String.fromCharCode((c1 >> 6) | 192) + String.fromCharCode((c1 & 63) | 128);
        } else {
            enc = String.fromCharCode((c1 >> 12) | 224) + String.fromCharCode(((c1 >> 6) & 63) | 128) + String.fromCharCode((c1 & 63) | 128);
        }
        if (enc !== null) {
            if (end > start) {
                utftext += string.substring(start, end);
            }
            utftext += enc;
            start = end = n+1;
        }
    }

    if (end > start) {
        utftext += string.substring(start, string.length);
    }

    return utftext;
}
