// <?import /JavaScript/CreateRequest.js?>

function UpdateProgress( progressID ) 
{
	var request = CreateRequest();
	if ( request ) 
	{
		request.onreadystatechange = function() { UpdateProgressStateChange( request, progressID ); }
		request.open( 'POST', '/webreports', true );
		request.setRequestHeader( 'Content-type', 'text/html' );
		request.send( 'page=LoadingStatus&progressID=' + progressID );
	}
};

function UpdateProgressStateChange( request, progressID )
{
	if ( request.readyState == 4 && request.status == 200 ) 
	{
		var progress = request.responseText;
		if ( progress < 100 ) 
		{
			UpdateProgressHTML( progressID, progress );
		} 
		else 
		{
			var progressDiv = document.getElementById( 'wr_progress' );
			progressDiv.style.display = 'none';
			var progressBgDiv = document.getElementById( 'wr_progressbg' );
			progressBgDiv.style.display = 'none';
			var progressFgDiv = document.getElementById( 'wr_progressfg' );
			progressFgDiv.style.display = 'none';
		}
	}
};

function UpdateProgressHTML( progressID, progress ) 
{
	var progressDiv = document.getElementById( 'wr_progress' );
	progressDiv.innerHTML = '';
	progressDiv.style.display = '';
	var progressFgDiv = document.getElementById( 'wr_progressfg' );
	progressFgDiv.style.width = (progress * 5) + 'px';
	progressFgDiv.style.display = '';
	var progressBgDiv = document.getElementById( 'wr_progressbg' );
	progressBgDiv.style.display = '';
	setTimeout( 'UpdateProgress(' + progressID + ')', 2500 );
};