
WR.format = function( format )
{
    var conversions =
    {
        '{_cbrace}' : '}',
        '{_obrace}' : '{',
        '{_cr}' : '\r',
        '{_lf}' : '\n',
        '{_tab}' : '\t'
    };
    
    function nextMatch( formatString )
    {
        var obraceIndex = formatString.indexOf( '{' );
        var cbraceIndex = formatString.indexOf( '}' );
        if ( obraceIndex >= 0 && cbraceIndex >= 0 && obraceIndex < cbraceIndex )
        {
            return {
                    matchString: formatString.slice( obraceIndex, cbraceIndex + 1 ),
                    index: obraceIndex
                };
        }
        return null;
    }
    
    var tail = format;
    var formattedString = '';
    
    var currentArgument = 1;
    for ( var match = nextMatch( tail ); match != null; match = nextMatch( tail ) )
    {
        var replacement = conversions[match.matchString];
        if ( replacement == null )
        {
            if ( currentArgument >= arguments.length )
            {
                var args = [];
                for ( var i = 1; i < arguments.length; ++i )
                    args.push( arguments[i] );
                throw 'Too many format arguments in WR.format. Input was ' + format + '. Arguments: ' + JSON.stringify( args );
            }
            else
                replacement = arguments[ currentArgument++ ];
        }
        
        formattedString += tail.substr( 0, match.index ) + replacement;
        tail = tail.slice( match.index + match.matchString.length );
    }
    
    formattedString += tail;
    
    return formattedString;
}