var appName = "Web Reports";
var loaderParentNodeId = "wr_mainpage";
var mainContainerId = "wr_content";
var loaderWrapperId = "loader-wrapper";
var checkProcessIntervalTime = 2000;
var pollingTimeout = 300000;
var webreportsUrl = "/webreports";
var restartHtmlString = "self-restart-command-executed";

function onAddDataSourceSubmit()
{
	if (validateForm()) {
		var myButtons = [
			{
				text: '<?jformat Yes?>', handler: function() {
					hideContents();
					this.hide();
					verifyCertificate();
				}
			},
			{
				text:'<?jformat Cancel?>',
				handler: function() {
					this.hide();
				}
			}
		];
		var restartDialog = initDialog("restart-dialog", '<?jformat This will restart Web Reports. Continue??>', myButtons);
		restartDialog.show();
	}
}

function onOverwriteDatastoreSubmit(evt)
{
	evt.preventDefault(); 
	hideContents();
	submitForm("overwrite-datasource-form");
}

function initDialog(dialogId, message, buttons)
{
	dialog = new YAHOO.widget.SimpleDialog(dialogId, {
		width: "25em",
		fixedcenter: true,
		modal: true,
		visible: false,
		draggable: false
	});
	dialog.setHeader(appName);
	dialogBodyElement = document.createElement("p");
	dialogBodyElement.innerText = message;
	dialogBodyElement.className = "dialog-label";
	dialog.setBody(dialogBodyElement);
	dialog.cfg.setProperty("icon", YAHOO.widget.SimpleDialog.ICON_WARN);
	if (buttons.length > 0) {
		dialog.cfg.queueProperty("buttons", buttons);
	}
	dialog.render(document.body);
	return dialog;
}

function manageVerifiyCertificateOutput(result)
{
	// on Windows result returns true before the process stops
	// on Linux the http post responds after the process re-started, and it returns false
	checkWebReportsProcess(function(output) {
		if (!output["valid"]) {
			showErrorDialog(output["msg"]);
			return;
		}
        if (!result) {
			redirectToMainPage();
			return;
		}
		checkWebReportsProcess(function(processReady) {
			if (!processReady["valid"]) {
				showErrorDialog(processReady["msg"]);
				return;
			}
			redirectToMainPage();
		}, true);
	}, !result);
}

function showErrorDialog(errorMessage)
{
	removeLoader(showMainContent);
	var myButtons = [
		{
			text:'<?jformat Ok?>',
			handler: function() {
				this.hide();
				window.location.href = webreportsUrl;
		}
	}];
	var errorMsg = WR.format( '<?jformat Error restarting Web Reports: "{errorMessage}"?>', errorMessage );
	var errorDialog = initDialog("error-dialog", errorMsg, myButtons);
	errorDialog.show();
}

function showRestartingDonePopup()
{
	dialog = new YAHOO.widget.SimpleDialog("restart-done", {
		width: "25em",
		fixedcenter: true,
		modal: true,
		visible: false,
		draggable: false
	});
	dialog.setHeader(appName);
	dialogBodyElement = document.createElement("p");
	dialogBodyElement.innerText = '<?jformat Web Reports restarted successfully?>';
	dialogBodyElement.className = "dialog-label";
	dialog.setBody(dialogBodyElement);
	dialog.cfg.setProperty("icon", YAHOO.widget.SimpleDialog.ICON_WARN);
	var buttons = [
		{
			text: '<?jformat Ok?>',
			handler: function() {
				window.location.href = webreportsUrl;
			}
		}
	];
	dialog.cfg.queueProperty("buttons", buttons);
	dialog.render(document.body);
	dialog.show();
}

function redirectToMainPage()
{
	removeLoader(showRestartingDonePopup);
}

function hideContents()
{
	hideMainContent();
	showLoader();
}

// an interval function, wrapped by a timeout, execute regular http get calls to understand if the current 
// process is going to stop (whileStarting = false) or start (whileStarting = true)
function checkWebReportsProcess(cb, whileStarting)
{
	try {
		var loadingRequest = false;
		var intervalId = setInterval(function() {
			if (loadingRequest) return;
			var xmlHttp = new XMLHttpRequest();
			xmlHttp.onreadystatechange = function() {
				if (xmlHttp.readyState == 4) {
					loadingRequest = false;
					var startCondition = whileStarting && (xmlHttp.status == 200);
					var stopCondition = !whileStarting && (xmlHttp.status !== 200);
					if (startCondition || stopCondition) {
						clearInterval(intervalId);
						clearTimeout(timeoutID);
						cb({
							msg: '<?jformat Response ok?>',
							valid: true
						});
					}
				}
			}
			xmlHttp.open("GET", webreportsUrl, true);
			loadingRequest = true;
			xmlHttp.send(null);
		}, checkProcessIntervalTime);
		var timeoutID = setTimeout(function() {
			clearInterval(intervalId);
			cb({
				msg: '<?jformat Timeout!?>',
				valid: false
			});
		}, pollingTimeout);
	} catch(error) {
		console.log("error checking process..." + error);
		cb({
			msg: error,
			valid: false
		});
	}
}

function showLoader()
{
	var loaderGifUrl = "/JavaScript/yui/build/assets/skins/sam/ajax-loader.gif";
	var parentNode = document.getElementById(loaderParentNodeId);
	var loaderElement = document.createElement("img");
	loaderElement.setAttribute("src", loaderGifUrl);
	loaderElement.setAttribute("id", "add-datasource-loader");
	var loaderWrapper = document.createElement("div");
	loaderWrapper.setAttribute("id", loaderWrapperId);
	loaderWrapper.style.textAlign = "center";
	loaderWrapper.style.marginTop = "5rem";
	loaderWrapper.appendChild(loaderElement);
	var loaderTextWrapper = document.createElement("p");
	loaderTextWrapper.innerText = '<?jformat Please wait for the current process to restart...?>';
	
	loaderWrapper.appendChild(loaderTextWrapper);
	parentNode.appendChild(loaderWrapper);
}

function removeLoader(cb)
{
	var parentNode = document.getElementById(loaderParentNodeId);
	var loaderElement = document.getElementById(loaderWrapperId);
	if (loaderElement) {
	parentNode.removeChild(loaderElement);
	}
	cb();
}

function showMainContent()
{
	var mainContainerEl = document.getElementById(mainContainerId);
	mainContainerEl.style.display = "block";
}

function removeHrefFromFirstLinkTag(elementId) {
	var htmlElement = document.getElementById(elementId).getElementsByTagName("a")[0];
	htmlElement.href = "#";
}

function hideMainContent()
{
	var mainContainerEl = document.getElementById(mainContainerId);
	mainContainerEl.style.display = "none";
	var navigationContainer = document.getElementById("wr_subnavigation");
	navigationContainer.innerHTML = "";
	var subNavigationContainer = document.getElementById("wr_navigation").getElementsByTagName("ul")[0];
	subNavigationContainer.innerHTML = "";
	var rightHeader = document.getElementById("wr_rightheader");
	rightHeader.innerHTML = "";
	removeHrefFromFirstLinkTag("wr_logo");
	removeHrefFromFirstLinkTag("wr_title");
}

// submit the form via ajax call, without reloading the page
function submitForm(formId)
{
	var formElement = $("#" + formId);
	$.ajax({
		url: formElement.attr("action"),
		type: formElement.attr("method"),
		data: formElement.serialize(),
		success: function(response) {
			if (response.indexOf(restartHtmlString) !== -1) {
				manageVerifiyCertificateOutput(true);
			} else {
				$("html").html(response);
			}
		},
		error: function(xhr, status, error) {
			console.log("Error on form submit: ", error);
			manageVerifiyCertificateOutput(false);
		}
	});
}

function validateForm()
{
	var validForm = false;
	if ( document.getElementById( "ServerURL" ).value == "" ) {
		alert( "<?jformat Please specify a datasource name?>" );
	} else {
		validForm = true;
	}
	return validForm;
}

function verifyCertificate()
{
	var serverURL = document.getElementById( "ServerURL" ).value;
	WR.jsonRequest( "/json/verify-certificate", {
		success: function( result ) {
			if ( result.trusted )
			{
				submitForm("DatasourceForm");
				return;
			}
			
			if ( window.confirm( result.masthead 
			                   ? mastheadText( result.masthead, serverURL ) 
			                   : certificateText( result.certificate, serverURL ) ) )
				addCertificate( serverURL, result.certificate, result.masthead );
		}
		},
		{ url : serverURL }
	);
}

function mastheadText( masthead, server )
{
	return WR.format( '<?jformat The security certificate used by "{server}" is not trusted. Do you want to trust security certificates signed by "{organization}" when connecting to "{server}"??>', server, masthead.organization, server );
}

function certificateText( certificate, server )
{
	return WR.format( '<?jformat The security certificate used by "{server}" is not trusted.{_lf}{_lf}{error}{_lf}{_lf}Do you want to trust this certificate when connecting to "{server}"??>', server, certificate.error, server );
}

function addCertificate( serverURL, certificate, masthead )
{
	WR.postRequest( "/post/add-certificate", {
		success : function() {
			submitForm("DatasourceForm");
		}
		},
		new WR.URL.ParamMap( { url : serverURL, certHash : certificate.hash, mastheadHash : ( masthead ? masthead.hash : null ) } )
	);
}