// <?import /JavaScript/Util/DOM.js?>
// <?import /JavaScript/json2.js?>
// <?import /JavaScript/Util/JSONRequest.js?>
// <?import /JavaScript/jQuery/jquery.js?>
// <?import /JavaScript/WR.js?>
// <?import /JavaScript/WebReportsLoader/WebReportsLoader.css?>

WR.WebReportsLoader = function( loadingSection, redirectURL )
{
    this.loadingSection = loadingSection;
    this.redirectURL = redirectURL;
    this.state = {};
}

WR.WebReportsLoader.TIMEOUT = 30;

WR.WebReportsLoader.prototype = {
    
    init : function()
    {
        WR.jsonRequest( 'storestatus',
            {
                success : function( o, me )
                {
                    me.state = o;
                    if ( me.state.complete )
                       window.location = me.redirectURL;
                    me._setupDisplay();
                    me._updateDisplay();
                    me._updateLoop();
                },
                
                failure : function( o, me )
                {
                    WR.Notify.error( '<?jformat There was an error getting the loading status.?>' );
                }
            },
            { waitForChange: false }, this );
    },
    
    _forceCheck : function()
    {
        var requestComplete = false;
        WR.jsonRequest( 'storestatus',
            {
                success : function( o, me )
                {
                    requestComplete = true;
                    me.state = o;
                    if ( me.state.complete )
                        window.location = me.redirectURL;
                    me._updateDisplay();
                    me._updateLoop();
                },
                
                failure : function( o, me )
                {
                    requestComplete = true;
                    WR.Notify.error( '<?jformat There was an error getting the loading status.?>' );
                }
            },
            { waitForChange: false }, this );
        
        var me = this;
        setTimeout(
            function()
            {
                if ( !requestComplete )
                    WR.Notify.error( '<?jformat There was an error getting the loading status.?>' );
            }, WR.WebReportsLoader.TIMEOUT * 1000
        );
    },
    
    _updateLoop : function()
    {
        var requestComplete = false;
        WR.jsonRequest( 'storestatus',
            {
                success : function( o, me )
                {
                    requestComplete = true;
                    me.state = o;
                    if ( me.state.complete )
                        window.location = me.redirectURL;
                    else
                    {
                        me._updateDisplay();
                        me._updateLoop();
                    }
                },
                
                failure : function( o, me )
                {
                    requestComplete = true;
                    me._forceCheck();
                }
            },
            { waitForChange: true, timeout: WR.WebReportsLoader.TIMEOUT }, this );
        
        var me = this;
        setTimeout(
            function()
            {
                if ( !requestComplete )
                    me._forceCheck();
            }, WR.WebReportsLoader.TIMEOUT * 1500
        );
    },
    
    _setupDisplay : function()
    {
        var databases = this.state.databases;
        for ( var dbIndex in databases )
        {
            var database = databases[ dbIndex ];
                            
            var databaseBox = WR.DOM.el( 'div' )
                    .addClass( 'DatabaseBox' );
                    
            if ( databases.length > 1 )
            {
                databaseBox.appendChild(
                        WR.DOM.el( 'h3' )
                            .addClass( 'DatabaseName' )
                            .innerText( database.name )
                            .finish() );
            }
                    
            this.loadingSection.appendChild( databaseBox.finish() );

            var storeList =
                WR.DOM.el( 'div' )
                    .addClass( 'StoreList' );
            
            for ( var storeIndex in database.stores )
            {
                var store = database.stores[ storeIndex ];
                
                var image = storeIndex == 0
                    ? '/JavaScript/yui/build/assets/skins/sam/ajax-loader.gif'
                    : '/images/besreports/' + WR.language  + '/bullet.png';
                
                storeList.appendChild(
                    WR.DOM.el( 'div' )
                        .addClass( 'StoreDiv' )
                        .setProperty( 'id', 'StoreDiv_' + database.id + '_' + store.id )
                        .setProperty( 'name', store.id )
                        .appendChild(
                            WR.DOM.el( 'img' )
                                .addClass( 'StoreCompleteImage' )
                                .setProperty( 'src', image )
                                .finish() )
                        .appendChild(
                            WR.DOM.el( 'label' )
                                .addClass( 'StoreNameLabel' )
                                .innerText( store.description )
                                .finish() )
                        .finish() );
            }
            
            databaseBox.appendChild(
                storeList.finish()
            );
            
        }

    },
    
    _updateDisplay : function()
    {
        var allComplete = this.state.complete;
        var databases = this.state.databases;
        var allDatabasesComplete = true;
        
        for ( var dbIndex in databases )
        {
            var database = databases[ dbIndex ];
            
            allDatabasesComplete = allDatabasesComplete && database.complete;
            
            for ( var storeIndex in database.stores )
            {
                var store = database.stores[ storeIndex ];
                
                if ( store.complete == true )
                    this._storeComplete( WR.DOM.get( 'StoreDiv_' + database.id + '_' + store.id ).finish() );
            }
        }
        
        if ( !allComplete && allDatabasesComplete && databases.length > 0 )
            WR.Notify.updateHTML( '<img class="StoreCompleteImage" src="/JavaScript/yui/build/assets/skins/sam/ajax-loader.gif"/> <?jformat Your existing filters are being upgraded.  This will only be required the first time you start the Web Reports server.  You will be redirected automatically when this process is complete.?>' );
    },
    
    _storeComplete : function( storeDiv )
    {
        $( storeDiv ).children( '.StoreCompleteImage' ).attr( 'src', '/images/besreports/' + WR.language + '/check.bmp' );
        $( storeDiv ).next().children( '.StoreCompleteImage' ).attr( 'src', '/JavaScript/yui/build/assets/skins/sam/ajax-loader.gif' );
    }
    
}
