
//UTILS
Date.prototype.mmddyy = function() {
		var mm = this.getMonth() + 1; // getMonth() is zero-based
		var dd = this.getDate();

		return [
			(mm>9 ? '' : '0') + mm,
			(dd>9 ? '' : '0') + dd,
			this.getFullYear().toString().substr(-2)
         ].join('/');
	};
	
var one_day=1000*60*60*24;

function barFilterData(data,filter){
	var data_size = data.length;
	var category_size = data[0].length;
	
	var result = [];
	for(var i=0;i<data_size;i++){
		result[i] = [];
	}

	if(filter == "auto")
	{
		var isfirstnotzero=false;
		for(var i=0; i<category_size; i++){
			var deletable = true;
			for( var j=0; j<data_size; j++){
				if(!isfirstnotzero){
					if(data[j][i][1] != 0){
						isfirstnotzero = true;
						deletable = false;
					}
				} else {
					deletable = false;
				}
			}
			if(!deletable){
				for( var j=0; j<data_size; j++){
					result[j].push(data[j][i]);
				}
			
			}			
		}
	} else {
		var start = new Date(filter);
		result.map(function(category){return category.push([start.toString(),0]);});
		for(var i=0; i<category_size; i++){
			var deletable = true;
			var entry_date = new Date(data[0][i][0]);
			if(entry_date > start){
				deletable = false;
			}			
			if(!deletable){
				for( var j=0; j<data_size; j++){
					result[j].push(data[j][i]);
				}
			
			}			
		}
	}	
	return result;
}

function dropDownInitialize(name, jqpObj){
		
		var data = jqpObj.getVariable("data");
		var elem = $("#"+name);
		elem.change(function() {
			var selection_value = $("#"+name+" :selected").val();
			var filtered_data = barFilterData(data,selection_value);
		   jqpObj.updateSelection(filtered_data);
		});
		
	};
	
function tooltipContentEditor(str, seriesIndex, pointIndex, plot) {
	var n_series = plot.data.length;
	var tot = 0;
	for(var i=0; i<n_series;i++){
		tot+= plot.data[i][pointIndex][1];
	}
	var percentage = plot.data[seriesIndex][pointIndex][1]/tot*100;
	var date = new Date(plot.data[seriesIndex][pointIndex][0]);
	return "<div style='background-color:white;'><b>"+plot.series[seriesIndex]["label"] + "<b><br> " +
			date.mmddyy() +"<br>" +
			plot.data[seriesIndex][pointIndex][1] +	" ("+ parseInt(percentage) +"%)<br>" +
			"total: "+tot+"</div>";
}	

function populateSelect(name,data){
	var select = $("#"+name+" > select");
	data.forEach(function(option){
		select.append($('<option>', { 
			value: option[1],
			text : option[0] 
		}));
	});	
}

//end UTILS	


if( typeof aegon == "undefined" ) var aegon = new Object();

function getChartType(type){
	switch(type){
		case "barChart":
			return $.jqplot.BarRenderer;
		case "pieChart":
			return $.jqplot.PieRenderer;
	}
	return null;
}
	
var barChart = $.jqplot.BarRenderer;
var pieChart = $.jqplot.PieRenderer;
var lineChart = "";


aegon.JQPlotObject = function( divID, type, w, h ){
	this.variables = new Object();
	this.options = new Object();
	this.variables.data = [];
	this.variables.filteredData = this.variables.data;
	this.variables.id = divID;
	this.variables.type = getChartType(type);
	this.variables.width = w;
	this.variables.height = h;	
	
	
	if(this.variables.type != null){
		this.addOption("seriesDefaults",{renderer:this.variables.type});
		this.addOption("seriesDefaults",{rendererOptions: { shadowOffset: 0}});
		this.addOption("grid",{borderColor: 'white', shadow: false, drawBorder: true});
	}
	
	this.addOption("grid",{background: '#ffffff'});
	this.addOption("axes",{yaxis:{min:0}});
	var jqpd =$("#"+divID+"_plot");
	jqpd.width(w);
	jqpd.height(h);
	

}

aegon.JQPlotObject.prototype = {
	getVariable: function(name){
		return this.variables[name];
	},
	addVariable: function(name, value){
		this.variables[name] = value;
		if(name == "data" ){
			this.variables.filteredData = this.variables.data;
			if(this.isBarChart() || this.isLineChart()){
				this.variables.filteredData = barFilterData(this.variables.data,"auto");
			}
		}
	},
	addOption: function(name,value){
		if(this.options[name]){
			$.extend(this.options[name],value);
		}
		else this.options[name] = value;
	},
	addColor: function(color){
		if(!(color instanceof Array)) color=[color];
		this.addOption("seriesColors",color);
	},
	draw: function(){
		this.barMarginAdjust();
		this.plot = $.jqplot(this.variables.id+"_plot", this.variables.filteredData,this.options);
	},
	updateSelection: function(filteredData){
		this.variables.filteredData = filteredData;
		this.plot.destroy();
		this.draw();
	},
	isBarChart: function(){
		return this.variables.type == getChartType("barChart");
	},
	isLineChart: function(){
		return this.variables.type == null;
	},
	barMarginAdjust: function(){
		if(this.isBarChart()){
			var f_size = this.variables.filteredData[0].length;
			var margin = 10;
			if(f_size > 32){
				margin = 1;
			}
			this.options.seriesDefaults.rendererOptions.barMargin = margin;
			this.options.axes.xaxis.min = this.variables.filteredData[0][0][0];

		}
		else if(this.isLineChart()){
			this.options.axes.xaxis.min = this.variables.filteredData[0][0][0];
		}
	}
}
var JQPlotObject = aegon.JQPlotObject;
