######################################################################
# Fuctions used to collect input parameter for each field
######################################################################

if [[ $DB_TARGET = "mssql" ]]
then
  VAR_DB_TAG="MSSQL"
  PROP_DB_TAG="Mssql"
else
  VAR_DB_TAG="DB2"
  PROP_DB_TAG="Db2"
fi

selectComponents()
{
logFnBegin "${FUNCNAME[0]}"
silentCheckNotNull "COMPONENT_SRV" "$COMPONENT_SRV"
checkFatalerror $?
silentCheckNotNull "COMPONENT_WR" "$COMPONENT_WR"
checkFatalerror $?
silentCheckNotNull "COMPONENT_WEBUI" "$COMPONENT_WEBUI"
checkFatalerror $?
if [[ $COMPONENT_SRV = "" || $COMPONENT_WR = "" || $COMPONENT_WEBUI = "" ]]
then
  opt1="[1]"
  opt2="[2]"
  opt3="[3]"
  opt4="[4]"
  opt5="[5]"
  opt6="[6]"
  opt7="[7]"
  installedMsg="`nls_replace 'ComponentInstalled'`"
  statusSrv=""
  statusWr=""
  statusWebUI=""
  isRpmInstalled "$DEF_RPM_SRV_PREFIX"
  [[ $? -ne 0 ]] && statusSrv="$installedMsg"
  isRpmInstalled "$DEF_RPM_WR_PREFIX"
  [[ $? -ne 0 ]] && statusWr="$installedMsg"
  isRpmInstalled "$DEF_RPM_WEBUI_PREFIX"
  [[ $? -ne 0 ]] && statusWebUI="$installedMsg"

  statusSrvWebUI=""
  if [[ $statusSrv != "" && $statusWebUI != "" ]]
  then
    statusSrvWebUI="$installedMsg"
  fi
  statusWrWebUI=""
  if [[ $statusWr != "" && $statusWebUI != "" ]]
  then
    statusWrWebUI="$installedMsg"
  fi
  statusSrvWr=""
  if [[ $statusSrv != "" && $statusWr != "" ]]
  then
    statusSrvWr="$installedMsg"
  fi

  writeMsg stdout "$DEF_INPUT_SEPARATOR"
  while :
  do
    writeMsg stdout "`nls_replace 'ComponentSelectionDesc'`"
    writeMsg stdout "$opt1  `nls_replace 'ComponentSelectionOpt1'`"
    writeMsg stdout "$opt2  `nls_replace 'ComponentSelectionOpt2'` $statusSrv"
    writeMsg stdout "$opt3  `nls_replace 'ComponentSelectionOpt3'` $statusWr"
    writeMsg stdout "$opt4  `nls_replace 'ComponentSelectionOpt4'` $statusWebUI"
    writeMsg stdout "$opt5  `nls_replace 'ComponentSelectionOpt5'` $statusSrvWebUI"
    writeMsg stdout "$opt6  `nls_replace 'ComponentSelectionOpt6'` $statusWrWebUI"
    writeMsg stdout "$opt7  `nls_replace 'ComponentSelectionOpt7'` $statusSrvWr"
    writeMsg stdout "`nls_replace 'ChooseOpts' \"$opt1\"`"
    read inLine
    if [[ $inLine = "1" || $inLine = "" ]]
    then 
      COMPONENT_SRV="true"
      COMPONENT_WR="true"
      COMPONENT_WEBUI="true"
      break
    elif [[ $inLine = "2" ]]
    then 
      COMPONENT_SRV="true"
      COMPONENT_WR="false"
      COMPONENT_WEBUI="false"
      break
    elif [[ $inLine = "3" ]]
    then
      COMPONENT_SRV="false"
      COMPONENT_WR="true"
      COMPONENT_WEBUI="false"
      break
    elif [[ $inLine = "4" ]]
    then
      COMPONENT_SRV="false"
      COMPONENT_WR="false"
      COMPONENT_WEBUI="true"
      break
    elif [[ $inLine = "5" ]]
    then
      COMPONENT_SRV="true"
      COMPONENT_WR="false"
      COMPONENT_WEBUI="true"
      break
    elif [[ $inLine = "6" ]]
    then
      COMPONENT_SRV="false"
      COMPONENT_WR="true"
      COMPONENT_WEBUI="true"
      break
    elif [[ $inLine = "7" ]]
    then
      COMPONENT_SRV="true"
      COMPONENT_WR="true"
      COMPONENT_WEBUI="false"
      break
    else
      writeMsg stdout "`nls_replace 'TEM0002E' \"$inLine\"`"
    fi
  done
  ##Components already installed will not be reinstalled
  unsetInstalledComponents
fi
addResponseFileEntry "COMPONENT_SRV" "$COMPONENT_SRV"
addResponseFileEntry "COMPONENT_WR" "$COMPONENT_WR"
addResponseFileEntry "COMPONENT_WEBUI" "$COMPONENT_WEBUI"
logFnEnd "${FUNCNAME[0]}"
}

chooseBesWWWRoot()
{
logFnBegin "${FUNCNAME[0]}"
silentCheckNotNull "BES_WWW_FOLDER" "$BES_WWW_FOLDER"
checkFatalerror $?
if [[ $BES_WWW_FOLDER = "" ]]
then
  writeMsg stdout "$DEF_INPUT_SEPARATOR"
  while :
  do
    writeMsg stdout "`nls_replace 'BesWWWRootDesc'`"
    writeMsg stdout "`nls_replace 'BesWWWRootMsg' \"$DEF_BES_ROOT\"`"
    read -e inLine
    if [[ $inLine = "" ]]
    then
      inLine="$DEF_BES_ROOT"
    fi
    BES_WWW_FOLDER="$inLine"
    ##Validate input value
    BES_WWW_FOLDER=$(checkFolder "true" "BES_WWW_FOLDER" "$BES_WWW_FOLDER")
    if [[ $BES_WWW_FOLDER != "" ]]
    then
      break
    else
      writeMsg stdout "`nls_replace 'TEM0094W'`"
      writeMsg stdout "`nls_replace 'TEM0002E' \"$inLine\"`"
    fi
  done
fi
addResponseFileEntry "BES_WWW_FOLDER" "$BES_WWW_FOLDER"
logFnEnd "${FUNCNAME[0]}"
}

chooseWRWWWRoot()
{
logFnBegin "${FUNCNAME[0]}"
silentCheckNotNull "WR_WWW_FOLDER" "$WR_WWW_FOLDER"
checkFatalerror $?
if [[ $WR_WWW_FOLDER = "" ]]
then
  writeMsg stdout "$DEF_INPUT_SEPARATOR"
  while :
  do
    writeMsg stdout "`nls_replace 'WRWWWRootDesc'`"
    writeMsg stdout "`nls_replace 'WRWWWRootMsg' \"$DEF_WR_ROOT\"`"
    read -e inLine
    if [[ $inLine = "" ]]
    then
      inLine="$DEF_WR_ROOT"
    fi
    WR_WWW_FOLDER="$inLine"
    ##Validate input value
    WR_WWW_FOLDER=$(checkFolder "true" "WR_WWW_FOLDER" "$WR_WWW_FOLDER")
    if [[ $WR_WWW_FOLDER != "" ]]
    then
      break
    else
      writeMsg stdout "`nls_replace 'TEM0094W'`"
      writeMsg stdout "`nls_replace 'TEM0002E' \"$inLine\"`"
    fi
  done
fi
addResponseFileEntry "WR_WWW_FOLDER" "$WR_WWW_FOLDER"
logFnEnd "${FUNCNAME[0]}"
}

chooseDb2extractDir()
{
logFnBegin "${FUNCNAME[0]}"
silentCheckNotNull "DB2_EXTR_DIR" "$DB2_EXTR_DIR"
checkFatalerror $?
if [[ $DB2_EXTR_DIR = "" ]]
then
  writeMsg stdout "$DEF_INPUT_SEPARATOR"
  while :
  do
    writeMsg stdout "`nls_replace 'Db2ExtDirDesc'`"
    writeMsg stdout "`nls_replace 'Db2ExtDirMsg'`"
    read -e inLine
    DB2_EXTR_DIR=$(checkFolderAll "true" "DB2_EXTR_DIR" "$inLine")
    if [[ $DB2_EXTR_DIR != "" ]]
    then
      break
    else
      writeMsg stdout "`nls_replace 'TEM0002E' \"$inLine\"`"
    fi
  done
fi
addResponseFileEntry "DB2_EXTR_DIR" "$DB2_EXTR_DIR"
logFnEnd "${FUNCNAME[0]}"
}

prerequisitesOsWarning()
{
logFnBegin "${FUNCNAME[0]}"
silentCheckNotNull "IGNORE_WARNING" "$IGNORE_WARNING"
checkFatalerror $?
if [[ $IGNORE_WARNING = "" ]]
then
  opt1="[1]"
  opt2="[2]"
  writeMsg stdout "$DEF_INPUT_SEPARATOR"
  while :
  do
    writeMsg stdout "`nls_replace 'IgnorePrereqWrnDesc'`"
    writeMsg stdout "  - `nls_replace 'PrereqOSDistr' \"$PREREQ_OSRHEL_OK\"`"
    if [[ $PREREQ_OSRHEL_OK = "true" ]]
    then
      writeMsg stdout "  - `nls_replace 'PrereqOSVer' \"$PREREQ_OS_OK\"`"
      writeMsg stdout "  - `nls_replace 'PrereqStackSzLimit' \"$PREREQ_STACKSIZELIMIT_OK\"`"

      writeMsg stdout "`nls_replace 'PrereqStackSizeNote'`"
    fi
    writeMsg stdout "`nls_replace 'IgnorePrereqWrnMsg' $DEF_BES_LOG_FILE`"
    writeMsg stdout "$opt1  `nls_replace 'IgnorePrereqWrnYesOpt1'`"
    writeMsg stdout "$opt2  `nls_replace 'IgnorePrereqWrnNoOpt2'`"
    writeMsg stdout "`nls_replace 'ChooseOpts' \"$opt2\"`"
    read inLine
    if [[ $inLine = "1" ]]
    then
      IGNORE_WARNING=${ALLOWED_YES_NO[0]}
      break
    elif [[ $inLine = "2" || $inLine = "" ]]
    then
      IGNORE_WARNING=${ALLOWED_YES_NO[1]}
      break
    else
      writeMsg stdout "`nls_replace 'TEM0002E' \"$inLine\"`"
    fi
  done
fi
logFnEnd "${FUNCNAME[0]}"
}

getConfirmationPwd()
{
  logFnBegin "${FUNCNAME[0]}"
  pwd=$1
  fnRc=0
  writeMsg stdout "`nls_replace 'ConfirmationPwdDesc'`"
  stty -echo
  read inLine
  stty echo
  writeMsg stdout ""
  if [[ $inLine != $pwd ]]
  then
    fnRc=1
    writeMsg stdout "`nls_replace 'TEM0038E'`"
  fi
  logFnEnd "${FUNCNAME[0]}"
  return $fnRc
}

chooseWebUISrcCertFolder()
{
logFnBegin "${FUNCNAME[0]}"
silentCheckNotNull "WEBUI_SRC_CERT_FOLDER" "$WEBUI_SRC_CERT_FOLDER"
checkFatalerror $?
if [[ $WEBUI_SRC_CERT_FOLDER = "" ]]
then
  writeMsg stdout "$DEF_INPUT_SEPARATOR"
  while :
  do
    writeMsg stdout "`nls_replace 'WebUICredFolderDesc'`"
    writeMsg stdout "`nls_replace 'WebUICredFolderMsg' \"$DEF_WEBUI_SRC_CERT_FOLDER\"`"
    read -e inLine
    if [[ $inLine = "" ]]
    then
      inLine="$DEF_WEBUI_SRC_CERT_FOLDER"
    fi
    WEBUI_SRC_CERT_FOLDER="$inLine"

    ##Validate input value
    WEBUI_SRC_CERT_FOLDER=$(folderExists $WEBUI_SRC_CERT_FOLDER)
    if [[ $? -eq 0 ]]
    then
      if [[ -f "$WEBUI_SRC_CERT_FOLDER/ca.crt" ]] && [[ -f "$WEBUI_SRC_CERT_FOLDER/auth_cert.crt" ]] && [[ -f "$WEBUI_SRC_CERT_FOLDER/auth_key.key" ]]
      then
        break
      else
        writeMsg stdout "`nls_replace 'TEM0177W'`"
        writeMsg stdout "`nls_replace 'TEM0002E' \"$inLine\"`"
      fi
    else
      writeMsg stdout "`nls_replace 'TEM0176W'`"
      writeMsg stdout "`nls_replace 'TEM0002E' \"$inLine\"`"
    fi
  done
fi
addResponseFileEntry "WEBUI_SRC_CERT_FOLDER" "$WEBUI_SRC_CERT_FOLDER"
logFnEnd "${FUNCNAME[0]}"
}

chooseLicFolder()
{
logFnBegin "${FUNCNAME[0]}"
silentCheckNotNull "BES_LIC_FOLDER" "$BES_LIC_FOLDER"
checkFatalerror $?
if [[ $BES_LIC_FOLDER = "" ]]
then
  licFolderMsg='BesLicFolderMsg'
  [[ $BES_SETUP_TYPE = "prodlic" ]] && licFolderMsg='BesLicFolderProdMsg'
  writeMsg stdout "$DEF_INPUT_SEPARATOR"
  while :
  do
    writeMsg stdout "`nls_replace 'BesLicFolderDesc'`"
    writeMsg stdout "`nls_replace $licFolderMsg \"$DEF_BES_LIC_FOLDER\"`"
    read -e inLine
    if [[ $inLine = "" ]]
    then
      inLine="$DEF_BES_LIC_FOLDER"
    fi
    BES_LIC_FOLDER="$inLine"
    ##Validate input value
    BES_LIC_FOLDER=$(checkFolder "true" "BES_LIC_FOLDER" "$BES_LIC_FOLDER")
    if [[ $BES_LIC_FOLDER != "" ]]
    then
      break
    else
      writeMsg stdout "`nls_replace 'TEM0094W'`"
      writeMsg stdout "`nls_replace 'TEM0002E' \"$inLine\"`"
    fi
  done
fi
addResponseFileEntry "BES_LIC_FOLDER" "$BES_LIC_FOLDER"
logFnEnd "${FUNCNAME[0]}"
}

submitInternetLicReq()
{
logFnBegin "${FUNCNAME[0]}"
silentCheckNotNull "SUBMIT_LIC_REQUEST" "$SUBMIT_LIC_REQUEST"
checkFatalerror $?
if [[ $SUBMIT_LIC_REQUEST = "" ]]
then
  opt1="[1]"
  opt2="[2]"
  writeMsg stdout "$DEF_INPUT_SEPARATOR"
  while :
  do
    writeMsg stdout "`nls_replace 'SubmitInternetLicReqDesc'`"
    writeMsg stdout "`nls_replace 'SubmitInternetLicReqMsg'`"
    writeMsg stdout "$opt1  `nls_replace 'SubmitInternetLicReqYesOpt1'`"
    writeMsg stdout "$opt2  `nls_replace 'SubmitInterentLicReqNoOpt2' \"$DEF_LIC_REQUEST_URL\"`"
    writeMsg stdout "`nls_replace 'ChooseOpts' \"$opt1\"`"
    read inLine
    if [[ $inLine = "1" || $inLine = "" ]]
    then
      SUBMIT_LIC_REQUEST=${ALLOWED_YES_NO[0]}
      break
    elif [[ $inLine = "2" ]]
    then
      SUBMIT_LIC_REQUEST=${ALLOWED_YES_NO[1]}
      break
    else
      writeMsg stdout "`nls_replace 'TEM0002E' \"$inLine\"`"
    fi
  done
fi
addResponseFileEntry "SUBMIT_LIC_REQUEST" "$SUBMIT_LIC_REQUEST"
logFnEnd "${FUNCNAME[0]}"
}

promptForDb2User()
{
  logFnBegin "${FUNCNAME[0]}"
  key_name=$1
  key_value=$2
  key_default=$3
  keyDesc=$4
  keyMsg=$5
  if [[ $key_value = "" ]]
  then
    writeMsg stdout "$DEF_INPUT_SEPARATOR"
    while :
    do
      writeMsg stdout "`nls_replace $keyDesc`"
      writeMsg stdout "`nls_replace $keyMsg \"$key_default\"`"
      read inLine
      if [[ $inLine = "" && $key_default = "" ]]
      then
        writeMsg stdout "`nls_replace 'TEM0004E'`"
      else
        [ $inLine ] || inLine=$key_default
        key_value=$(checkUserExists "true" "$key_name" "$inLine")
        [ $key_value ] || writeMsg stdout "`nls_replace 'TEM0095W'`"
      fi
      if [[ $key_value != "" ]]
      then
        key_value=$(checkDb2LibPath "true" "$key_name" "$inLine")
      fi
      if [[ $key_value != "" ]]
      then
        break
      else
        [[ $inLine = "" ]] || writeMsg stdout "`nls_replace 'TEM0002E' \"$inLine\"`"
      fi
    done
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo "$key_value"
}

promptForNumber()
{
  logFnBegin "${FUNCNAME[0]}"
  key_name=$1
  key_value=$2
  key_default=$3
  keyDesc=$4
  keyMsg=$5
  if [[ $key_value = "" ]]
  then
    writeMsg stdout "$DEF_INPUT_SEPARATOR"
    while :
    do
      writeMsg stdout "`nls_replace $keyDesc`"
      # Certain messages have nothing to replace, but this still works
      writeMsg stdout "`nls_replace $keyMsg \"$key_default\"`"
      read inLine
      if [[ $inLine = "" ]]
      then
        inLine="$key_default"
      fi
      key_value=$(checkNumber "true" "$key_name" "$inLine")
      if [[ $key_value != "" ]]
      then
        break
      else
        writeMsg stdout "`nls_replace 'TEM0090W'`"
        writeMsg stdout "`nls_replace 'TEM0002E' \"$inLine\"`"
      fi
    done
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo "$key_value"
}

promptForOptionalNumber()
{
  logFnBegin "${FUNCNAME[0]}"
  key_name=$1
  key_value=$2
  keyDesc=$3
  keyMsg=$4
  if [[ $key_value = "" ]]
  then
    writeMsg stdout "$DEF_INPUT_SEPARATOR"
    while :
    do
      writeMsg stdout "`nls_replace $keyDesc`"
      writeMsg stdout "`nls_replace $keyMsg`"
      read inLine
      if [[ $inLine != "" ]]
      then
        key_value=$(checkNumber "true" "$key_name" "$inLine")
        if [[ $key_value != "" ]]
        then
          break
        else
          writeMsg stdout "`nls_replace 'TEM0090W'`"
          writeMsg stdout "`nls_replace 'TEM0002E' \"$inLine\"`"
        fi
      else
        break
      fi
    done
  fi
  if [[ $key_value = "0" ]]
  then
    key_value=""
  fi  
  logFnEnd "${FUNCNAME[0]}"
  echo "$key_value"
}

promptForFile()
{
  logFnBegin "${FUNCNAME[0]}"
  key_name=$1
  key_value=$2
  key_default=$3
  key_path=$4
  key_path_default=$5
  keyDesc=$6
  keyMsg=$7
  if [[ $key_value = "" ]]
  then
    writeMsg stdout "$DEF_INPUT_SEPARATOR"
    defaultPath=$key_path_default
    if [[ $key_path != "" ]]
    then
      defaultPath=$key_path
    fi
    while :
    do
      writeMsg stdout "`nls_replace $keyDesc`"
      writeMsg stdout "`nls_replace $keyMsg \"$defaultPath$key_default\"`"
      read -e inLine
      if [[ $inLine = "" ]]
      then
        inLine="$defaultPath$key_default"
      fi
      key_value=$(checkFile "true" "$key_name" "$inLine")
      if [[ $key_value != "" ]]
      then
        break
      else
        writeMsg stdout "`nls_replace 'TEM0091W'`"
        writeMsg stdout "`nls_replace 'TEM0002E' \"$inLine\"`"
      fi
    done
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo "$key_value"
}

promptForChoice()
{
  logFnBegin "${FUNCNAME[0]}"
  key_value=$1
  key_allowed_value=($2)
  key_opt_str=$3
  key_def_index=$4
  keyHeader=$5
  if [[ $key_value = "" ]]
  then
    writeMsg stdout "$DEF_INPUT_SEPARATOR"
    while :
    do
      for head in ${keyHeader[*]}
      do
        if [[ $head != "_" ]]
        then
          echo $head|while IFS=':' read headKey headVal1 headVal2
          do
            if [[ $headKey = t_* ]]
            then
              headKey=${headKey#*_}
              writeMsg stdout $'\t'"`nls_replace $headKey $headVal1 $headVal2`"
            else
              writeMsg stdout "`nls_replace $headKey $headVal1 $headVal2`"
            fi
          done
        fi
      done
      opt=()
      i=1
      for str in ${key_opt_str[*]}
      do
        opt[$i]="[$i]"
        if [[ "${str:0:1}" != "#" ]] ; then
          writeMsg stdout "$opt[$i]  `nls_replace $str`"
        else
          writeMsg stdout "$(echo $opt[$i]  $str | tr "#" " " | tr "_" " " )"
        fi
        let i=i+1
      done
      if [[ "$key_def_index" = "" ]]
      then
        writeMsg stdout "`nls_replace 'ChooseOptsNoDefault'`"
      else
        writeMsg stdout "`nls_replace 'ChooseOpts' \"$opt[$key_def_index]\"`"
      fi
      read inLine
      if [[ $inLine = "" ]]
      then
        if [[ "$key_def_index" = "" ]]
        then
          writeMsg stdout "`nls_replace 'TEM0151E'`"
          continue
        else
          inLine="$key_def_index"
        fi
      fi
      let index=inLine-1
      if [[ $index -ge 0 &&  $index -lt ${#key_allowed_value[*]} ]]
      then
        key_value=${key_allowed_value[$index]}
        break
      else
        writeMsg stdout "`nls_replace 'TEM0002E' \"$inLine\"`"
      fi
    done
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo "$key_value"
}

promptOptionalStringWithAllowedValue()
{
  logFnBegin "${FUNCNAME[0]}"
  key_value=$1
  key_allowed_value=($2)
  keyHeader=$3
  keyMsg=$4
  keyDefault=$5
  if [[ $key_value = "" ]]
  then
    writeMsg stdout "$DEF_INPUT_SEPARATOR"
    while :
    do
      for head in ${keyHeader[*]}
      do
        echo $head|while IFS=':' read headKey headVal
        do
          if [[ $headKey = t_* ]]
          then
            headKey=${headKey#*_}
            writeMsg stdout $'\t'"`nls_replace $headKey $headVal`"
          else
            writeMsg stdout "`nls_replace $headKey $headVal`"
          fi
        done
      done
      for str in ${key_allowed_value[*]}
      do
        writeMsg stdout $'\t'$str
      done
      writeMsg stdout "`nls_replace $keyMsg`"
      read -r inLine
      if [[ $inLine = "" && $keyDefault != "" ]]
      then
        key_value="$keyDefault"
        break
      else
        key_value=$inLine
        break
      fi
    done
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo "$key_value"
}

promptForSpecialString()
{
  logFnBegin "${FUNCNAME[0]}"
  key_value=$1
  key_default=$2
  keyDesc=$3
  keyMsg=$4
  keyType=$5
  if [[ $key_value = "" ]]
  then
    writeMsg stdout "$DEF_INPUT_SEPARATOR"
    while :
    do
      writeMsg stdout "`nls_replace $keyDesc`"
      writeMsg stdout "`nls_replace $keyMsg \"$key_default\"`"
      read inLine
      if [[ $inLine = "" ]]
      then
        inLine="$key_default"
      fi

      if [[ $keyType = "mail" ]]
      then
        key_value=$(checkMailAddress "true" "" "$inLine")
      elif [[ $keyType = "url" ]]
      then
        key_value=$(checkHttpUrl "true" "" "$inLine")
      elif [[ $keyType = "encoding" ]]
      then
        key_value=$(checkEncoding "true" "" "$inLine")
      fi

      if [[ $key_value != "" ]]
      then
        break
      else
        writeMsg stdout "`nls_replace 'TEM0003E' \"$inLine\"`"
      fi
    done
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo "$key_value"
}

promptForString()
{
  logFnBegin "${FUNCNAME[0]}"
  key_value=$1
  key_default=$2
  keyDesc=$3
  keyMsg=$4
  if [[ $key_value = "" ]]
  then
    writeMsg stdout "$DEF_INPUT_SEPARATOR"
    while :
    do
      writeMsg stdout "`nls_replace $keyDesc`"
      writeMsg stdout "`nls_replace $keyMsg \"$key_default\"`"
      read inLine
      if [[ $inLine = "" && $key_default = "" ]]
      then
        writeMsg stdout "`nls_replace 'TEM0004E'`"
      elif [[ $inLine = "" && $key_default != "" ]]
      then
        key_value="$key_default"
        break
      else
        key_value=$inLine
        break
      fi
    done
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo "$key_value"
}

promptForOptionalString()
{
  logFnBegin "${FUNCNAME[0]}"
  key_value=$1
  keyDesc=$2
  keyMsg=$3
  if [[ $key_value = "" ]]
  then
    writeMsg stdout "$DEF_INPUT_SEPARATOR"
    while :
    do
      writeMsg stdout "`nls_replace $keyDesc`"
      for str in ${keyMsg[*]}
      do
        writeMsg stdout "`nls_replace $str`"
      done
      read -r inLine
      key_value=$inLine
      break
    done
  fi
  if [[ $key_value = "none" ]]
  then
    key_value=""
  fi
  logFnEnd "${FUNCNAME[0]}"
  echo "$key_value"
}

promptForPassword()
{
  logFnBegin "${FUNCNAME[0]}"
  key_name=$1
  key_value=$2
  keyDesc=$3
  keyMsg=$4
  obfuscate=$5
  checkPolicy=$6
  obfPwdOut=$7
  pwdSHA256=$8
  if [[ $key_value = "" ]]
  then
    writeMsg stdout "$DEF_INPUT_SEPARATOR"
    while :
    do
      writeMsg stdout "`nls_replace $keyDesc`"
      writeMsg stdout "`nls_replace $keyMsg`"
      stty -echo
      read inLine
      stty echo
      writeMsg stdout ""
      if [[ $checkPolicy = "true" ]]; then
        matchPolicy=$(runCheckPasswordPolicy "$inLine")
        if [[ $matchPolicy = "yes" ]]; then
          key_value=$inLine
        fi
      else
        key_value=$(checkPassword "true" "$key_name" "$inLine")
      fi
      if [[ $key_value != "" ]]
      then
        getConfirmationPwd "$key_value"
        lastrc=$?
        if [[ $lastrc -eq 0 ]]
        then
          break
        fi
      else
        if [[ $checkPolicy = "true" ]]; then
          writeMsg stdout "`nls_replace 'TEM0162E'`"
        else
          writeMsg stdout "`nls_replace 'TEM0006E'`"
        fi
      fi
    done
  fi
  if [[ "$pwdSHA256" != "" ]]; then
    eval $pwdSHA256="'$(echo -n $key_value | sha256sum | awk '{print $1}')'"
  fi
  [[ $obfuscate = "false" ]] || key_value=$( runObfuscatePassword "$key_value" )
  logFnEnd "${FUNCNAME[0]}"
  if [[ "$obfPwdOut" != "" ]]; then
    eval $obfPwdOut="'$key_value'"
  else
    echo "$key_value"
  fi
}

specifyDBAdminPwd()
{
  logFnBegin "${FUNCNAME[0]}"
  varname=${VAR_DB_TAG}_ADMIN_PWD
  DB_ADMIN_PWD=${!varname}
  silentCheckNotNull "$varname" "$DB_ADMIN_PWD"
  checkFatalerror $?
  promptForPassword "$varname" "$DB_ADMIN_PWD" "${PROP_DB_TAG}AdminPwdDesc" "${PROP_DB_TAG}AdminPwdMsg" "true" "false" obfPwdOut pwdSHA256
  DB_ADMIN_PWD=$obfPwdOut
  DB_REPLICA_PWD_SHA256=$pwdSHA256
  addResponseFileEntry "$varname" ""
  logFnEnd "${FUNCNAME[0]}"
}

specifyDbRemotePwd()
{
  logFnBegin "${FUNCNAME[0]}"
  varname=${VAR_DB_TAG}_CONN_PWD
  DB_CONN_PWD=${!varname}
  silentCheckNotNull "$varname" "$DB_CONN_PWD"
  checkFatalerror $?
  if [[ $COMPONENT_WR = "true" && $COMPONENT_SRV = "false" ]]
  then
    promptForPassword "$varname" "$DB_CONN_PWD" "${PROP_DB_TAG}RemotePwdDescWr" "${PROP_DB_TAG}RemotePwdMsg" "true" "false" obfPwdOut pwdSHA256
   else
    promptForPassword "$varname" "$DB_CONN_PWD" "${PROP_DB_TAG}RemotePwdDesc" "${PROP_DB_TAG}RemotePwdMsg" "true" "false" obfPwdOut pwdSHA256
  fi
  DB_CONN_PWD=$obfPwdOut
  DB_REPLICA_PWD_SHA256=$pwdSHA256
  addResponseFileEntry "$varname" ""
  logFnEnd "${FUNCNAME[0]}"
}

specifyMasterDB2Pwd()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "DB2_MASTER_PWD" "$DB2_MASTER_PWD"
  checkFatalerror $?
  promptForPassword "DB2_MASTER_PWD" "$DB2_MASTER_PWD" 'MasterDb2PwdDesc' 'MasterDb2PwdMsg' "true" "false" obfPwdOut pwdSHA256
  DB2_MASTER_PWD=$obfPwdOut
  DB2_MASTER_PWD_SHA256=$pwdSHA256
  addResponseFileEntry "DB2_MASTER_PWD" ""
  logFnEnd "${FUNCNAME[0]}"
}

runCheckPasswordPolicy()
{
  logFnBegin "${FUNCNAME[0]}"
  pswd=$1
  adminTool="$DEF_BES_REPOS_FOLDER/BESAdmin"
  BES_LIBPATH=$DEF_BES_REPOS_FOLDER
  export BES_LIBPATH
  writeMsg log "export BES_LIBPATH=$BES_LIBPATH"
  runCmd="$adminTool -checkpasswordpolicy -password:$pswd"
  checkPassed=$($runCmd)
  logFnEnd "${FUNCNAME[0]}"
  echo $checkPassed
}

silentCheckMatchPolicy()
{
  logFnBegin "${FUNCNAME[0]}"
  key_name=$1
  key_value=$2
  fnRc=0
  if [[ "$key_value" != "" && "$BES_UPGRADE" != "true" ]]; then
    matchPolicy=$(runCheckPasswordPolicy "$key_value")
    if [[ $matchPolicy = "no" ]]; then
      writeMsg both "`nls_replace 'TEM0165E' \"$key_name\"`"
      fnRc=1
    fi
  fi
  logFnEnd "${FUNCNAME[0]}"
  return $fnRc
}

chooseAdminUserPwd()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "TEM_USER_PWD" "$TEM_USER_PWD"
  checkFatalerror $?
  silentCheckMatchPolicy "TEM_USER_PWD" "$TEM_USER_PWD"
  checkFatalerror $?
  admUserPwdDesc='AdminUserPwdDesc'
  [[ $COMPONENT_SRV = "true" && $SINGLE_DATABASE = "true" ]] || admUserPwdDesc='AdminUserWRPwdDesc'
  checkPolicy="true"
  if [[ $BES_UPGRADE = "true" ]]; then
    checkPolicy="false"
  fi
  TEM_USER_PWD=$(promptForPassword "TEM_USER_PWD" "$TEM_USER_PWD" $admUserPwdDesc 'AdminUserPwdMsg' "true" "$checkPolicy")
  addResponseFileEntry "TEM_USER_PWD" ""
  logFnEnd "${FUNCNAME[0]}"
}

getSigningKeyPwd()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "BES_LICENSE_PVK_PWD" "$BES_LICENSE_PVK_PWD"
  checkFatalerror $?
  BES_LICENSE_PVK_PWD=$(promptForPassword "BES_LICENSE_PVK_PWD" "$BES_LICENSE_PVK_PWD" 'SigningKeyPwdDesc' 'SigningKeyPwdMsg')
  addResponseFileEntry "BES_LICENSE_PVK_PWD" ""
  logFnEnd "${FUNCNAME[0]}"
}

specifyCommonPwd()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "DB2_ADMIN_PWD" "$DB_ADMIN_PWD"
  checkFatalerror $?
  DB_ADMIN_PWD=$(promptForPassword "DB2_ADMIN_PWD" "$DB_ADMIN_PWD" 'CommonPwdDesc' 'CommonPwdMsg')
  BES_LICENSE_PVK_PWD=$DB_ADMIN_PWD
  TEM_USER_PWD=$DB_ADMIN_PWD
  DB_CONN_PWD=$DB_ADMIN_PWD
  addResponseFileEntry "DB2_ADMIN_PWD" ""
  logFnEnd "${FUNCNAME[0]}"
}

specifyWebUIDbPwd()
{
  logFnBegin "${FUNCNAME[0]}"
  varname=${VAR_DB_TAG}_WEBUI_PWD
  DB_WEBUI_PWD=${!varname}
  silentCheckNotNull "$varname" "$DB_WEBUI_PWD"
  checkFatalerror $?
  DB_WEBUI_PWD=$(promptForPassword "$varname" "$DB_WEBUI_PWD" "WebUI${PROP_DB_TAG}PwdDesc" "WebUI${PROP_DB_TAG}PwdMsg")
  addResponseFileEntry "$varname" ""
  logFnEnd "${FUNCNAME[0]}"
}

specifyWebUIDbHostname()
{
  logFnBegin "${FUNCNAME[0]}"
  varname=${VAR_DB_TAG}_WEBUI_HOSTNAME
  DB_WEBUI_HOSTNAME=${!varname}
  silentCheckNotNull "$varname" "$DB_WEBUI_HOSTNAME"
  checkFatalerror $?
  DB_WEBUI_HOSTNAME=$(promptForString "$DB_WEBUI_HOSTNAME" "" "${PROP_DB_TAG}WebUIHostnameDesc" "${PROP_DB_TAG}WebUIHostnameMsg")
  addResponseFileEntry "$varname" "$DB_WEBUI_HOSTNAME"
  logFnEnd "${FUNCNAME[0]}"
}

specifyWebUIDbAdminUser()
{
  logFnBegin "${FUNCNAME[0]}"
  varname=${VAR_DB_TAG}_WEBUI_ADMIN_USER
  DB_WEBUI_ADMIN_USER=${!varname}
  silentCheckNotNull "$varname" "$DB_WEBUI_ADMIN_USER"
  checkFatalerror $?
  DB_WEBUI_ADMIN_USER=$(promptForString "$DB_WEBUI_ADMIN_USER" "$DEF_DB_ADMIN_USER" "${PROP_DB_TAG}WebUIUserDesc" "${PROP_DB_TAG}WebUIUserMsg")
  addResponseFileEntry "$varname" "$DB_WEBUI_ADMIN_USER"
  logFnEnd "${FUNCNAME[0]}"
}

specifyWebUIDbPort()
{
  logFnBegin "${FUNCNAME[0]}"
  varname=${VAR_DB_TAG}_WEBUI_PORT
  DB_WEBUI_PORT=${!varname}
  silentCheckNotNull "$varname" "$DB_WEBUI_PORT"
  checkFatalerror $?
  DB_WEBUI_PORT=$(promptForNumber "$varname" "$DB_WEBUI_PORT" "$DEF_DB_PORT" "${PROP_DB_TAG}WebUIPortDesc" "${PROP_DB_TAG}WebUIPortMsg")
  addResponseFileEntry "$varname" "$DB_WEBUI_PORT"
  logFnEnd "${FUNCNAME[0]}"
}

specifyDB2Pwd()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "DB2_USERS_PWD" "$DB2_USERS_PWD"
  checkFatalerror $?
  db2PwdMsg='InstDb2PwdMsg'
  [[ $IS_EVALUATION = "true" ]] && db2PwdMsg='InstDb2CmnPwdMsg'
  DB2_USERS_PWD=$(promptForPassword "DB2_USERS_PWD" "$DB2_USERS_PWD" 'CommonPwdDesc' $db2PwdMsg "false")
  DB_REPLICA_PWD_SHA256=$(echo -n $DB2_USERS_PWD | sha256sum | awk '{print $1}')
  addResponseFileEntry "DB2_USERS_PWD" ""
  logFnEnd "${FUNCNAME[0]}"
}

specifyProxyPwd()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "PROXY_PWD" "$PROXY_PWD"
  checkFatalerror $?
  PROXY_PWD=$(promptForPassword "PROXY_PWD" "$PROXY_PWD" 'ProxyPwdDesc' 'ProxyPwdMsg')
  addResponseFileEntry "PROXY_PWD" ""
  logFnEnd "${FUNCNAME[0]}"
}

specifyProxySecureTunnel()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "PROXY_SECTUNNEL" "$PROXY_SECTUNNEL"
  checkFatalerror $?
  proxySecTunnelSizeOpt=('ProxySecTunnelOpt1' 'ProxySecTunnelOpt2')
  proxySecTunnelSizeHeader=('ProxySecTunnelDesc' 'ProxySecTunnelMsg')
  PROXY_SECTUNNEL=$(promptForChoice "$PROXY_SECTUNNEL" "${ALLOWED_BOOLEAN[*]}" "${proxySecTunnelSizeOpt[*]}" "2" "${proxySecTunnelSizeHeader[*]}")
  addResponseFileEntry "PROXY_SECTUNNEL" "$PROXY_SECTUNNEL"
  logFnEnd "${FUNCNAME[0]}"
}

specifyProxyMeth()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "PROXY_METH" "$PROXY_METH"
  checkFatalerror $?
  proxyAuthMetHeader=('ProxyAuthMetDesc' 'ProxyAuthMetAllowedMsg' 'ProxyAuthMetAllowedFIPS')
  PROXY_METH=$(promptOptionalStringWithAllowedValue "$PROXY_METH" "${ALLOWED_PROXYMTH[*]}" "${proxyAuthMetHeader[*]}" 'ProxyAuthMetMsg' "$DEF_PROXY_METH")
  addResponseFileEntry "PROXY_METH" "$PROXY_METH"
  logFnEnd "${FUNCNAME[0]}"
}

specifyProxyExceptionList()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "PROXY_EXLIST" "$PROXY_EXLIST"
  ProxyExlistHeader=('ProxyExlistNote' 'ProxyExlistMsg')
  checkFatalerror $?
  PROXY_EXLIST=$(promptForOptionalString "$PROXY_EXLIST" 'ProxyExlistDesc' "${ProxyExlistHeader[*]}")
  if [[ $PROXY_EXLIST = "" ]]
  then
    addResponseFileEntry "PROXY_EXLIST" "none"
  else
    addResponseFileEntry "PROXY_EXLIST" "$PROXY_EXLIST"
  fi
  logFnEnd "${FUNCNAME[0]}"
}

specifyProxyDownStreamNot()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "PROXY_DOWN" "$PROXY_DOWN"
  checkFatalerror $?
  proxyDownOpt=('ProxyForDownNotOpt1' 'ProxyForDownNotOpt2')
  proxyDownHeader=('ProxyForDownNotDesc' 'ProxyForDownNotMsg')
  PROXY_DOWN=$(promptForChoice "$PROXY_DOWN" "${ALLOWED_BOOLEAN[*]}" "${proxyDownOpt[*]}" "2" "${proxyDownHeader[*]}")
  addResponseFileEntry "PROXY_DOWN" "$PROXY_DOWN"
  logFnEnd "${FUNCNAME[0]}"
}

chooseAdvProxyDefault()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "ADV_PROXY_DEFAULT" "$ADV_PROXY_DEFAULT"
  checkFatalerror $?
  advProxyUseDefOpt=('advProxySetUseDefTrueOpt1' 'advProxySetUseDefFalseOpt2')
  advProxyUseDefHeader=('advProxySetUseDefDesc' 'advProxySetUseDefMsg' 't_advProxySetUseDefParmUser' 't_advProxySetUseDefParmPwd' 't_advProxySetUseDefParmSecTunnel' 't_advProxySetUseDefParmAuthMet' 't_advProxySetUseDefParmExList' 't_advProxySetUseDefParmDown')
  ADV_PROXY_DEFAULT=$(promptForChoice "$ADV_PROXY_DEFAULT" "${ALLOWED_BOOLEAN[*]}" "${advProxyUseDefOpt[*]}" "1" "${advProxyUseDefHeader[*]}")
  addResponseFileEntry "ADV_PROXY_DEFAULT" "$ADV_PROXY_DEFAULT"
  logFnEnd "${FUNCNAME[0]}"
}

chooseTestProxy()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "TEST_PROXY" "$TEST_PROXY"
  checkFatalerror $?
  testProxyOpt=('TestProxyNoFipsOpt' 'TestProxyFipsOpt' 'TestProxyNoOpt')
  TestProxyHeader=('TestProxyDesc' 'TestProxyMsg' 'TestProxyFIPS')
  TEST_PROXY=$(promptForChoice "$TEST_PROXY" "${ALLOWED_TEST_PROXY[*]}" "${testProxyOpt[*]}" "1" "${TestProxyHeader[*]}")
  addResponseFileEntry "TEST_PROXY" "$TEST_PROXY"
  logFnEnd "${FUNCNAME[0]}"
}

chooseAgainProxyInput()
{
  logFnBegin "${FUNCNAME[0]}"
  againProxyInputOpt=('ProxyInputAgainYesOpt' 'ProxyInputAgainNoOpt' )
  REINPUT_PROXY=$(promptForChoice "$REINPUT_PROXY" "${ALLOWED_YES_NO[*]}" "${againProxyInputOpt[*]}" "1" 'ProxyInputAgainDesc')
  logFnEnd "${FUNCNAME[0]}"
}

loadLanguageMaps()
{
  logFnBegin "${FUNCNAME[0]}"
  mapFile="$instRoot/repos/encoding.map"
  supportedLanguages=$(cat $mapFile | grep "##")
  supportedLanguages=$(echo $supportedLanguages | tr " " "_")
  supportedEncodings=$(cat $mapFile | grep -v "##" | cut -d "=" -f2 | uniq | tr " " "_" )
  index=1

  while IFS='##' read -ra languageTitles; do
      for LINE in "${languageTitles[@]}"; do
          if [[ "$LINE" != "" ]] ; then
              LANGUAGES_MAP[index]="$(echo $LINE | tr "_" " ")"
              let index++
          fi
      done
  done <<< "$supportedLanguages"

  index=1

  while IFS='_' read -ra encodingTitles; do
      for LINE in "${encodingTitles[@]}"; do
          if [[ "$LINE" != "" ]] ; then
              ENCODINGS_MAP[index]=$(echo $LINE)
              let index++
          fi
      done
  done <<< "$supportedEncodings"
  logFnEnd "${FUNCNAME[0]}"
}

specifyEncoding()
{
  logFnBegin "${FUNCNAME[0]}"
  setServerEncoding
  silentCheckNotNull "ENCODE_VALUE" "$ENCODE_VALUE"
  checkFatalerror $?
  if [[ $ENCODE_VALUE = "" ]]
  then
      loadLanguageMaps
      defaultChoice=""

      start=1
      end=${#LANGUAGES_MAP[@]}
      index=$start

      while [[ "$index" -le "$end" ]]
      do
        entry=$(nls_replace ${LANGUAGES_MAP[$index]})

        if [[ $index -lt "10" ]] ; then
          leftPadding=$(head -c 1 < /dev/zero | tr '\0' " ")
        else
          leftPadding=""
        fi

        let paddingLength=50-${#entry}
        padding=$(head -c $paddingLength < /dev/zero | tr '\0' " ")

        encoding=${ENCODINGS_MAP[$index]}
        if [[ "$ENC_VALUE" -eq "$encoding" ]]; then
          defaultChoice=$index
        fi
        languageEntries[$index]=$(echo "#$leftPadding$entry$padding - [$encoding]" | tr " " "_")
        let index++
      done

      range="($(seq 1 $end))"

      languageChoice=$(promptForChoice "$languageChoice" "$range" "${languageEntries[*]}" "$defaultChoice" 'EncodingDesc')
      languageChoice=$(echo $languageChoice | tr -d "()")

      ENCODE_VALUE=${ENCODINGS_MAP[$languageChoice]}
  fi
  addResponseFileEntry "ENCODE_VALUE" "$ENCODE_VALUE"
  logFnEnd "${FUNCNAME[0]}"
}

specifyDbHostname()
{
  logFnBegin "${FUNCNAME[0]}"
  varname=${VAR_DB_TAG}_HOSTNAME
  DB_HOSTNAME=${!varname}
  silentCheckNotNull "$varname" "$DB_HOSTNAME"
  checkFatalerror $?
  if [[ $COMPONENT_WR = "true" && $COMPONENT_SRV = "false" ]]
  then
    DB_HOSTNAME=$(promptForString "$DB_HOSTNAME" "" "${PROP_DB_TAG}HostnameDescWr" "${PROP_DB_TAG}HostnameMsg")
  else
    DB_HOSTNAME=$(promptForString "$DB_HOSTNAME" "" "${PROP_DB_TAG}HostnameDesc" "${PROP_DB_TAG}HostnameMsg")
  fi
  addResponseFileEntry "$varname" "$DB_HOSTNAME"
  logFnEnd "${FUNCNAME[0]}"
}

specifyProxyHost()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "PROXY_HOST" "$PROXY_HOST"
  checkFatalerror $?
  PROXY_HOST=$(promptForString "$PROXY_HOST" "" 'ProxyHostDesc' 'ProxyHostMsg')
  addResponseFileEntry "PROXY_HOST" "$PROXY_HOST"
  logFnEnd "${FUNCNAME[0]}"
}

specifyDB2Instance()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "DB2_INSTANCE_NAME" "$DB2_INSTANCE_NAME"
  checkFatalerror $?
  DB2_INSTANCE_NAME=$(promptForString "$DB2_INSTANCE_NAME" "$DEF_DB_ADMIN_USER" 'Db2InstanceDesc' 'Db2InstanceMsg')
  DB2INSTANCE=$DB2_INSTANCE_NAME
  export DB2INSTANCE
  writeMsg log "export DB2INSTANCE=$DB2INSTANCE"
  addResponseFileEntry "DB2_INSTANCE_NAME" "$DB2_INSTANCE_NAME"
  logFnEnd "${FUNCNAME[0]}"
}

specifyDBAdminUser()
{
  logFnBegin "${FUNCNAME[0]}"
  varname=${VAR_DB_TAG}_ADMIN_USER
  DB_ADMIN_USER=${!varname}
  silentCheckNotNull "$varname" "$DB_ADMIN_USER"
  checkFatalerror $?
  dbUserMsg="${PROP_DB_TAG}AdminUserMsg"
  if [[ $DB_TARGET = "db2" ]]
  then
    [[ $LOCAL_DATABASE = "true" ]] || dbUserMsg='Db2AdminUserRemMsg'
    DB_ADMIN_USER=$(promptForDb2User "$varname" "$DB_ADMIN_USER" "$DB2_INSTANCE_NAME" "${PROP_DB_TAG}AdminUserDesc" $dbUserMsg)
  else
    DB_ADMIN_USER=$(promptForString "$DB_ADMIN_USER" "$DEF_DB_ADMIN_USER" "${PROP_DB_TAG}AdminUserDesc" $dbUserMsg)
  fi
  addResponseFileEntry "$varname" "$DB_ADMIN_USER"
  logFnEnd "${FUNCNAME[0]}"
}

specifyMasterDB2User()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "DB2_MASTER_USER" "$DB2_MASTER_USER"
  checkFatalerror $?
  DB2_MASTER_USER=$(promptForString "$DB2_MASTER_USER" "$DB_CONN_USER" 'MasterDb2UserDesc' 'MasterDb2UserMsg')
  addResponseFileEntry "DB2_MASTER_USER" "$DB2_MASTER_USER"
  logFnEnd "${FUNCNAME[0]}"
}

specifyDbRemoteUser()
{
  logFnBegin "${FUNCNAME[0]}"
  varname=${VAR_DB_TAG}_CONN_USER
  DB_CONN_USER=${!varname}
  silentCheckNotNull "$varname" "$DB_CONN_USER"
  checkFatalerror $?
  default="$DEF_DB_CONN_USER"
  # We want to override the DB2 connection user with the same value of the local DB2 admin user if it is not supplied
  [[ $DB_ADMIN_USER = "" ]] || default="$DB_ADMIN_USER"
  if [[ $COMPONENT_WR = "true" && $COMPONENT_SRV = "false" ]]
  then
     DB_CONN_USER=$(promptForString "$DB_CONN_USER" "$default" "${PROP_DB_TAG}RemoteUserDescWr" "${PROP_DB_TAG}RemoteUserMsg")
   else
     DB_CONN_USER=$(promptForString "$DB_CONN_USER" "$default" "${PROP_DB_TAG}RemoteUserDesc" "${PROP_DB_TAG}RemoteUserMsg")
  fi
  addResponseFileEntry "$varname" "$DB_CONN_USER"
  logFnEnd "${FUNCNAME[0]}"
}

chooseAdminUserName()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "TEM_USER_NAME" "$TEM_USER_NAME"
  checkFatalerror $?
  admUserDesc='AdminUserNameDesc'
  [[ $COMPONENT_SRV = "true" && $SINGLE_DATABASE = "true" ]] || admUserDesc='AdminUserWRDesc'
  TEM_USER_NAME=$(promptForString "$TEM_USER_NAME" "$DEF_TEM_USER_NAME_PROD" $admUserDesc 'AdminUserNameMsg')
  addResponseFileEntry "TEM_USER_NAME" "$TEM_USER_NAME"
  logFnEnd "${FUNCNAME[0]}"
}

getServerDnsName()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "SRV_DNS_NAME" "$SRV_DNS_NAME"
  checkFatalerror $?
  SRV_DNS_NAME=$(promptForString "$SRV_DNS_NAME" "$DEF_SRV_DNS_NAME" 'ServerDnsNameDesc' 'ServerDnsNameMsg')
  addResponseFileEntry "SRV_DNS_NAME" "$SRV_DNS_NAME"
  logFnEnd "${FUNCNAME[0]}"
}

getWebUIDnsNameFromCertificate()
{
  logFnBegin "${FUNCNAME[0]}"
  certName=$1
  
  oldLdLibraryPath="$LD_LIBRARY_PATH"
  LD_LIBRARY_PATH="$DEF_BES_REPOS_FOLDER"
  export LD_LIBRARY_PATH
  writeMsg log "export LD_LIBRARY_PATH=$LD_LIBRARY_PATH"
  
  BES_LIBPATH=$DEF_BES_REPOS_FOLDER
  export BES_LIBPATH
  writeMsg log "export BES_LIBPATH=$BES_LIBPATH"
  commonName=$($DEF_BES_REPOS_FOLDER/BESWebUI --getCommonNameFromCert $certName)
  ret=$?
  
  LD_LIBRARY_PATH="$oldLdLibraryPath"
  export LD_LIBRARY_PATH
  writeMsg log "export LD_LIBRARY_PATH=$LD_LIBRARY_PATH"
  
  logFnEnd "${FUNCNAME[0]}"
  echo "$commonName"
  return $ret
}

getWebUIDnsName()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "WEBUI_DNS_NAME" "$WEBUI_DNS_NAME"
  checkFatalerror $?

  defName=$(getWebUIDnsNameFromCertificate "$WEBUI_SRC_CERT_FOLDER/auth_cert.crt")
  if [[ $? -ne 0 ]]
  then
    defName="$DEF_WEBUI_DNS_NAME"
  fi
  WEBUI_DNS_NAME=$(promptForString "$WEBUI_DNS_NAME" "$defName" 'WebUIDnsNameDesc' 'WebUIDnsNameMsg')
  addResponseFileEntry "WEBUI_DNS_NAME" "$WEBUI_DNS_NAME"
  logFnEnd "${FUNCNAME[0]}"
}

getIdentificationHost()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "SRV_DNS_NAME" "$SRV_DNS_NAME"
  checkFatalerror $?
  SRV_DNS_NAME=$(promptForString "$SRV_DNS_NAME" "$DEF_SRV_DNS_NAME" 'IdentificationHostDesc' 'IdentificationHostMsg')
  addResponseFileEntry "SRV_DNS_NAME" "$SRV_DNS_NAME"
  logFnEnd "${FUNCNAME[0]}"
}

specifyMasterDBHost()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "MASTER_DNS" "$MASTER_DNS"
  checkFatalerror $?
  MASTER_DNS=$(promptForString "$MASTER_DNS" "$MASTHEAD_HOST" 'MasterDb2HostDesc' 'MasterDb2HostMsg')
  addResponseFileEntry "MASTER_DNS" "$MASTER_DNS"
  logFnEnd "${FUNCNAME[0]}"
}

getWebReportsHost()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "SRV_DNS_NAME" "$SRV_DNS_NAME"
  checkFatalerror $?
  SRV_DNS_NAME=$(promptForString "$SRV_DNS_NAME" "$DEF_SRV_DNS_NAME" 'WebReportsHostDesc' 'WebReportsHostMsg')
  addResponseFileEntry "SRV_DNS_NAME" "$SRV_DNS_NAME"
  logFnEnd "${FUNCNAME[0]}"
}

getCredentialUserFirstName()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "CREDENTIAL_USER_FIRSTNAME" "$CREDENTIAL_USER_FIRSTNAME"
  checkFatalerror $?
  CREDENTIAL_USER_FIRSTNAME=$(promptForString "$CREDENTIAL_USER_FIRSTNAME" "" 'CredentialUserFirstNameDesc' 'CredentialUserFirstNameMsg')
  addResponseFileEntry "CREDENTIAL_USER_FIRSTNAME" "$CREDENTIAL_USER_FIRSTNAME"
  logFnEnd "${FUNCNAME[0]}"
}

getCredentialUserLastName()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "CREDENTIAL_USER_LASTNAME" "$CREDENTIAL_USER_LASTNAME"
  checkFatalerror $?
  CREDENTIAL_USER_LASTNAME=$(promptForString "$CREDENTIAL_USER_LASTNAME" "" 'CredentialUserLastNameDesc' 'CredentialUserLastNameMsg')
  addResponseFileEntry "CREDENTIAL_USER_LASTNAME" "$CREDENTIAL_USER_LASTNAME"
  logFnEnd "${FUNCNAME[0]}"
}

getCredentialEmail()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "CREDENTIAL_EMAIL" "$CREDENTIAL_EMAIL"
  checkFatalerror $?
  CREDENTIAL_EMAIL=$(promptForSpecialString "$CREDENTIAL_EMAIL" "" 'CredentialEmailDesc' 'CredentialEmailMsg' 'mail')
  addResponseFileEntry "CREDENTIAL_EMAIL" "$CREDENTIAL_EMAIL"
  logFnEnd "${FUNCNAME[0]}"
}

getCredentialOrgName()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "CREDENTIAL_ORG" "$CREDENTIAL_ORG"
  checkFatalerror $?
  CREDENTIAL_ORG=$(promptForString "$CREDENTIAL_ORG" "" 'CredentialOrgNameDesc' 'CredentialOrgNameMsg')
  addResponseFileEntry "CREDENTIAL_ORG" "$CREDENTIAL_ORG"
  logFnEnd "${FUNCNAME[0]}"
}

specifyExceptionURL()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "EXCEPTION_URL" "$EXCEPTION_URL"
  checkFatalerror $?
  EXCEPTION_URL=$(promptForSpecialString "$EXCEPTION_URL" "" 'ExceptionUrlDesc' 'ExceptionUrlMsg' 'url' )
  addResponseFileEntry "EXCEPTION_URL" "$EXCEPTION_URL"
  logFnEnd "${FUNCNAME[0]}"
}

getSecondaryServerDnsName()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "SRV_DNS_NAME" "$SRV_DNS_NAME"
  checkFatalerror $?
  SRV_DNS_NAME=$(promptForString "$SRV_DNS_NAME" "$DEF_SRV_DNS_NAME" 'SecondarySrvDnsNameDesc' 'SecondarySrvDnsNameMsg')
  addResponseFileEntry "SRV_DNS_NAME" "$SRV_DNS_NAME"
  logFnEnd "${FUNCNAME[0]}"
}

specifyProxyUser()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "PROXY_USER" "$PROXY_USER"
  checkFatalerror $?
  PROXY_USER=$(promptForOptionalString "$PROXY_USER" 'ProxyUserDesc' 'ProxyUserMsg')
  if [[ $PROXY_USER = "" ]]
  then
    addResponseFileEntry "PROXY_USER" "none"
  else
    addResponseFileEntry "PROXY_USER" "$PROXY_USER"
  fi
  PROXY_USER=$(echo "$PROXY_USER" | sed 's/\\/\\\\/g')
  logFnEnd "${FUNCNAME[0]}"
}

selectKeySize()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "PVK_KEY_SIZE" "$PVK_KEY_SIZE"
  checkFatalerror $?
  pvkKeySizeOpt=('PvkKeySizeMinOpt1' 'PvkKeySizeMaxOpt2')
  pvkKeySizeHeader=('PvkKeySizeDesc' 'PvkKeySizeMsg')
  PVK_KEY_SIZE=$(promptForChoice "$PVK_KEY_SIZE" "${ALLOWED_KEY_VAL[*]}" "${pvkKeySizeOpt[*]}" "2" "${pvkKeySizeHeader[*]}")
  addResponseFileEntry "PVK_KEY_SIZE" "$PVK_KEY_SIZE"
  logFnEnd "${FUNCNAME[0]}"
}

chooseAdvMasthDefault()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "ADV_MASTHEAD_DEFAULT" "$ADV_MASTHEAD_DEFAULT"
  checkFatalerror $?
  advMasthUseDefOpt=('advMasthUseDefTrueOpt1' 'advMasthUseDefFalseOpt2')
  advMasthUseDefHeader=('advMasthUseDefDesc' 'advMasthUseDefMsg' 't_advMasthUseDefParmPort':$DEF_BES_SERVER_PORT 't_advMasthUseDefParmFips' 't_advMasthUseDefParmGatInt' 't_advMasthUseDefParmInitLock' 't_advMasthUseDefParmLockContr' 't_advMasthUseDefParmLockExemp' 't_advMasthUseDefArchiveUTF8' 'advMasthUseDefNote')
  ADV_MASTHEAD_DEFAULT=$(promptForChoice "$ADV_MASTHEAD_DEFAULT" "${ALLOWED_BOOLEAN[*]}" "${advMasthUseDefOpt[*]}" "1" "${advMasthUseDefHeader[*]}")
  addResponseFileEntry "ADV_MASTHEAD_DEFAULT" "$ADV_MASTHEAD_DEFAULT"
  logFnEnd "${FUNCNAME[0]}"
}

continueFromCert()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "CONTINUE_FROM_CRT" "$CONTINUE_FROM_CRT"
  checkFatalerror $?
  continueOpt=('ContinueFromCertYesOpt1' 'ContinueFromCertNoOpt2')
  CONTINUE_FROM_CRT=$(promptForChoice "$CONTINUE_FROM_CRT" "${ALLOWED_YES_NO[*]}" "${continueOpt[*]}" "1" 'ContinueFromCertDesc')
  addResponseFileEntry "CONTINUE_FROM_CRT" "$CONTINUE_FROM_CRT"
  logFnEnd "${FUNCNAME[0]}"
}

chooseInstanceConf()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "DB2INST_CONFIGURE" "$DB2INST_CONFIGURE"
  checkFatalerror $?
  db2ConfOpt=('ConfDb2YesOpt1' 'ConfDb2NoOpt2')
  db2ConfHeader=('ConfDb2Desc' 'ConfDb2Msg')
  DB2INST_CONFIGURE=$(promptForChoice "$DB2INST_CONFIGURE" "${ALLOWED_YES_NO[*]}" "${db2ConfOpt[*]}" "1" "${db2ConfHeader[*]}")
  addResponseFileEntry "DB2INST_CONFIGURE" "$DB2INST_CONFIGURE"
  logFnEnd "${FUNCNAME[0]}"
}

prereqSpaceWarning()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "IGNORE_SPACE_WARNING" "$IGNORE_SPACE_WARNING"
  checkFatalerror $?
  continueSpaceHeader=('IgnoreSpaceWrnDesc' 'IgnoreSpaceWrnMsg':$DEF_BES_LOG_FILE)
  continueOpt=('IgnorePrereqWrnYesOpt1' 'IgnorePrereqWrnNoOpt2')
  IGNORE_SPACE_WARNING=$(promptForChoice "$IGNORE_SPACE_WARNING" "${ALLOWED_YES_NO[*]}" "${continueOpt[*]}" "2" "${continueSpaceHeader[*]}")
  logFnEnd "${FUNCNAME[0]}"
}

prereqDBTypeMismatchWarning()
{
  logFnBegin "${FUNCNAME[0]}"
  INSTALLED_DB_TYPE="$1"
  silentCheckNotNull "IGNORE_DB_TYPE_MISMATCH_WARNING" "$IGNORE_DB_TYPE_MISMATCH_WARNING"
  if [[ $? -ne 0 ]]
  then
    #By default exit the upgrade in silent mode
    IGNORE_DB_TYPE_MISMATCH_WARNING="no"
  fi
  continueSpaceHeader=('IgnoreDBTypeMismatchWrnDesc' 'IgnoreDBTypeMismatchWrnMsg':$INSTALLED_DB_TYPE:$DB_TARGET)
  continueOpt=('IgnorePrereqWrnYesOpt1' 'IgnorePrereqWrnNoOpt2')
  IGNORE_DB_TYPE_MISMATCH_WARNING=$(promptForChoice "$IGNORE_DB_TYPE_MISMATCH_WARNING" "${ALLOWED_YES_NO[*]}" "${continueOpt[*]}" "2" "${continueSpaceHeader[*]}")
  logFnEnd "${FUNCNAME[0]}"
}

previousOSVersionForMSSQLWarning()
{
  logFnBegin "${FUNCNAME[0]}"
  OS_VER=$1
  silentCheckNotNull "IGNORE_PREVIOUS_OS_VERSION_FOR_MSSQL" "$IGNORE_PREVIOUS_OS_VERSION_FOR_MSSQL"
  if [[ $? -ne 0 ]]
  then
    #By default exit the upgrade in silent mode
    IGNORE_PREVIOUS_OS_VERSION_FOR_MSSQL="no"
  fi
  continueSpaceHeader=('IgnorePreviousOSVersionForMSSQLWrnDesc' 'IgnorePreviousOSVersionForMSSQLWrnMsg':$OS_VER)
  continueOpt=('IgnorePrereqWrnYesOpt1' 'IgnorePrereqWrnNoOpt2')
  IGNORE_PREVIOUS_OS_VERSION_FOR_MSSQL=$(promptForChoice "$IGNORE_PREVIOUS_OS_VERSION_FOR_MSSQL" "${ALLOWED_YES_NO[*]}" "${continueOpt[*]}" "2" "${continueSpaceHeader[*]}")
  logFnEnd "${FUNCNAME[0]}"
}

installDB2Conf()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "CONTINUE_INSTALL_DB2" "$CONTINUE_INSTALL_DB2"
  checkFatalerror $?
  installDB2Header=('InstDB2ConfDesc' 'InstDB2ConfMsg' 't_InstDB2ConfInstance':$DB2_INSTANCE_NAME 't_InstDB2ConfFencUser':$DB2_FENCED_USERNAME 't_InstDB2ConfPort':$DB_PORT 't_InstDB2ConfPath':$DB2_INSTALL_DIR 'InstDB2ConfComm')
  continueOpt=('InstDB2ConfYesOpt1' 'InstDB2ConfNoOpt2')
  CONTINUE_INSTALL_DB2=$(promptForChoice "$CONTINUE_INSTALL_DB2" "${ALLOWED_YES_NO[*]}" "${continueOpt[*]}" "1" "${installDB2Header[*]}")
  logFnEnd "${FUNCNAME[0]}"
}

installDB2Warning()
{
  logFnBegin "${FUNCNAME[0]}"
  warnDB2Header=('InstDB2WrnDesc' 'InstDB2WrnMsg')
  warnDB2Opt=('InstDB2WrnYesOpt1' 'InstDB2WrnNoOpt2' 'InstDB2WrnExitOpt3')
  isDb2Detected=$(isDB2Installed)
  if [[ $isDb2Detected = "false" ]]
  then
    silentCheckNotNull "INSTALL_DB2" "$INSTALL_DB2"
    checkFatalerror $?
    [ "$INSTALL_DB2" ] && CONTINUE_INSTALL_DB2="${ALLOWED_YES_NO[0]}"
    INSTALL_DB2=$(promptForChoice "$INSTALL_DB2" "${ALLOWED_YES_NO_EXIT[*]}" "${warnDB2Opt[*]}" "1" "${warnDB2Header[*]}")
    addResponseFileEntry "INSTALL_DB2" "$INSTALL_DB2"
  else
    INSTALL_DB2="${ALLOWED_YES_NO_EXIT[1]}"
  fi
  logFnEnd "${FUNCNAME[0]}"
}

prereqDB2Warning()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "IGNORE_DB2_WARNING" "$IGNORE_DB2_WARNING"
  checkFatalerror $?
  continueDB2Header=('IgnoreDB2WrnDesc' 'IgnoreDB2WrnMsg')
  continueOpt=('IgnorePrereqWrnYesOpt1' 'IgnorePrereqWrnNoOpt2')
  IGNORE_DB2_WARNING=$(promptForChoice "$IGNORE_DB2_WARNING" "${ALLOWED_YES_NO[*]}" "${continueOpt[*]}" "2" "${continueDB2Header[*]}")
  logFnEnd "${FUNCNAME[0]}"
}

chooseFirewallConfig()
{
  logFnBegin "${FUNCNAME[0]}"
  if [[ -f /etc/sysconfig/iptables ]]
  then
    confFirewallHeader=('ConfFirewallDesc' 'ConfFirewallMsg')
    confFirewallOpt=('ConfFirewallYesOpt1' 'ConfFirewallNoOpt2')
    firewall-cmd --state 2> /dev/null 1> /dev/null
    if [[ $? -eq 0 ]]
    then
      silentCheckNotNull "CONF_FIREWALL" "$CONF_FIREWALL"
      checkFatalerror $?
      CONF_FIREWALL=$(promptForChoice "$CONF_FIREWALL" "${ALLOWED_YES_NO[*]}" "${confFirewallOpt[*]}" "2" "${confFirewallHeader[*]}")
      FIREWALL_TYPE=${ALLOWED_FIREWALL_TYPE[1]}
    else
      service iptables status > /dev/null
      if [[ $? -eq 0 ]]
      then
        silentCheckNotNull "CONF_FIREWALL" "$CONF_FIREWALL"
        checkFatalerror $?
        CONF_FIREWALL=$(promptForChoice "$CONF_FIREWALL" "${ALLOWED_YES_NO[*]}" "${confFirewallOpt[*]}" "2" "${confFirewallHeader[*]}")
        FIREWALL_TYPE=${ALLOWED_FIREWALL_TYPE[0]}
      else
        CONF_FIREWALL="no"
      fi
    fi
  else
    firewall-cmd --state 2> /dev/null 1> /dev/null
    if [[ $? -eq 0 ]]
    then
      confFirewallHeader=('ConfFirewallDesc' 'ConfFirewallMsg')
      confFirewallOpt=('ConfFirewallYesOpt1' 'ConfFirewallNoOpt2')

      silentCheckNotNull "CONF_FIREWALL" "$CONF_FIREWALL"
      checkFatalerror $?
      CONF_FIREWALL=$(promptForChoice "$CONF_FIREWALL" "${ALLOWED_YES_NO[*]}" "${confFirewallOpt[*]}" "2" "${confFirewallHeader[*]}")
      FIREWALL_TYPE=${ALLOWED_FIREWALL_TYPE[1]}
    else
      CONF_FIREWALL="no"
    fi
  fi
  addResponseFileEntry "CONF_FIREWALL" "$CONF_FIREWALL"
  logFnEnd "${FUNCNAME[0]}"
}

replicationCredentialWarning()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "IGNORE_REPL_CRED_WARNING" "$IGNORE_REPL_CRED_WARNING"
  checkFatalerror $?
  replCredHeader=('ReplCredWrnDesc' 'ReplCredWrnMsg')
  continueOpt=('IgnorePrereqWrnYesOpt1' 'IgnorePrereqWrnNoOpt2')
  IGNORE_REPL_CRED_WARNING=$(promptForChoice "$IGNORE_REPL_CRED_WARNING" "${ALLOWED_YES_NO[*]}" "${continueOpt[*]}" "2" "${replCredHeader[*]}")
  logFnEnd "${FUNCNAME[0]}"
}

generateRespFile()
{
  logFnBegin "${FUNCNAME[0]}"
  if [[ $GENERATE_RESP_FILE = "yes" ]]
  then
    writeResponseFile
    writeMsg both "`nls_replace 'TEM0073I' \"$RESP_FILE_OUT\"`"
  fi
  logFnEnd "${FUNCNAME[0]}"
}

selectGatherInterval()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "BES_GATHER_INTERVAL" "$BES_GATHER_INTERVAL"
  checkFatalerror $?
  intervalOpt=('Int15Min' 'Int30Min' 'Int1Hour' 'Int8Hours' 'Int12Hours' 'Int1Day' 'Int2Days' 'Int1Week' 'Int2Weeks' 'Int1Month' 'Int2Months')
  intervalHeader=('GatherIntervalDesc' 'GatherIntervalMsg')
  BES_GATHER_INTERVAL=$(promptForChoice "$BES_GATHER_INTERVAL" "${ALLOWED_INTERVAL[*]}" "${intervalOpt[*]}" "6" "${intervalHeader[*]}")
  addResponseFileEntry "BES_GATHER_INTERVAL" "$BES_GATHER_INTERVAL"
  logFnEnd "${FUNCNAME[0]}"
}

selectPackageInstall()
{
  logFnBegin "${FUNCNAME[0]}"
  wrnMsg=$1
  silentCheckNotNull "BES_PREREQ_INSTALL" "$BES_PREREQ_INSTALL"
  checkFatalerror $?
  packageOpt=('IgnoreMissingPkg' 'InstallMissingPkg' 'ExitMissingPkg')
  packageHeader=('PkgInstallDesc' 'PkgInstallMsg' ${wrnMsg[*]})
  BES_PREREQ_INSTALL=$(promptForChoice "$BES_PREREQ_INSTALL" "${ALLOWED_INST_PREREQ[*]}" "${packageOpt[*]}" "3" "${packageHeader[*]}")

  addResponseFileEntry "BES_PREREQ_INSTALL" "$BES_PREREQ_INSTALL"
  logFnEnd "${FUNCNAME[0]}"
}

selectDB2PackageInstall()
{
  logFnBegin "${FUNCNAME[0]}"
  wrnMsg=$1
  silentCheckNotNull "BES_PREREQ_DB2_INSTALL" "$BES_PREREQ_DB2_INSTALL"
  checkFatalerror $?
  packageOpt=('IgnoreMissingPkg' 'InstallMissingPkg' 'ExitMissingPkg')
  packageDb2Header=('DB2LibWrnDesc' 'DB2LibWrnMsg' ${wrnMsg[*]})
  BES_PREREQ_DB2_INSTALL=$(promptForChoice "$BES_PREREQ_DB2_INSTALL" "${ALLOWED_INST_PREREQ[*]}" "${packageOpt[*]}" "3" "${packageDb2Header[*]}")

  addResponseFileEntry "BES_PREREQ_DB2_INSTALL" "$BES_PREREQ_DB2_INSTALL"
  logFnEnd "${FUNCNAME[0]}"
}

licenseAgreement()
{
  logFnBegin "${FUNCNAME[0]}"
  sourceLicFolder="$DEF_BES_LIC_FOLDER$DEF_BES_LIC_PROD"
  destLicFolder="$DEF_LIC_ROOT$DEF_BES_LIC_PROD"
  if [[ $IS_EVALUATION = "true" ]]
  then
    sourceLicFolder="$DEF_BES_LIC_FOLDER$DEF_BES_LIC_EVAL"
    destLicFolder="$DEF_LIC_ROOT$DEF_BES_LIC_EVAL"
  fi
  silentCheckNotNull "LA_ACCEPT" "$LA_ACCEPT"
  checkFatalerror $?
  if [[ $LA_ACCEPT = "true" ]]
  then
    #silent install
    copyLAFiles $sourceLicFolder $destLicFolder
    writeMsg log "License Agreement Accepted during silent install: $LA_ACCEPT"
  elif [[ $LA_ACCEPT = "" ]]
  then
      prefix=.
      licFolder=${sourceLicFolder#"$prefix"}
      CURRENT=`pwd`
      LAfilePath=$( getLAFileName $CURRENT$licFolder )
      licenseAgreementHeader=('LicenseAgreementDesc' 'LicenseAgreementMsg':$LAfilePath)
      licAgreementOpt=('LicenseAgreementAcceptTrue' 'LicenseAgreementAcceptFalse')
      LA_ACCEPT=$(promptForChoice "$LA_ACCEPT" "${ALLOWED_BOOLEAN[*]}" "${licAgreementOpt[*]}" "2" "${licenseAgreementHeader[*]}")
      if [[ $LA_ACCEPT = "true" ]]
      then
        copyLAFiles $sourceLicFolder $destLicFolder
      fi
  fi
  writeMsg log "License Agreement Accepted: $LA_ACCEPT"
  addResponseFileEntry "LA_ACCEPT" "$LA_ACCEPT"
  logFnEnd "${FUNCNAME[0]}"
}

chooseUseProxy()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "USE_PROXY" "$USE_PROXY"
  checkFatalerror $?
  useProxyOpt=('UseProxyTrueOpt1' 'UseProxyFalseOpt2')
  USE_PROXY=$(promptForChoice "$USE_PROXY" "${ALLOWED_BOOLEAN[*]}" "${useProxyOpt[*]}" "2" 'UseProxyDesc')
  addResponseFileEntry "USE_PROXY" "$USE_PROXY"
  logFnEnd "${FUNCNAME[0]}"
}

selectInstallType()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "IS_EVALUATION" "$IS_EVALUATION"
  checkFatalerror $?
  installTypeOpt=('InstallTypeEvalOpt1' 'InstallTypeProdOpt2')
  IS_EVALUATION=$(promptForChoice "$IS_EVALUATION" "${ALLOWED_BOOLEAN[*]}" "${installTypeOpt[*]}" "1" 'InstallTypeDesc')
  addResponseFileEntry "IS_EVALUATION" "$IS_EVALUATION"
  logFnEnd "${FUNCNAME[0]}"
}

selectSetupType()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "BES_SETUP_TYPE" "$BES_SETUP_TYPE"
  checkFatalerror $?
  setupTypeOpt=('SetupTypeAuthFileOpt1' 'SetupTypeProdLicOpt2' 'SetupTypeMastheadOpt3')
  BES_SETUP_TYPE=$(promptForChoice "$BES_SETUP_TYPE" "${ALLOWED_SETUP_TYPE[*]}" "${setupTypeOpt[*]}" "1" 'SetupTypeSelectionDesc')
  addResponseFileEntry "BES_SETUP_TYPE" "$BES_SETUP_TYPE"
  logFnEnd "${FUNCNAME[0]}"
}

selectDBReplType()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "SINGLE_DATABASE" "$SINGLE_DATABASE"
  checkFatalerror $?
  singleDbOpt=('DbReplicationOpt1' 'DbReplicationOpt2')
  SINGLE_DATABASE=$(promptForChoice "$SINGLE_DATABASE" "${ALLOWED_BOOLEAN[*]}" "${singleDbOpt[*]}" "1" 'DbReplicationDesc')
  addResponseFileEntry "SINGLE_DATABASE" "$SINGLE_DATABASE"
  logFnEnd "${FUNCNAME[0]}"
}

selectDBLocation()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "LOCAL_DATABASE" "$LOCAL_DATABASE"
  checkFatalerror $?
  localDbOpt=('DbLocationOpt1' 'DbLocationOpt2')
  LOCAL_DATABASE=$(promptForChoice "$LOCAL_DATABASE" "${ALLOWED_BOOLEAN[*]}" "${localDbOpt[*]}" "1" 'DbLocationDesc')
  addResponseFileEntry "LOCAL_DATABASE" "$LOCAL_DATABASE"
  logFnEnd "${FUNCNAME[0]}"
}

selectFipsCompliants()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "ENABLE_FIPS" "$ENABLE_FIPS"
  checkFatalerror $?
  fipsOpt=('FipsCompliantsEnableOpt1' 'FipsCompliantsDisableOpt2')
  ENABLE_FIPS=$(promptForChoice "$ENABLE_FIPS" "${ALLOWED_BOOLEAN[*]}" "${fipsOpt[*]}" "2" 'FipsCompliantsDesc')
  addResponseFileEntry "ENABLE_FIPS" "$ENABLE_FIPS"
  logFnEnd "${FUNCNAME[0]}"
}

enableLockExemptions()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "ENABLE_LOCK_EXEMPT" "$ENABLE_LOCK_EXEMPT"
  checkFatalerror $?
  lockExemptOpt=('LockExemptEnableOpt1' 'LockExemptDisableOpt2')
  ENABLE_LOCK_EXEMPT=$(promptForChoice "$ENABLE_LOCK_EXEMPT" "${ALLOWED_BOOLEAN[*]}" "${lockExemptOpt[*]}" "2" 'LockExemptDesc')
  addResponseFileEntry "ENABLE_LOCK_EXEMPT" "$ENABLE_LOCK_EXEMPT"
  logFnEnd "${FUNCNAME[0]}"
}

chooseInitialLock()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "INITIAL_LOCK" "$INITIAL_LOCK"
  checkFatalerror $?
  initialLockOpt=('InitialLockedOpt' 'InitialLockDurationOpt' 'InitialUnlockedOpt')
  INITIAL_LOCK=$(promptForChoice "$INITIAL_LOCK" "${ALLOWED_INIT_LOCK[*]}" "${initialLockOpt[*]}" "3" 'InitialLockDesc')
  addResponseFileEntry "INITIAL_LOCK" "$INITIAL_LOCK"
  logFnEnd "${FUNCNAME[0]}"
}

chooseLockController()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "LOCK_CONTROLLER" "$LOCK_CONTROLLER"
  checkFatalerror $?
  lockControllerOpt=('LockControllerConsoleOpt' 'LockControllerClientOpt' 'LockControllerNobodyOpt')
  LOCK_CONTROLLER=$(promptForChoice "$LOCK_CONTROLLER" "${ALLOWED_LOCK_CONTROLLER[*]}" "${lockControllerOpt[*]}" "1" 'LockControllerDesc')
  addResponseFileEntry "LOCK_CONTROLLER" "$LOCK_CONTROLLER"
  logFnEnd "${FUNCNAME[0]}"
}

chooseLockDuration()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "LOCK_DURATION" "$LOCK_DURATION"
  checkFatalerror $?
  LOCK_DURATION=$(promptForNumber "LOCK_DURATION" "$LOCK_DURATION" "$DEF_LOCK_DURATION" 'LockDurationDesc' 'LockDurationMsg')
  addResponseFileEntry "LOCK_DURATION" "$LOCK_DURATION"
  logFnEnd "${FUNCNAME[0]}"
}

selectArchiveAllowUTF8()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "ENABLE_ARCHIVE_UTF8" "$ENABLE_ARCHIVE_UTF8"
  checkFatalerror $?
  archiveUTF8Opt=('ArchiveUTF8EnableOpt1' 'ArchiveUTF8DisableOpt2')
  ENABLE_ARCHIVE_UTF8=$(promptForChoice "$ENABLE_ARCHIVE_UTF8" "${ALLOWED_BOOLEAN[*]}" "${archiveUTF8Opt[*]}" "1" 'ArchiveUTF8Desc')
  addResponseFileEntry "ENABLE_ARCHIVE_UTF8" "$ENABLE_ARCHIVE_UTF8"
  logFnEnd "${FUNCNAME[0]}"
}

specifyDbPort()
{
  logFnBegin "${FUNCNAME[0]}"
  varname=${VAR_DB_TAG}_PORT
  DB_PORT=${!varname}
  silentCheckNotNull "$varname" "$DB_PORT"
  checkFatalerror $?
  if [[ $LOCAL_DATABASE = "true" ]]
  then
     DB_PORT=$(promptForNumber "$varname" "$DB_PORT" "$DEF_DB_PORT" "${PROP_DB_TAG}PortDesc" "${PROP_DB_TAG}PortMsg")
  else
     if [[ $COMPONENT_WR = "true" && $COMPONENT_SRV = "false" ]]
     then
       DB_PORT=$(promptForNumber "$varname" "$DB_PORT" "$DEF_DB_PORT" "${PROP_DB_TAG}RemotePortDescWr" "${PROP_DB_TAG}RemotePortMsg")
     else
       DB_PORT=$(promptForNumber "$varname" "$DB_PORT" "$DEF_DB_PORT" "${PROP_DB_TAG}RemotePortDesc" "${PROP_DB_TAG}RemotePortMsg")
     fi
  fi
  addResponseFileEntry "$varname" "$DB_PORT"
  logFnEnd "${FUNCNAME[0]}"
}

specifyMasterDbPort()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "DB2_MASTER_PORT" "$DB2_MASTER_PORT"
  checkFatalerror $?
  DB2_MASTER_PORT=$(promptForNumber "DB2_MASTER_PORT" "$DB2_MASTER_PORT" "$DEF_DB_PORT" 'MasterDb2PortDesc' 'MasterDb2PortMsg')
  addResponseFileEntry "DB2_MASTER_PORT" "$DB2_MASTER_PORT"
  logFnEnd "${FUNCNAME[0]}"
}

chooseWRPort()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "WR_WWW_PORT" "$WR_WWW_PORT"
  checkFatalerror $?
  WR_WWW_PORT=$(promptForNumber "WR_WWW_PORT" "$WR_WWW_PORT" "$DEF_WR_WWW_PORT" 'WRPortDesc' 'WRPortMsg')
  addResponseFileEntry "WR_WWW_PORT" "$WR_WWW_PORT"
  logFnEnd "${FUNCNAME[0]}"
}

chooseWebUIPort()
{
  logFnBegin "${FUNCNAME[0]}"
  addToResponseFile=$1

  silentCheckNotNull "WEBUI_PORT" "$WEBUI_PORT"
  checkFatalerror $?
  WEBUI_PORT=$(promptForNumber "WEBUI_PORT" "$WEBUI_PORT" "$DEF_WEBUI_PORT" 'WebUIPortDesc' 'WebUIPortMsg')
  if [[ $addToResponseFile = "" ]]
  then
    addResponseFileEntry "WEBUI_PORT" "$WEBUI_PORT"
  fi
  logFnEnd "${FUNCNAME[0]}"
}

chooseWebUIRedirect()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "WEBUI_REDIRECT" "$WEBUI_REDIRECT"
  checkFatalerror $?
  webUIRedirectEnable=('WebUIRedirectEnableOpt1' 'WebUIRedirectEnableOpt2')
  webUIRedirectEnableHeader=('WebUIRedirectEnableDesc' 'WebUIRedirectEnableMsg')
  WEBUI_REDIRECT=$(promptForChoice "$WEBUI_REDIRECT" "${ALLOWED_BOOLEAN[*]}" "${webUIRedirectEnable[*]}" "1" "${webUIRedirectEnableHeader[*]}")
  addResponseFileEntry "WEBUI_REDIRECT" "$WEBUI_REDIRECT"
  logFnEnd "${FUNCNAME[0]}"
}

chooseWebUIRedirectPort()
{
  logFnBegin "${FUNCNAME[0]}"
  addToResponseFile=$1

  silentCheckNotNull "WEBUI_REDIRECT_PORT" "$WEBUI_REDIRECT_PORT"
  checkFatalerror $?
  WEBUI_REDIRECT_PORT=$(promptForNumber "WEBUI_REDIRECT_PORT" "$WEBUI_REDIRECT_PORT" "$DEF_WEBUI_REDIRECT_PORT" 'WebUIRedirectPortDesc' 'WebUIRedirectPortMsg')
  if [[ $addToResponseFile = "" ]]
  then
    addResponseFileEntry "WEBUI_REDIRECT_PORT" "$WEBUI_REDIRECT_PORT"
  fi
  logFnEnd "${FUNCNAME[0]}"
}

chooseServerPort()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "BES_SERVER_PORT" "$BES_SERVER_PORT"
  checkFatalerror $?
  BES_SERVER_PORT=$(promptForNumber "BES_SERVER_PORT" "$BES_SERVER_PORT" "$DEF_BES_SERVER_PORT" 'ServerPortDesc' 'ServerPortMsg')
  addResponseFileEntry "BES_SERVER_PORT" "$BES_SERVER_PORT"
  logFnEnd "${FUNCNAME[0]}"
}

chooseIdentificationPort()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "BES_SERVER_PORT" "$BES_SERVER_PORT"
  checkFatalerror $?
  BES_SERVER_PORT=$(promptForNumber "BES_SERVER_PORT" "$BES_SERVER_PORT" "$DEF_BES_SERVER_PORT" 'IdentificationPortDesc' 'IdentificationPortMsg')
  addResponseFileEntry "BES_SERVER_PORT" "$BES_SERVER_PORT"
  logFnEnd "${FUNCNAME[0]}"
}

chooseProxyPort()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "PROXY_PORT" "$PROXY_PORT"
  checkFatalerror $?
  PROXY_PORT=$(promptForOptionalNumber "PROXY_PORT" "$PROXY_PORT" 'ProxyPortDesc' 'ProxyPortMsg')
  if [[ $PROXY_PORT = "" ]]
  then
    addResponseFileEntry "PROXY_PORT" "0"
  else
    addResponseFileEntry "PROXY_PORT" "$PROXY_PORT"
  fi
  logFnEnd "${FUNCNAME[0]}"
}

getLicCertificateFile()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "BES_CERT_FILE" "$BES_CERT_FILE"
  checkFatalerror $?
  BES_CERT_FILE=$(promptForFile "BES_CERT_FILE" "$BES_CERT_FILE" "$DEF_BES_CERT_FILE" "$BES_LIC_FOLDER" "$DEF_BES_LIC_FOLDER" 'LicCertificateFileDesc' 'LicCertificateFileMsg')
  addResponseFileEntry "BES_CERT_FILE" "$BES_CERT_FILE"
  logFnEnd "${FUNCNAME[0]}"
}

getDB2SetupFile()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "DB2_SETUP_FILE" "$DB2_SETUP_FILE"
  checkFatalerror $?
  DB2_SETUP_FILE=$(promptForFile "DB2_SETUP_FILE" "$DB2_SETUP_FILE" "$DEF_DB2_SETUP_FILE" "$DB2_SETUP_FOLDER" "$DEF_DB2_SETUP_FOLDER" 'Db2SetupFileDesc' 'Db2SetupFileMsg')
  addResponseFileEntry "DB2_SETUP_FILE" "$DB2_SETUP_FILE"
  logFnEnd "${FUNCNAME[0]}"
}

getSigningKey()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "BES_LICENSE_PVK" "$BES_LICENSE_PVK"
  checkFatalerror $?
  BES_LICENSE_PVK=$(promptForFile "BES_LICENSE_PVK" "$BES_LICENSE_PVK" "$DEF_BES_LICENSE_PVK" "$BES_LIC_FOLDER" "$DEF_BES_LIC_FOLDER" 'SigningKeyDesc' 'SigningKeyMsg')
  addResponseFileEntry "BES_LICENSE_PVK" "$BES_LICENSE_PVK"
  logFnEnd "${FUNCNAME[0]}"
}

getMastheadFile()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "BES_MASTHEAD_FILE" "$BES_MASTHEAD_FILE"
  checkFatalerror $?
  defMastheadPath="$DEF_BES_LIC_FOLDER"
  defMastheadFile="$DEF_BES_MASTHEAD_FILE"
  if [[ $COMPONENT_SRV = "false" ]]
  then
    if [[ -f $DEF_BES_ETC$DEF_BES_ACTIONSITE_FILE ]]
    then
      defMastheadPath="$DEF_BES_ETC"
      defMastheadFile="$DEF_BES_ACTIONSITE_FILE"
    elif [[ -f $DEF_AGT_ETC$DEF_BES_ACTIONSITE_FILE ]]
    then
      defMastheadPath="$DEF_AGT_ETC"
      defMastheadFile="$DEF_BES_ACTIONSITE_FILE"
    fi
  fi
  BES_MASTHEAD_FILE=$(promptForFile "BES_MASTHEAD_FILE" "$BES_MASTHEAD_FILE" "$defMastheadFile" "$BES_LIC_FOLDER" "$defMastheadPath" 'MastheadDesc' 'MastheadMsg')
  addResponseFileEntry "BES_MASTHEAD_FILE" "$BES_MASTHEAD_FILE"
  logFnEnd "${FUNCNAME[0]}"
}

getAuthFile()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "BES_AUTH_FILE" "$BES_AUTH_FILE"
  checkFatalerror $?
  BES_AUTH_FILE=$(promptForFile "BES_AUTH_FILE" "$BES_AUTH_FILE" "$DEF_BES_AUTH_FILE" "$BES_LIC_FOLDER" "$DEF_BES_LIC_FOLDER" 'AuthFileDesc' 'AuthFileMsg')
  addResponseFileEntry "BES_AUTH_FILE" "$BES_AUTH_FILE"
  logFnEnd "${FUNCNAME[0]}"
}

useRootForWR()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "WR_USEROOT" "$WR_USEROOT"
  checkFatalerror $?
  useRootWROpt=('UseRootWROpt1' 'UseRootWROpt2')
  useRootWRHeader=('UseRootWRDesc' 'UseRootWRMsg')
  WR_USEROOT=$(promptForChoice "$WR_USEROOT" "${ALLOWED_BOOLEAN[*]}" "${useRootWROpt[*]}" "2" "${useRootWRHeader[*]}")
  addResponseFileEntry "WR_USEROOT" "$WR_USEROOT"
  logFnEnd "${FUNCNAME[0]}"
}

chooseNonRootUserNameForWR()
{
  logFnBegin "${FUNCNAME[0]}"
  silentCheckNotNull "WR_NONROOT_USER_NAME" "$WR_NONROOT_USER_NAME"
  checkFatalerror $?
  while :
  do
    WR_NONROOT_USER_NAME=$(promptForString "$WR_NONROOT_USER_NAME" '' 'WRNonRootUserNameDesc' 'WRNonRootUserNameMsg')
    userExists $WR_NONROOT_USER_NAME
    if [[ $? -ne 0 ]]
    then
      WR_NONROOT_USER_NAME=""  #otherwise promptForString makes it loop...
      writeMsg stdout "`nls_replace 'TEM0152W'`"
    else
      break
    fi
  done
  addResponseFileEntry "WR_NONROOT_USER_NAME" "$WR_NONROOT_USER_NAME"
  logFnEnd "${FUNCNAME[0]}"
}

selectRepoEnable()
{
  logFnBegin "${FUNCNAME[0]}"
  pkgNameInst=($1)
  pkgRepoUrl=($2)
  repoIsEnabled=($3)

  wrnMsg=()
  i=0
  for isEnabled in ${repoIsEnabled[*]}
  do
    if [[ $isEnabled != "true" && ${pkgRepoUrl[i]} != "_" ]]
    then
      wrnMsg+=("TEM0185W:${pkgRepoUrl[i]}:${pkgNameInst[i]}.x86_64")
    else
      wrnMsg+=("_")
    fi
    let i=i+1
  done

  silentCheckNotNull "BES_PREREQ_REPO_ENABLE" "$BES_PREREQ_REPO_ENABLE"
  checkFatalerror $?
  repoOpt=('IgnoreDisabledRepo' 'EnableDisabledRepo' 'ExitDisableRepo')
  repoHeader=('RepoEnableDesc' 'RepoEnableMsg' "${wrnMsg[*]}")
  BES_PREREQ_REPO_ENABLE=$(promptForChoice "$BES_REPO_ENABLE" "${ALLOWED_REPO_ENABLE_PREREQ[*]}" "${repoOpt[*]}" "3" "${repoHeader[*]}")

  addResponseFileEntry "BES_PREREQ_REPO_ENABLE" "$BES_PREREQ_REPO_ENABLE"
  logFnEnd "${FUNCNAME[0]}"
}
