#!/bin/bash
PRODUCT_NAME="BigFix"
PRODUCT_VERSION=11.0.5.203
DB_TARGET=mssql

shdir=`pwd`/$(dirname "$0")
[ "$(echo $0 | grep '\./')" = "" ] && [ "$(echo $0 | grep '^/.*')" = "" ] && [ `pwd` = '/' ] && shdir=`pwd`$(dirname "$0")
[ "$(echo $0 | grep '^/.*')" != "" ] && shdir=$(dirname "$0")

instRoot=$shdir
case $shdir in
  *\. ) instRoot=${shdir%/*}
esac

cd "$instRoot"

#Default Values
DEF_INPUT_SEPARATOR="####################"
DEF_LIC_REQUEST_URL="http://support.bigfix.com/bes/forms/BESLicenseRequestHandler.html"
DEF_SRV_DNS_NAME="`hostname`"
DEF_WEBUI_DNS_NAME="`hostname`"
DEF_BES_LOG_ROOT="/var/log"
DEF_BES_LOG_FILE="$DEF_BES_LOG_ROOT/BESInstall.log"
DEF_BES_LIC_FOLDER="./license"
DEF_WEBUI_SRC_CERT_FOLDER="./cert_webui"
DEF_BES_LIC_EVAL="/evaluation"
DEF_BES_LIC_PROD="/production"
DEF_BES_REPOS_FOLDER="./repos"
DEF_DB2_SETUP_FOLDER="../server"
DEF_DB2_BUNDLED_FOLDER="server"
DEF_BES_ENCODING_MAP_FILE="$DEF_BES_REPOS_FOLDER/encoding.map"
DEF_BES_DB2_RESP_TEMPLATE="$DEF_BES_REPOS_FOLDER/db2wse_template.rsp"
DEF_BES_DB2_RESP="$DEF_BES_LOG_ROOT/db2wse_iem.rsp"
DEF_BES_ROOT="/var/opt/BESServer"
DEF_CLIENT_ROOT="/var/opt/BESClient"
DEF_WR_ROOT="/var/opt/BESWebReportsServer"
DEF_WEBUI_ROOT="/var/opt/BESWebUI"
DEF_WEBUI_SITES_DIR="$DEF_WEBUI_ROOT/WebUI/sites"
BES_INFO_FILE="/bes.info"
DEF_BES_CONFIG="$DEF_BES_ROOT/besserver.config"
DEF_BES_CONFIG_DEFAULT="$DEF_BES_ROOT/besserver.config.default"
DEF_BES_CONFIG_TEMPLATE="$DEF_BES_REPOS_FOLDER/besserver.config.template"
DEF_BES_CONFIG_TEMPLATE_EXT="$DEF_BES_LOG_ROOT/besserver.config.template.ext"
DEF_CLIENT_CONFIG="$DEF_CLIENT_ROOT/besclient.config"
DEF_CLIENT_CONFIG_DEFAULT="$DEF_CLIENT_ROOT/besclient.config.default"
DEF_WR_CONFIG="$DEF_WR_ROOT/beswebreports.config"
DEF_WR_CONFIG_DEFAULT="$DEF_WR_ROOT/beswebreports.config.default"
DEF_WR_CONFIG_TEMPLATE="$DEF_BES_REPOS_FOLDER/beswebreports.config.template"
DEF_WR_CONFIG_TEMPLATE_EXT="$DEF_BES_LOG_ROOT/beswebreports.config.template.ext"
DEF_WR_PEM="$DEF_WR_ROOT/BESReportsData/SelfWRCertificate.pem"
DEF_LIC_ROOT="/var/opt/BESLicense"
INSTALLERS_DIR="/var/opt/BESInstallers"
DEF_BES_BIN_ROOT="/opt/BESServer/bin"
DEF_WR_BIN_ROOT="/opt/BESWebReportsServer/bin"
DEF_WEBUI_BIN_ROOT="/opt/BESWebUI/bin"
DEF_BES_ETC="/etc/opt/BESServer"
DEF_WR_ETC="/etc/opt/BESWebReportsServer"
DEF_AGT_ETC="/etc/opt/BESClient"
DEF_BES_WWW_FOLDER="/wwwrootbes"
DEF_WR_WWW_FOLDER="/wwwroot"
DEF_WR_WWW_PORT="8083"
DEF_WR_REDIRECT_PORT="8080"
[[ $DB_TARGET = "db2" ]] && DEF_DB_PORT=""
[[ $DB_TARGET = "mssql" ]] && DEF_DB_PORT="1433"
[[ $DB_TARGET = "db2" ]] && DEF_DB_ADMIN_USER="db2inst1"
[[ $DB_TARGET = "mssql" ]] && DEF_DB_ADMIN_USER="sa"
DEF_DB_CONN_USER="$DEF_DB_ADMIN_USER"
DEF_TEM_USER_NAME_EVAL="EvaluationUser"
DEF_TEM_USER_NAME_PROD="BFAdmin"
DEF_BES_LICENSE_PVK="/license.pvk"
DEF_BES_MASTHEAD_FILE="/masthead.afxm"
DEF_BES_ACTIONSITE_FILE="/actionsite.afxm"
DEF_BES_REQUEST="/request.BESLicenseRequest"
[[ $DB_TARGET = "db2" ]] && DEF_BES_DB_NAME="BFENT"
[[ $DB_TARGET = "mssql" ]] && DEF_BES_DB_NAME="BFEnterprise"
[[ $DB_TARGET = "db2" ]] && DEF_WR_DB_NAME="BESREPOR"
[[ $DB_TARGET = "mssql" ]] && DEF_WR_DB_NAME="BESReporting"
DEF_BES_AUTH_FILE="/LicenseAuthorization.BESLicenseAuthorization"
DEF_BES_CERT_FILE="/license.crt"
DEF_DB2_SETUP_FILE="/db2setup"
DEF_RPM_SRV_PREFIX="BESRootServer"
DEF_RPM_WR_PREFIX="BESWebReportsServer"
DEF_RPM_AGT_PREFIX="BESAgent"
DEF_RPM_REL_PREFIX="BESRelay"
DEF_RPM_WEBUI_PREFIX="BESWebUI"
DEF_BES_SERVER_PORT="52311"
DEF_LOCK_DURATION="5"
DEF_DB2_FENCED_USERNAME="db2fenc1"
DEF_DB2_INSTALL_DIR="/opt/ibm/db2/V11.5"
DEF_PROXY_METH="all"
DEF_WEBUI_APPSERVER_PORT="52315"
DEF_WEBUI_PORT="443"
DEF_WEBUI_REDIRECT_PORT="80"
DEF_WEBUI_REDIRECT_ENABLE="1"

ALLOWED_BOOLEAN=("true" "false")
ALLOWED_KEY_VAL=("min" "max")
ALLOWED_PROXYMTH=("basic" "digest" "ntlm" "negotiate")
ALLOWED_SETUP_TYPE=("authfile" "prodlic" "masthead")
ALLOWED_INST_PREREQ=("ignore" "install" "exit")
ALLOWED_YES_NO=("yes" "no")
ALLOWED_YES_NO_EXIT=("yes" "no" "exit")
ALLOWED_TEST_PROXY=("nofips" "fips" "no")
ALLOWED_FIREWALL_TYPE=("static" "dynamic")
ALLOWED_INTERVAL=(0 1 2 3 4 5 6 7 8 9 10)
ALLOWED_INIT_LOCK=(0 1 2)
ALLOWED_LOCK_CONTROLLER=(0 1 2)
ALLOWED_REPO_ENABLE_PREREQ=("ignore" "enable" "exit")
SERVICE_SERVER=("besserver" "BESRootServer")
SERVICE_FILLDB=("besfilldb" "BESFillDB")
SERVICE_GATHERDB=("besgatherdb" "BESGatherDB")
SERVICE_WEBREPORT=("beswebreports" "BESWebReportsServer")
SERVICE_CLIENT=("besclient" "BESClient")
SERVICE_WEBUI=("beswebui" "BESWebUI")

#Installation Variables to be used also in response file
typeset -l LA_ACCEPT=""
typeset -l BES_SETUP_TYPE=""
typeset -l COMPONENT_SRV=""
typeset -l COMPONENT_WR=""
typeset -l COMPONENT_WEBUI=""
typeset -l SINGLE_DATABASE=""
typeset -l LOCAL_DATABASE=""
typeset -l SUBMIT_LIC_REQUEST=""
typeset -l CONTINUE_FROM_CRT=""
typeset -l PVK_KEY_SIZE=""
typeset -l ENABLE_FIPS=""
typeset -l ENABLE_LOCK_EXEMPT=""
typeset -l ADV_MASTHEAD_DEFAULT=""
typeset -l IS_EVALUATION=""
typeset -l USE_PROXY=""
typeset -l CONF_FIREWALL=""
typeset -l FIREWALL_TYPE=""
typeset -l DB2INST_CONFIGURE=""
typeset -l IS_PREREQ_CHECK=""
typeset -l ASK_PVK_CREDENTIALS=""
typeset -l BES_RESTART=""
typeset -l RUN_AS_FIXLET=""
typeset -l BES_UPGRADE_CLIENT=""
typeset -l INSTALL_DB2=""
typeset -l PROXY_DOWN=""
typeset -l PROXY_SECTUNNEL=""
typeset -l PROXY_METH=""
typeset -l TEST_PROXY=""
typeset -l REINPUT_PROXY=""
typeset -l ENABLE_ARCHIVE_UTF8=""
typeset -l IS_SILENT=""
ENCODE_VALUE=""
SRV_DNS_NAME=""
WEBUI_DNS_NAME=""
BES_WWW_FOLDER=""
WR_WWW_FOLDER=""
WR_WWW_PORT=""
DB_HOSTNAME=""
DB_PORT=""
DB_CONN_USER=""
DB_CONN_PWD=""
DB2_INSTANCE_NAME=""
DB_ADMIN_USER=""
DB_ADMIN_PWD=""
DB_REPLICA_PWD_SHA256=""
DB2_EXTR_DIR=""
BES_LICENSE_PVK=""
BES_LICENSE_PVK_PWD=""
TEM_USER_NAME=""
TEM_USER_PWD=""
BES_MASTHEAD_FILE=""
BES_LIC_FOLDER=""
WEBUI_SRC_CERT_FOLDER=""
BES_AUTH_FILE=""
BES_CERT_FILE=""
BES_GATHER_INTERVAL=""
BES_SERVER_PORT=""
INITIAL_LOCK=""
LOCK_CONTROLLER=""
LOCK_DURATION=""
EXCEPTION_URL=""
CREDENTIAL_USER=""
CREDENTIAL_EMAIL=""
CREDENTIAL_ORG=""
PROXY_HOST=""
PROXY_PORT=""
PROXY_USER=""
PROXY_PWD=""
PROXY_EXLIST=""
MASTER_DNS=""
DB2_MASTER_PORT=""
DB2_MASTER_USER=""
DB2_MASTER_PWD=""
DB2_MASTER_PWD_SHA256=""
BES_PREREQ_INSTALL=""
BES_PREREQ_DB2_INSTALL=""
BES_DB_NAME="$DEF_BES_DB_NAME"
WR_DB_NAME="$DEF_WR_DB_NAME"
WEBUI_PORT=""
WEBUI_REDIRECT_PORT=""
WEBUI_REDIRECT=""
WEBUI_APPSERVER_PORT=""
DB_WEBUI_PWD=""
DB_WEBUI_HOSTNAME=""
DB_WEBUI_ADMIN_USER=""
DB_WEBUI_PORT=""
BES_PREREQ_REPO_ENABLE=""

#DB2 Prereq Variables
DB2_FENCED_USERNAME=""
DB2_INSTALL_DIR=""
DB2_USERS_PWD=""
DB2_SETUP_FILE=""
DB2_SETUP_FOLDER=""

#Other Installation Variables
PREREQ_OS_OK="false"
PREREQ_OSRHEL_OK="false"
PREREQ_STACKSIZELIMIT_OK="false"
PREREQ_DB2_OK="false"
PREREQ_SPACE_MISSING="false"
IGNORE_WARNING=""
IGNORE_DB2_WARNING=""
IGNORE_SPACE_WARNING=""
IGNORE_REPL_CRED_WARNING=""
ENC_VALUE=""
BES_UPGRADE="false"
BES_REUSE_DB="false"
RESPONSE_FILE=""
RESP_FILE_OUT=""
EXIT_CODE=0
RPM_SRV_PKG=""
RPM_WR_PKG=""
RPM_WEBUI_PKG=""
RPM_AGT_PKG=""
DB2_LIB_PATH=""
DB2_DRIVER_FILE_NAME="libdb2o.so"
DB2_SRC_LIC_FOLDER="../DB2_std_vpc_license"
DB2_DST_LIC_FOLDER_NAME="license_std_vpc"
GENERATE_RESP_FILE="no"
MASTHEAD_URL=""
MASTHEAD_HOST=""
MASTHEAD_PORT=""
CONTINUE_INSTALL_DB2=""
SERVICE_FOLDER="/etc/init.d"
BES_MINIMUM_UPGRADE_VERSION="9.2.3"
WEBUI_MINIMUM_UPGRADE_VERSION="9.5.6"

Print_Usage() {
    writeMsg stdout "`nls_replace 'InstCmdHelp'`"
    writeMsg stdout $'\t'"`nls_replace 'CmdHelpOpt1'`"
    writeMsg stdout $'\t'"`nls_replace 'CmdHelpOpt2'`"
    writeMsg stdout $'\t'"`nls_replace 'CmdHelpOpt3'`"
    writeMsg stdout $'\t'"`nls_replace 'CmdHelpOpt4'`"
    writeMsg stdout $'\t'"`nls_replace 'CmdHelpOpt5'`"
    exit 2
}

###########
# Main
###########
TEXTDOMAINDIR=$instRoot/config/nls/msg
export TEXTDOMAINDIR
PATH=$instRoot:$instRoot/bin:$PATH
export PATH
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:"$DEF_BES_BIN_ROOT"
export LD_LIBRARY_PATH
BESServerConfigPath="$DEF_BES_CONFIG"
export BESServerConfigPath
. "$instRoot/bin/input.sh"
. "$instRoot/bin/action.sh"
. "$instRoot/bin/core.sh"

checkRootUser

if [[ ! -d $DEF_BES_LOG_ROOT ]]
then
  mkdir -p $DEF_BES_LOG_ROOT 2>/dev/null
fi

echo "# BigFix Debug Log File (`eval date +%Y%m%d`)" > $DEF_BES_LOG_FILE

writeMsg log "export TEXTDOMAINDIR=$TEXTDOMAINDIR"
writeMsg log "export PATH=$PATH"
writeMsg log "export LD_LIBRARY_PATH=$LD_LIBRARY_PATH"
writeMsg log "export BESServerConfigPath=$BESServerConfigPath"

# Verify input command
if [[ $# -lt 0 ]]
then
  Print_Usage
else
  for i
  do
    case "$1" in
      -f)       shift
                RESPONSE_FILE=$1
                if [[ -f "$RESPONSE_FILE" ]]
                then
                  . "$RESPONSE_FILE"
                  writeMsg log "`nls_replace 'TEM0063I' \"$RESPONSE_FILE\"`"
                else
                  #ERR: "The specified response file: %s does not exists."
                  writeMsg both "`nls_replace 'TEM0005E' \"$RESPONSE_FILE\"`"
                  Print_Usage
                fi
                ;;
      -upgrade) BES_UPGRADE="true"
                writeMsg log "`nls_replace 'TEM0064I'`"
                ;;
      -reuseDb) BES_REUSE_DB="true"
                writeMsg log "`nls_replace 'TEM0085I'`"
                ;;
      -g)       writeMsg log "`nls_replace 'TEM0065I'`"
                GENERATE_RESP_FILE="yes"
                shift
                RESP_FILE_OUT=$1
                echo "##BigFix GENERATED RESPONSE FILE" > $RESP_FILE_OUT
                if [[ ! -f "$RESP_FILE_OUT" ]]
                then
                  writeMsg both "`nls_replace 'TEM0071E' \"$RESP_FILE_OUT\"`"
                  Print_Usage
                fi
                ;;
      -opt)     writeMsg log "`nls_replace 'TEM0129I'`"
                shift
                addOptEntry "$1"
                ;;
      * )       if [[ $1 != "" ]]
                then
                  Print_Usage
                fi
                ;;
    esac
    if [[ $# -eq 0 ]]
    then
      break
    fi
    shift
  done
fi
setOptEntry

if [[ $BES_UPGRADE = "true" ]]
then
  upgradeInstall
  let "EXIT_CODE=EXIT_CODE+$?"
  msgSuccess="`nls_replace 'TEM0066I' \"$PRODUCT_NAME\"`"
  msgError="`nls_replace 'TEM0067E'  \"$PRODUCT_NAME\" \"$DEF_BES_LOG_FILE\"`"
else
  freshInstall
  let "EXIT_CODE=EXIT_CODE+$?"
  msgSuccess="`nls_replace 'TEM0027I' \"$PRODUCT_NAME\"`"
  msgError="`nls_replace 'TEM0028E' \"$PRODUCT_NAME\" \"$DEF_BES_LOG_FILE\"`"
fi

if [[ $EXIT_CODE -eq 0 ]]
then
  writeMsg both "$msgSuccess"
  if [[ $COMPONENT_SRV = "true" && $SINGLE_DATABASE = "true" ]]
  then
    writeMsg both "`nls_replace 'TEM0056I' \"$TEM_USER_NAME\"`"
    writeMsg both "`nls_replace 'TEM0082I' \"$INSTALLERS_DIR\"`"
  fi
else
  writeMsg both "$msgError"
fi
exit $EXIT_CODE
