#!/bin/sh
#
# besgatherdb.sh: Starts the BigFix BESGatherDB
#
# description: Starts the BigFix besgatherdb service
# processname: BESGatherDB

if [ $PPID -eq 1 ]; then

	export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/opt/BESServer/bin
	
	stackSizeHardLimitKB=$(ulimit -Hs)
	if [ "$stackSizeHardLimitKB" != "unlimited" ] && [ $stackSizeHardLimitKB -lt 10240 ]; then
		/bin/echo "Stack size hard limit ( ulimit -Hs ) too low = $stackSizeHardLimitKB."
		exit 1	
	fi

	stackSizeSoftLimitKB=$(ulimit -Ss)
	if [ "$stackSizeSoftLimitKB" = "unlimited" ] || [ $stackSizeSoftLimitKB -lt 10240 ]; then
		ulimit -Ss 10240
	fi

	/opt/BESServer/bin/BESGatherDB 2> /dev/null
	ret=$?
else
	echo besgatherdb.sh shall be used only within systemd unitfile
	ret=1
fi

exit $ret
