#!/bin/sh
#
# besserver.sh: Starts the BigFix Server
#
# description: Starts the BigFix Server service
# processname: BESRootServer

start() {
	SKIP_CLIENT_RESTART="${SKIP_CLIENT_RESTART:-noskip$1}"

	echo SKIP_CLIENT_RESTART: "$SKIP_CLIENT_RESTART"

	export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/opt/BESServer/bin

	CLIENT_RESTART_NEEDED=0
	serverConfigPath=/var/opt/BESServer/besserver.config
	if [ ! -f $serverConfigPath ]; then
		cat $serverConfigPath.default > $serverConfigPath
		CLIENT_RESTART_NEEDED=1
	fi

	stackSizeHardLimitKB=$(ulimit -Hs)
	if [ "$stackSizeHardLimitKB" != "unlimited" ] && [ $stackSizeHardLimitKB -lt 10240 ]; then
		failure "Stack size hard limit ( ulimit -Hs ) too low = $stackSizeHardLimitKB."
		/bin/echo
		return 1	
	fi

	stackSizeSoftLimitKB=$(ulimit -Ss)
	if [ "$stackSizeSoftLimitKB" = "unlimited" ] || [ $stackSizeSoftLimitKB -lt 10240 ]; then
		ulimit -Ss 10240
	fi

	/opt/BESServer/bin/BESRootServer 2> /dev/null
	ret=$?

	if [ $CLIENT_RESTART_NEEDED -eq 1 ] && [ "$SKIP_CLIENT_RESTART" == "noskip" ]; then
		/bin/systemctl restart besclient >& /dev/null 
	fi

	return $ret
}

start_skipclientrestart() {
	echo SKIP_CLIENT_RESTART=skip > /etc/opt/BESClient/besserver.env
	/bin/systemctl start besserver >& /dev/null 
}

error() {
	echo The argument "$1" is not supported. Usage: besserver.sh start_skipclientrestart
	return 1
}

case "$1" in
	start)
		# The start argument can be only used within the systemd unit file
		if [ $PPID -eq 1 ]; then
			start
		else 
			error "$1"
		fi
		;;
	start_skipclientrestart)
		start_skipclientrestart
		;;
	*)
		error "$1"
esac

exit $?
