/* ************************************************** */
/*                                                    */
/* Licensed Materials - Property of HCL               */
/* © Copyright HCL Technologies Limited 2001, 2019    */
/* All Rights Reserved                                */
/*                                                    */
/* ************************************************** */

// ClientCompliance.h

#ifndef ClientCompliance_h
#define ClientCompliance_h

#ifdef _WIN32
	#include "comutil.h"
	typedef _bstr_t COMPSTR;
#else
	#include <string>
	typedef std::string COMPSTR;
#endif

#	define CLIENTCOMPLIANCEDLL_API extern "C" 


// COMPLIANCE symbols
// **************************************************
//      COMPLIANCE_FLAG
#define COMPLIANCE_FLAG_GATHER                    1  
#define COMPLIANCE_FLAG_EVALUATE_ALL              2
#define COMPLIANCE_FLAG_IDLE_CPU_USAGE            4	// introduced in BES 5.1
#define COMPLIANCE_FLAG_ACTIONHINT                8 // introduced in BES 6.1  (takes precidence over other flags)

// **************************************************
//      COMPLIANCE_ERROR
#define COMPLIANCE_ERROR_NOTINSTALLED            -1
#define COMPLIANCE_ERROR_NOTRUNNING              -2
#define COMPLIANCE_ERROR_NOTRESPONDING           -3
#define COMPLIANCE_ERROR_NOTCONFIGURED           -4
#define COMPLIANCE_ERROR_EXISTINGREQUEST         -5
#define COMPLIANCE_ERROR_API_BUSY                -6
#define COMPLIANCE_ERROR_RESPONSE_MALFORMED      -7
#define COMPLIANCE_ERROR_RESPONSE_CLOSED         -8
#define COMPLIANCE_ERROR_OLD_VERSION             -9
#define COMPLIANCE_ERROR_RESPONSE_READING       -10
#define COMPLIANCE_ERROR_DOC_READING            -11
#define COMPLIANCE_ERROR_DOC_TYPE               -12
#define COMPLIANCE_ERROR_DOC_SITE               -13
#define COMPLIANCE_ERROR_DOC_MISSING            -14
#define COMPLIANCE_ERROR_PENDING_CLOSE          -15
#define COMPLIANCE_ERROR_TALK_FAILED            -16
#define COMPLIANCE_ERROR_WRITING_REQUEST        -17
#define COMPLIANCE_ERROR_NO_RESPONSE            -18
#define COMPLIANCE_ERROR_COMPLIANCE_IO_FAILURE  -19
#define COMPLIANCE_ERROR_INDEX_TOO_LARGE        -20
#define COMPLIANCE_ERROR_UNEXPECTED             -21

#define COMPLIANCE_ERROR_CHANGING_CONDITIONS    -22

#define COMPLIANCE_ERROR_DIR_MISSING            -23
#define COMPLIANCE_ERROR_FILE_LOCKED            -24
#define COMPLIANCE_ERROR_FILE_PERMISSIONS       -25

#define COMPLIANCE_ERROR_DOC_NOT_UTF8           -26

// **************************************************
//      COMPLIANCE_PROGRESS_
#define COMPLIANCE_PROGRESS_COMPLETE               1
#define COMPLIANCE_PROGRESS_ERROR                  2
#define COMPLIANCE_PROGRESS_BUSY                   3


// COMPLIANCE Function definitions
// **************************************************
CLIENTCOMPLIANCEDLL_API int COMPLIANCE_Open( 	
      COMPSTR siteurl,
      COMPSTR complianceDocument,
      unsigned int flag // COMPLIANCE_FLAG_*
);
// return value < 0 is COMPLIANCE_ERROR_*
// return value == 0 if Open successfully talks to client

// **************************************************
CLIENTCOMPLIANCEDLL_API int COMPLIANCE_Close();
// return value < 0 is COMPLIANCE_ERROR_*
// return value = 0 is success

// **************************************************
CLIENTCOMPLIANCEDLL_API int COMPLIANCE_Progress(	
      unsigned int* progressPercent,
      int* error
);
// return value of COMPLIANCE_PROGRESS_COMPLETE
// return value of COMPLIANCE_PROGRESS_BUSY; progressPercent set
// return value of COMPLIANCE_PROGRESS_ERROR; error set

//COMPLIANCE response accessors
// **************************************************
CLIENTCOMPLIANCEDLL_API int COMPLIANCE_ResultCount();
// return value is the number of all values
// return value is COMPLIANCE_ERROR_*

// **************************************************
CLIENTCOMPLIANCEDLL_API int COMPLIANCE_IndexedValue (
      unsigned int index,       // value to retrieve (starts at 0)
      COMPSTR *designator,  // designator of value found
      COMPSTR *result,      // result of evaluating relevance
	  COMPSTR *resultType,  
	  COMPSTR *evalTime,    
      COMPSTR *description, // description accompanying designator
      COMPSTR *comment      // comment accompanying designator
);
// return value is 0 on success, otherwise COMPLIANCE_ERROR_*

// **************************************************
void COMPLIANCE_CopyResponseXMLTo(
      const COMPSTR destination
);

#endif // ClientCompliance_h
