'
' Sample vbscript to show how to use the BESClientComplianceMod objects
' BigFix, 2004

Set session  = WScript.CreateObject("BESClientComplianceMod.Session")
Set progress = WScript.CreateObject("BESClientComplianceMod.Progress")
Set response = WScript.CreateObject("BESClientComplianceMod.Response")

'See ClientCompliance.h for numeric constants
COMPLIANCE_PROGRESS_COMPLETE = 1
COMPLIANCE_PROGRESS_ERROR    = 2
COMPLIANCE_PROGRESS_BUSY     = 3

COMPLIANCE_FLAG_GATHER         = 1  
COMPLIANCE_FLAG_EVALUATE_ALL   = 2
COMPLIANCE_FLAG_IDLE_CPU_USAGE = 4
COMPLIANCE_FLAG_ACTIONHINT     = 8

COMPLIANCE_ERROR_CHANGING_CONDITIONS = -22


On Error Resume Next
Err.Clear

'set url, doc, & flags as required using this format:
'   url = "http://server.domain.com:52311/cgi-bin/bfgather.exe/actionsite"
'and either compliance check:
'   doc = "ComplianceDoc.xml"
'   flags = COMPLIANCE_FLAG_GATHER + COMPLIANCE_FLAG_EVALUATE_ALL + COMPLIANCE_FLAG_IDLE_CPU_USAGE
'or action hint:
'   doc = "<actionid>"
'   flags = COMPLIANCE_FLAG_ACTIONHINT

If url = "" Or doc = "" Then

	WScript.echo "You must set url, doc, and flags in this script"

Else

	t = session.Open(url, doc, flags)

	If t <> 0 Then 

		WScript.echo "Open Error: " + FormatNumber(t)

	Else

		' To free up resource, make sure to perform session.Close
		' after session completes and you are done looking at results

		Dim compliance_progress

		Do
			compliance_progress = progress.SessionProgress

			If compliance_progress  = COMPLIANCE_PROGRESS_BUSY Then

				percent = progress.GetPercent
				WScript.echo "Percent: " + FormatNumber(percent)
				WScript.Sleep(10)

			End If

		Loop While compliance_progress = COMPLIANCE_PROGRESS_BUSY


		If compliance_progress = COMPLIANCE_PROGRESS_COMPLETE Then

			count = response.ResultCount
			WScript.echo "Count is " + FormatNumber(count)

			max_index = count - 1
			For i = 0 to max_index

				d = response.GetDesignator(i)
				r = response.GetRelevanceResult(i)
				x = response.GetDescription(i)
				c = response.GetComment(i)
				t = response.GetResultType(i)
				e = response.GetEvalTime(i)

				WScript.echo "D: " +d+ "  R: " +r+ "  X: " +x+ "  C: " +c+"  T: " +t+"  E: " +e

			Next

		ElseIf compliance_progress = COMPLIANCE_PROGRESS_ERROR Then

			error   = progress.GetError
			
			If error = COMPLIANCE_ERROR_CHANGING_CONDITIONS Then
				WScript.echo "Client reports not available right now."
			Else
				WScript.echo "Error: " + FormatNumber(error)
			End If

		End If

		session.Close

	End If
End If
